/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.RollCycleRetriever;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RollCycleRetrieverTest {
    private static final RollCycles ROLL_CYCLE = RollCycles.TEST_SECONDLY;
    private static final WireType WIRE_TYPE = WireType.BINARY;

    @Test
    public void shouldRetrieveCorrectRollCycleFromExistingQueueFile() throws Exception {
        File queuePath = DirectoryUtils.tempDir(RollCycleRetrieverTest.class.getSimpleName() + System.nanoTime());
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.builder((File)queuePath, (WireType)WIRE_TYPE).testBlockSize().rollCycle((RollCycle)ROLL_CYCLE);
        try (SingleChronicleQueue queue = builder.build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext context = appender.writingDocument();){
                context.wire().write((CharSequence)"foo").text("bar");
            }
        }
        Assert.assertThat((Object)RollCycleRetriever.getRollCycle((Path)queuePath.toPath(), (WireType)WIRE_TYPE, (long)builder.blockSize()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(RollCycleRetriever.getRollCycle((Path)queuePath.toPath(), (WireType)WIRE_TYPE, (long)builder.blockSize()).get(), (Matcher)CoreMatchers.is((Object)ROLL_CYCLE));
    }

    @Test
    public void shouldReturnEmptyWhenQueueDirDoesNotExist() throws Exception {
        Path nonExistentPath = Paths.get("non", "existent", "file", Long.toHexString(System.nanoTime()));
        Assert.assertThat((Object)RollCycleRetriever.getRollCycle((Path)nonExistentPath, (WireType)WIRE_TYPE, (long)4096L).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldReturnEmptyWhenNoQueueFilesHaveBeenWritten() throws Exception {
        File queuePath = DirectoryUtils.tempDir(RollCycleRetrieverTest.class.getSimpleName() + System.nanoTime());
        Assert.assertTrue((boolean)queuePath.mkdirs());
        Assert.assertThat((Object)RollCycleRetriever.getRollCycle((Path)queuePath.toPath(), (WireType)WIRE_TYPE, (long)4096L).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }
}

