/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaEventLoop
implements EventLoop,
Runnable,
Closeable {
    public static final int NO_CPU = -1;
    private static final Logger LOG = LoggerFactory.getLogger(VanillaEventLoop.class);
    private static final EventHandler[] NO_EVENT_HANDLERS = new EventHandler[0];
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private final List<EventHandler> highHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> mediumHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> timerHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> daemonHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final AtomicReference<EventHandler> newHandler = new AtomicReference();
    private final Queue<EventHandler> newHandlerQueue = new LinkedTransferQueue<EventHandler>();
    private final Pauser pauser;
    private final long timerIntervalMS;
    private final String name;
    private final boolean binding;
    private final int bindingCpu;
    @NotNull
    private EventHandler[] mediumHandlersArray = NO_EVENT_HANDLERS;
    private long lastTimerNS;
    private volatile long loopStartMS;
    @NotNull
    private volatile AtomicBoolean running = new AtomicBoolean();
    @Nullable
    private volatile Thread thread = null;
    @Nullable
    private volatile Throwable closedHere = null;

    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, boolean binding, int bindingCpu) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.timerIntervalMS = timerIntervalMS;
        this.binding = binding;
        this.bindingCpu = bindingCpu;
        this.loopStartMS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon));
    }

    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, boolean binding) {
        this(parent, name, pauser, timerIntervalMS, daemon, binding, -1);
    }

    public static void closeAll(@NotNull List<EventHandler> handlers) {
        handlers.forEach(h -> {
            if (h instanceof Closeable) {
                Closeable.closeQuietly(h);
            } else {
                handlers.remove(h);
            }
        });
    }

    @Override
    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    public String toString() {
        return "VanillaEventLoop{name='" + this.name + '\'' + ", parent=" + this.parent + ", service=" + this.service + ", highHandlers=" + this.highHandlers + ", mediumHandlers=" + this.mediumHandlers + ", timerHandlers=" + this.timerHandlers + ", daemonHandlers=" + this.daemonHandlers + ", newHandler=" + this.newHandler + ", newHandlerQueue=" + this.newHandlerQueue + ", pauser=" + this.pauser + ", closedHere=" + this.closedHere + '}';
    }

    @Override
    public void start() {
        if (this.closedHere != null) {
            throw new IllegalStateException("Event Group has been closed", this.closedHere);
        }
        if (!this.running.getAndSet(true)) {
            this.service.submit(this);
        }
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isClosed() {
        return this.closedHere != null;
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        this.addHandler(false, handler);
    }

    @Override
    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
        } else {
            if (!this.running.get()) {
                if (!dontAttemptToRunImmediatelyInCurrentThread) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            Jvm.debug().on(this.getClass(), "Running " + handler + " in the current thread as " + this + " has finished");
                        }
                        handler.action();
                    }
                    catch (InterruptedException e) {
                        Jvm.warn().on(this.getClass(), e);
                    }
                    catch (InvalidEventHandlerException invalidEventHandlerException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.pauser.unpause();
            if (!this.newHandler.compareAndSet(null, handler)) {
                this.newHandlerQueue.add(handler);
            }
        }
    }

    public long loopStartMS() {
        return this.loopStartMS;
    }

    @Override
    @HotMethod
    public void run() {
        AffinityLock affinityLock = null;
        try {
            if (this.bindingCpu != -1) {
                affinityLock = AffinityLock.acquireLock(this.bindingCpu);
            } else if (this.binding) {
                affinityLock = AffinityLock.acquireLock();
            }
            this.thread = Thread.currentThread();
            this.runLoop();
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), "Loop terminated due to exception", e);
        }
        finally {
            this.loopStartMS = 0x7FFFFFFFFFFFFFFEL;
            if (affinityLock != null) {
                affinityLock.release();
            }
        }
    }

    private void runLoop() {
        while (this.running.get() && !Thread.currentThread().isInterrupted()) {
            if (this.closedHere != null) {
                this.closeAll();
                break;
            }
            boolean busy = this.highHandlers.isEmpty() ? this.runMediumLoopOnly() : this.runHighAndMediumTasks();
            if (this.lastTimerNS + this.timerIntervalMS < this.loopStartMS) {
                this.lastTimerNS = this.loopStartMS;
                this.runTimerHandlers();
            }
            if (busy) {
                this.pauser.reset();
                continue;
            }
            if (this.acceptNewHandlers()) continue;
            this.runDaemonHandlers();
            this.loopStartMS = Long.MAX_VALUE;
            this.pauser.pause();
        }
    }

    private boolean runMediumLoopOnly() {
        this.loopStartMS = Time.currentTimeMillis();
        return this.runAllMediumHandler();
    }

    private boolean runHighAndMediumTasks() {
        boolean busy = false;
        for (int i = 0; i < 4; ++i) {
            this.loopStartMS = Time.currentTimeMillis();
            busy |= this.runAllHighHandlers();
            busy |= this.runOneQuarterMediumHandler(i);
        }
        return busy;
    }

    private void closeAll() {
        LOG.trace("Closing down handlers");
        this.closeAllHandlers();
        this.runAllHighHandlers();
        this.runAllMediumHandler();
        this.runDaemonHandlers();
        this.runTimerHandlers();
        LOG.trace("Remaining handlers");
        this.dumpRunningHandlers();
    }

    @HotMethod
    private boolean runAllHighHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.highHandlers.size(); ++i) {
            EventHandler handler = this.highHandlers.get(i);
            try {
                boolean action = handler.action();
                busy |= action;
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler, this.highHandlers);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
        return busy;
    }

    @HotMethod
    private boolean runOneQuarterMediumHandler(int i) {
        boolean busy = false;
        EventHandler[] mediumHandlersArray = this.mediumHandlersArray;
        for (int j = i; j < mediumHandlersArray.length; j += 4) {
            EventHandler handler = mediumHandlersArray[j];
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler, this.mediumHandlers);
                this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
                continue;
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
        return busy;
    }

    @HotMethod
    private boolean runAllMediumHandler() {
        boolean busy = false;
        EventHandler[] mediumHandlersArray = this.mediumHandlersArray;
        for (int j = 0; j < mediumHandlersArray.length; ++j) {
            EventHandler handler = mediumHandlersArray[j];
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler, this.mediumHandlers);
                this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
        return busy;
    }

    @HotMethod
    private void runTimerHandlers() {
        for (int i = 0; i < this.timerHandlers.size(); ++i) {
            EventHandler handler = null;
            try {
                handler = this.timerHandlers.get(i);
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler, this.timerHandlers);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
    }

    @HotMethod
    private void runDaemonHandlers() {
        for (int i = 0; i < this.daemonHandlers.size(); ++i) {
            EventHandler handler = null;
            try {
                handler = this.daemonHandlers.get(i);
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(handler, this.daemonHandlers);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), e);
            }
        }
    }

    private void removeHandler(EventHandler handler, @NotNull List<EventHandler> handlers) {
        block2: {
            try {
                handlers.remove(handler);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (handlers.isEmpty()) break block2;
                throw e2;
            }
        }
        Closeable.closeQuietly((Object)handler);
    }

    @HotMethod
    private boolean acceptNewHandlers() {
        boolean busy = false;
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
            busy = true;
        }
        while ((handler = this.newHandlerQueue.poll()) != null) {
            this.addNewHandler(handler);
            busy = true;
        }
        return busy;
    }

    private void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1 == null ? HandlerPriority.MEDIUM : t1) {
            case HIGH: {
                if (this.highHandlers.contains(handler)) break;
                this.highHandlers.add(handler);
                break;
            }
            case REPLICATION: 
            case CONCURRENT: 
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                this.mediumHandlers.add(handler);
                this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
                break;
            }
            case TIMER: {
                if (this.timerHandlers.contains(handler)) break;
                this.timerHandlers.add(handler);
                break;
            }
            case DAEMON: {
                if (this.daemonHandlers.contains(handler)) break;
                this.daemonHandlers.add(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
            }
        }
        handler.eventLoop(this.parent);
    }

    public String name() {
        return this.name;
    }

    public void dumpRunningState(@NotNull String message, @NotNull BooleanSupplier finalCheck) {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        Jvm.trimStackTrace(out, thread.getStackTrace());
        if (finalCheck.getAsBoolean() && LOG.isInfoEnabled()) {
            LOG.info(out.toString());
        }
    }

    public int handlerCount() {
        return this.highHandlers.size() + this.mediumHandlers.size() + this.daemonHandlers.size() + this.timerHandlers.size();
    }

    @Override
    public void close() {
        try {
            this.closedHere = Jvm.isDebug() ? new Throwable("Closed here") : null;
            this.closeAllHandlers();
            if (this.thread == null) {
                return;
            }
            for (int i = 0; i < 30; ++i) {
                this.pauser.unpause();
                Jvm.pause(10L);
                if (this.handlerCount() == 0) break;
                if (i % 10 == 4) {
                    LockSupport.unpark(this.thread);
                    this.thread.interrupt();
                }
                if (i % 10 != 9) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("Shutting down thread is executing ").append(this.thread).append(", handlerCount=").append(this.handlerCount()).append("\n");
                Jvm.trimStackTrace(sb, this.thread.getStackTrace());
                Jvm.warn().on(this.getClass(), sb.toString());
                this.dumpRunningHandlers();
            }
            this.running.set(false);
            this.pauser.unpause();
            if (!this.service.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                Threads.shutdown(this.service);
            }
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (InterruptedException e) {
            Threads.shutdown(this.service);
        }
        finally {
            this.highHandlers.clear();
            this.mediumHandlers.clear();
            this.mediumHandlersArray = NO_EVENT_HANDLERS;
            this.daemonHandlers.clear();
            this.timerHandlers.clear();
            this.newHandlerQueue.clear();
            this.newHandler.set(null);
        }
    }

    public void closeAllHandlers() {
        EventHandler o;
        VanillaEventLoop.closeAll(this.highHandlers);
        VanillaEventLoop.closeAll(this.mediumHandlers);
        VanillaEventLoop.closeAll(this.daemonHandlers);
        VanillaEventLoop.closeAll(this.timerHandlers);
        Optional.ofNullable(this.newHandler.get()).ifPresent(eventHandler -> {
            Jvm.warn().on(this.getClass(), "Handler in newHandler was not accepted before close " + eventHandler);
            Closeable.closeQuietly(eventHandler);
        });
        while ((o = this.newHandlerQueue.poll()) != null) {
            Jvm.warn().on(this.getClass(), "Handler in newHandlerQueue was not accepted before close " + o);
            Closeable.closeQuietly((Object)o);
        }
    }

    public void dumpRunningHandlers() {
        int handlerCount = this.handlerCount();
        if (handlerCount <= 0) {
            return;
        }
        List<EventHandler> collect = Stream.of(this.highHandlers, this.mediumHandlers, this.daemonHandlers, this.timerHandlers).flatMap(Collection::stream).filter(e -> e instanceof Closeable).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        LOG.info("Handlers still running after being closed, handlerCount=" + handlerCount);
        collect.forEach(h -> LOG.info("\t" + h));
    }

    @Override
    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }
}

