/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public final class RollAtEndOfCycleTest {
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());

    @Test
    public void shouldRollAndAppendToNewFile() throws Exception {
        try (SingleChronicleQueue queue = this.createQueue();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)1, (w, i) -> w.int32(i.intValue()));
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext context = tailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 1L);
            this.clock.addAndGet(TimeUnit.SECONDS.toMillis(2L));
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            appender.writeDocument((Object)2, (w, i) -> w.int32(i.intValue()));
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 2L);
            context = tailer.readingDocument();
            var6_8 = null;
            try {
                Assert.assertTrue((boolean)context.isPresent());
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var6_8 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            ExcerptTailer newTailer = queue.createTailer();
            int totalCount = 0;
            while (true) {
                DocumentContext context;
                if ((context = newTailer.readingDocument()).isPresent() && context.isData()) {
                    Assert.assertTrue((context.wire().read().int32() != 0 ? 1 : 0) != 0);
                    ++totalCount;
                    continue;
                }
                if (!context.isPresent()) break;
            }
            Assert.assertThat((Object)totalCount, (Matcher)CoreMatchers.is((Object)2));
        }
    }

    @Test
    public void shouldAppendToExistingQueueFile() throws Exception {
        try (SingleChronicleQueue queue = this.createQueue();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)1, (w, i) -> w.int32(i.intValue()));
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext context = tailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 1L);
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            appender.writeDocument((Object)2, (w, i) -> w.int32(i.intValue()));
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 1L);
            context = tailer.readingDocument();
            var6_8 = null;
            try {
                Assert.assertTrue((boolean)context.isPresent());
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var6_8 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
        }
    }

    private static void assertQueueFileCount(Path path, long expectedCount) throws IOException {
        long count = Files.list(path).filter(p -> p.toString().endsWith(".cq4")).count();
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)expectedCount));
    }

    private SingleChronicleQueue createQueue() {
        return SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir(RollAtEndOfCycleTest.class.getName())).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().timeProvider(this.clock::get).build();
    }
}

