/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RollingResourcesCacheTest {
    private static final long SEED = 2983472039423847L;
    private static final long BUGGY_EPOCH = 1284739200000L;
    private static final String FILE_NAME = "19761020";
    private static final int CYCLE_NUMBER = 2484;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final RollCycles ROLL_CYCLE = RollCycles.DAILY;
    private static final long ONE_DAY_IN_MILLIS = TimeUnit.DAYS.toMillis(1L);
    private static final boolean LOG_TEST_DEBUG = Boolean.valueOf(RollingResourcesCacheTest.class.getSimpleName() + ".debug");

    @Test
    public void shouldConvertCyclesToResourceNamesWithNoEpoch() throws Exception {
        boolean epoch = false;
        RollingResourcesCache cache = new RollingResourcesCache((RollCycle)ROLL_CYCLE, 0L, File::new, File::getName);
        int cycle = ROLL_CYCLE.current(System::currentTimeMillis, 0L);
        RollingResourcesCacheTest.assertCorrectConversion(cache, cycle, Instant.now(), DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("GMT")));
    }

    @Test
    public void shouldCorrectlyConvertCyclesToResourceNamesWithEpoch() throws Exception {
        RollingResourcesCache cache = new RollingResourcesCache((RollCycle)ROLL_CYCLE, 1284739200000L, File::new, File::getName);
        Assert.assertThat((Object)cache.resourceFor((long)2484L).text, (Matcher)CoreMatchers.is((Object)FILE_NAME));
        Assert.assertThat((Object)cache.parseCount(FILE_NAME), (Matcher)CoreMatchers.is((Object)2484));
    }

    @Test(expected=RuntimeException.class)
    public void parseIncorrectlyFormattedName() throws Exception {
        RollingResourcesCache cache = new RollingResourcesCache((RollCycle)RollCycles.HOURLY, 1284739200000L, File::new, File::getName);
        cache.parseCount("foobar-qux");
    }

    @Test
    public void fuzzyConversionTest() throws Exception {
        int maxAddition = (int)ChronoUnit.DECADES.getDuration().toMillis();
        Random random = new Random(2983472039423847L);
        for (int i = 0; i < 1000; ++i) {
            long epoch = random.nextInt(maxAddition);
            RollingResourcesCache cache = new RollingResourcesCache((RollCycle)ROLL_CYCLE, epoch, File::new, File::getName);
            for (int j = 0; j < 200; ++j) {
                long offsetMillisFromEpoch = TimeUnit.DAYS.toMillis(random.nextInt(500)) + TimeUnit.HOURS.toMillis(random.nextInt(50)) + TimeUnit.MINUTES.toMillis(random.nextInt(50));
                long instantAfterEpoch = epoch + offsetMillisFromEpoch;
                long moduloMillis = epoch % ONE_DAY_IN_MILLIS;
                boolean adjustForNegativeOffset = Math.abs(moduloMillis) > ONE_DAY_IN_MILLIS / 2L;
                long offsetMillis = moduloMillis < ONE_DAY_IN_MILLIS / 2L ? moduloMillis : -(ONE_DAY_IN_MILLIS - moduloMillis);
                int offsetSeconds = (int)(offsetMillis / 1000L);
                ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSeconds);
                ZoneId zoneId = ZoneId.ofOffset("GMT", offset);
                int cycle = ROLL_CYCLE.current(() -> instantAfterEpoch, epoch);
                long daysBetweenEpochAndInstant = (instantAfterEpoch - epoch) / ONE_DAY_IN_MILLIS;
                Assert.assertThat((Object)cycle, (Matcher)CoreMatchers.is((Object)daysBetweenEpochAndInstant));
                Assert.assertThat((Object)((long)cycle * ONE_DAY_IN_MILLIS), (Matcher)CoreMatchers.is((Object)((long)cycle * (long)ROLL_CYCLE.length())));
                if (LOG_TEST_DEBUG) {
                    System.out.printf("Epoch: %d%n", epoch);
                    System.out.printf("Offset seconds: %d, zone: %s%n", offsetSeconds, zoneId);
                    System.out.printf("Epoch millis: %d(UTC+%dd), current millis: %d(UTC+%dd)%n", epoch, epoch / ONE_DAY_IN_MILLIS, instantAfterEpoch, instantAfterEpoch / ONE_DAY_IN_MILLIS);
                    System.out.printf("Epoch date: %s, Current date: %s, Delta days: %d, Delta millis: %d, Delta days in millis: %d%n", FORMATTER.format(Instant.ofEpochMilli(epoch).atOffset(offset)), FORMATTER.format(Instant.ofEpochMilli(instantAfterEpoch).atOffset(offset)), daysBetweenEpochAndInstant, instantAfterEpoch - epoch, daysBetweenEpochAndInstant * ONE_DAY_IN_MILLIS);
                    System.out.printf("Effective date relative to epoch: %s, millisSinceEpoch: %d%n", FORMATTER.format(Instant.ofEpochMilli(instantAfterEpoch - epoch).atOffset(offset)), offsetMillisFromEpoch);
                    System.out.printf("Resource calc of millisSinceEpoch: %d%n", daysBetweenEpochAndInstant * ONE_DAY_IN_MILLIS);
                }
                long effectiveCycleStartTime = instantAfterEpoch - epoch - (instantAfterEpoch - epoch) % ONE_DAY_IN_MILLIS;
                if (adjustForNegativeOffset) {
                    effectiveCycleStartTime += ONE_DAY_IN_MILLIS;
                }
                RollingResourcesCacheTest.assertCorrectConversion(cache, cycle, Instant.ofEpochMilli(effectiveCycleStartTime), DateTimeFormatter.ofPattern("yyyyMMdd").withZone(zoneId));
            }
        }
    }

    private static void assertCorrectConversion(RollingResourcesCache cache, int cycle, Instant instant, DateTimeFormatter formatter) {
        String expectedFileName = formatter.format(instant);
        Assert.assertThat((Object)cache.resourceFor((long)((long)cycle)).text, (Matcher)CoreMatchers.is((Object)expectedFileName));
        Assert.assertThat((Object)cache.parseCount(expectedFileName), (Matcher)CoreMatchers.is((Object)cycle));
    }
}

