/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CreateAtIndexTest {
    @Test
    public void testWriteBytesWithIndex() throws Exception {
        SingleChronicleQueueExcerpts.InternalAppender appender;
        String tmp = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            appender = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
            appender.writeBytes(72692321484800L, (BytesStore)Bytes.from((CharSequence)"hello world"));
            appender.writeBytes(72692321484801L, (BytesStore)Bytes.from((CharSequence)"hello world"));
        }
        queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();
        var3_4 = null;
        try {
            appender = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
            appender.writeBytes(72692321484800L, (BytesStore)Bytes.from((CharSequence)"hello world"));
        }
        catch (Throwable appender2) {
            var3_4 = appender2;
            throw appender2;
        }
        finally {
            if (queue != null) {
                if (var3_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender2) {
                        var3_4.addSuppressed(appender2);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();
        var3_4 = null;
        try {
            appender = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
            try {
                appender.writeBytes(72692321484803L, (BytesStore)Bytes.from((CharSequence)"hello world"));
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)"Unable to move to index 421d00000003 beyond the end of the queue", (Object)e.getMessage());
            }
        }
        catch (Throwable appender3) {
            var3_4 = appender3;
            throw appender3;
        }
        finally {
            if (queue != null) {
                if (var3_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender3) {
                        var3_4.addSuppressed(appender3);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();
        var3_4 = null;
        try {
            appender = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
            appender.writeBytes(72692321484802L, (BytesStore)Bytes.from((CharSequence)"hello world"));
            appender.writeBytes(72692321484803L, (BytesStore)Bytes.from((CharSequence)"hello world"));
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var3_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var3_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
        try {
            IOTools.deleteDirWithFiles((String)tmp, (int)2);
        }
        catch (IORuntimeException iORuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testWrittenAndReadIndexesAreTheSameOfTheFirstExcerpt() throws Exception {
        String tmp = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        long expected = 0L;
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("some-data");
                expected = dc.index();
                Assert.assertTrue((expected > 0L ? 1 : 0) != 0);
            }
            appender.lastIndexAppended();
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                String text = dc.wire().read().text();
                long actualIndex = dc.index();
                Assert.assertTrue((actualIndex > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)expected, (long)actualIndex);
                actualIndex = tailer.index();
                Assert.assertTrue((actualIndex > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)expected, (long)actualIndex);
            }
        }
    }

    @After
    public void checkRegisteredBytes() {
        BytesUtil.checkRegisteredBytes();
    }
}

