/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.BusyPauser;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.YieldingPauser;
import org.jetbrains.annotations.NotNull;

public interface Pauser {
    public static final int MIN_PROCESSORS = Integer.getInteger("pauser.minProcessors", 8);
    public static final boolean SLEEPY = Pauser.getSleepy();

    public static boolean getSleepy() {
        int procs = Runtime.getRuntime().availableProcessors();
        if (procs < MIN_PROCESSORS) {
            Jvm.warn().on(Pauser.class, "Using Pauser.sleepy() as not enough processors, have " + procs + ", needs " + MIN_PROCESSORS + "+");
            return true;
        }
        return false;
    }

    public static Pauser sleepy() {
        return new LongPauser(0, 20, 500L, 20000L, TimeUnit.MICROSECONDS);
    }

    public static Pauser balanced() {
        return Pauser.balancedUpToMillis(20);
    }

    public static Pauser balancedUpToMillis(int millis) {
        return SLEEPY ? Pauser.sleepy() : new LongPauser(1000, 200, 250L, (Jvm.isDebug() ? 200000 : 0) + millis * 1000, TimeUnit.MICROSECONDS);
    }

    public static Pauser millis(int millis) {
        return Pauser.millis(millis, millis);
    }

    public static Pauser millis(int minMillis, int maxMillis) {
        return new LongPauser(0, 0, minMillis, maxMillis, TimeUnit.MILLISECONDS);
    }

    public static Pauser yielding() {
        return Pauser.yielding(2);
    }

    public static Pauser yielding(int minBusy) {
        return SLEEPY ? Pauser.sleepy() : new YieldingPauser(minBusy);
    }

    @NotNull
    public static Pauser busy() {
        return SLEEPY ? Pauser.sleepy() : BusyPauser.INSTANCE;
    }

    public void reset();

    public void pause();

    public void pause(long var1, TimeUnit var3) throws TimeoutException;

    public void unpause();

    public long timePaused();

    public long countPaused();
}

