/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.RollCycles;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollCyclesTest {
    private static final long NO_EPOCH_OFFSET = 0L;
    private static final long SOME_EPOCH_OFFSET = 629L;
    private static final RollCycles[] TEST_DATA = new RollCycles[]{RollCycles.DAILY, RollCycles.HOURLY, RollCycles.MINUTELY, RollCycles.HUGE_DAILY};
    private final RollCycles cycle;
    private final AtomicLong clock = new AtomicLong();
    private final TimeProvider timeProvider = this.clock::get;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (RollCycles testDatum : TEST_DATA) {
            data.add(new Object[]{testDatum.name(), testDatum});
        }
        return data;
    }

    public RollCyclesTest(String cycleName, RollCycles cycle) {
        this.cycle = cycle;
    }

    @Test
    public void shouldDetermineCurrentCycle() throws Exception {
        this.assertCycleRollTimes(0L, RollCyclesTest.withDelta(this.timeProvider, 0L));
    }

    @Test
    public void shouldTakeEpochIntoAccoutWhenCalculatingCurrentCycle() throws Exception {
        this.assertCycleRollTimes(629L, RollCyclesTest.withDelta(this.timeProvider, 629L));
    }

    private void assertCycleRollTimes(long epochOffset, TimeProvider timeProvider) {
        long currentTime = System.currentTimeMillis();
        long currentTimeAtStartOfCycle = currentTime - currentTime % (long)this.cycle.length();
        this.clock.set(currentTimeAtStartOfCycle);
        int startCycle = this.cycle.current(timeProvider, epochOffset);
        this.clock.addAndGet(this.cycle.length());
        Assert.assertThat((Object)this.cycle.current(timeProvider, epochOffset), (Matcher)CoreMatchers.is((Object)(startCycle + 1)));
        Assert.assertThat((Object)this.cycle.current(RollCyclesTest.plusOneMillisecond(timeProvider), epochOffset), (Matcher)CoreMatchers.is((Object)(startCycle + 1)));
        Assert.assertThat((Object)this.cycle.current(RollCyclesTest.minusOneMillisecond(timeProvider), epochOffset), (Matcher)CoreMatchers.is((Object)startCycle));
        this.clock.addAndGet(this.cycle.length());
        Assert.assertThat((Object)this.cycle.current(timeProvider, epochOffset), (Matcher)CoreMatchers.is((Object)(startCycle + 2)));
        Assert.assertThat((Object)this.cycle.current(RollCyclesTest.plusOneMillisecond(timeProvider), epochOffset), (Matcher)CoreMatchers.is((Object)(startCycle + 2)));
        Assert.assertThat((Object)this.cycle.current(RollCyclesTest.minusOneMillisecond(timeProvider), epochOffset), (Matcher)CoreMatchers.is((Object)(startCycle + 1)));
    }

    private static TimeProvider withDelta(TimeProvider delegate, long deltaMillis) {
        return () -> delegate.currentTimeMillis() + deltaMillis;
    }

    private static TimeProvider plusOneMillisecond(TimeProvider delegate) {
        return () -> delegate.currentTimeMillis() + 1L;
    }

    private static TimeProvider minusOneMillisecond(TimeProvider delegate) {
        return () -> delegate.currentTimeMillis() - 1L;
    }
}

