/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class TimedStoreRecovery
extends AbstractMarshallable
implements StoreRecovery,
Demarshallable {
    public static final StoreRecoveryFactory FACTORY = TimedStoreRecovery::new;
    private final LongValue timeStamp;

    @UsedViaReflection
    public TimedStoreRecovery(@NotNull WireIn in) {
        this.timeStamp = in.read("timeStamp").int64ForBinding(in.newLongReference());
    }

    public TimedStoreRecovery(@NotNull WireType wireType) {
        this.timeStamp = wireType.newLongReference().get();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut out) {
        out.write("timeStamp").int64forBinding(0L);
    }

    @NotNull
    private static ExceptionHandler warn() {
        return Slf4jExceptionHandler.WARN;
    }

    long acquireLock(long timeoutMS) {
        long start = System.currentTimeMillis();
        while (true) {
            long now = System.currentTimeMillis();
            long ts = this.timeStamp.getVolatileValue();
            long tsEnd = now + timeoutMS / 2L;
            if (ts < now && this.timeStamp.compareAndSwapValue(ts, tsEnd)) {
                return tsEnd;
            }
            if (now >= start + timeoutMS) {
                TimedStoreRecovery.warn().on(this.getClass(), "Unable to obtain the global lock in time, retrying");
                start = now;
            }
            Jvm.pause(1L);
        }
    }

    void releaseLock(long tsEnd) {
        if (this.timeStamp.compareAndSwapValue(tsEnd, 0L)) {
            return;
        }
        TimedStoreRecovery.warn().on(this.getClass(), "Another thread obtained the lock ??");
    }

    @Override
    public long recoverIndex2Index(@NotNull LongValue index2Index, @NotNull Callable<Long> action, long timeoutMS) throws UnrecoverableTimeoutException {
        long tsEnd = this.acquireLock(timeoutMS);
        if (index2Index.getValue() == -1L) {
            TimedStoreRecovery.warn().on(this.getClass(), "Rebuilding the index2index, resetting to 0");
            index2Index.setValue(0L);
        } else {
            TimedStoreRecovery.warn().on(this.getClass(), "The index2index value has changed, assuming it was recovered");
        }
        try {
            long l = action.call();
            return l;
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
        finally {
            this.releaseLock(tsEnd);
        }
    }

    @Override
    public long recoverSecondaryAddress(@NotNull LongArrayValues index2indexArr, int index2, @NotNull Callable<Long> action, long timeoutMS) throws UnrecoverableTimeoutException {
        long tsEnd = this.acquireLock(timeoutMS);
        if (index2indexArr.getValueAt(index2) == -1L) {
            TimedStoreRecovery.warn().on(this.getClass(), "Rebuilding the index2index[" + index2 + "], resetting to 0");
            index2indexArr.setValueAt(index2, 0L);
        } else {
            TimedStoreRecovery.warn().on(this.getClass(), "The index2index[" + index2 + "] value has changed, assuming it was recovered");
        }
        try {
            long l = action.call();
            return l;
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
        finally {
            this.releaseLock(tsEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long recoverAndWriteHeader(@NotNull Wire wire, long timeoutMS, LongValue lastPosition, Sequence sequence) throws UnrecoverableTimeoutException, EOFException {
        Bytes<?> bytes = wire.bytes();
        long offset = bytes.writePosition();
        int num = bytes.readVolatileInt(offset);
        long targetHeaderNumber = wire.headerNumber() + 1L;
        String msgStart = "Unable to write a header at header number: 0x" + Long.toHexString(targetHeaderNumber) + " position: " + offset;
        if (Wires.isNotComplete(num)) {
            int sizeToSkip = 32768;
            if (bytes instanceof MappedBytes) {
                MappedBytes mb = (MappedBytes)bytes;
                sizeToSkip = Maths.toUInt31(mb.mappedFile().overlapSize() / 2L);
            }
            sizeToSkip = sizeToSkip + 3 & 0xFFFFFFFC;
            sizeToSkip -= (int)(offset & 3L);
            long pos = bytes.writePosition();
            try {
                bytes.writeSkip(4L);
                wire.getValueOut().text("!! Skipped due to recovery of locked header !!");
                wire.addPadding(Math.toIntExact((long)sizeToSkip + (pos + 4L) - bytes.writePosition()));
            }
            finally {
                bytes.writePosition(pos);
            }
            int emptyMetaData = 0x40000000 | sizeToSkip;
            if (bytes.compareAndSwapInt(offset, num, emptyMetaData)) {
                TimedStoreRecovery.warn().on(this.getClass(), msgStart + " switching to a corrupt meta data message");
                bytes.writeSkip(sizeToSkip + 4);
            } else {
                int num2 = bytes.readVolatileInt(offset);
                TimedStoreRecovery.warn().on(this.getClass(), msgStart + " already set to " + Integer.toHexString(num2));
            }
        } else {
            TimedStoreRecovery.warn().on(this.getClass(), msgStart + " but message now exists.");
        }
        try {
            return wire.writeHeaderOfUnknownLength(timeoutMS, TimeUnit.MILLISECONDS, lastPosition, sequence);
        }
        catch (TimeoutException e) {
            TimedStoreRecovery.warn().on(this.getClass(), e);
            return this.recoverAndWriteHeader(wire, timeoutMS, lastPosition, sequence);
        }
        catch (EOFException e) {
            throw new AssertionError((Object)e);
        }
    }
}

