/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.bytes.UncheckedNativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Bytes<Underlying>
extends BytesStore<Bytes<Underlying>, Underlying>,
BytesIn<Underlying>,
BytesOut<Underlying> {
    public static final long MAX_CAPACITY = Long.MAX_VALUE;
    public static final int MAX_BYTE_BUFFER_CAPACITY = Integer.MAX_VALUE & ~(OS.pageSize() - 1);
    public static final int DEFAULT_BYTE_BUFFER_CAPACITY = 256;

    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return Bytes.elasticByteBuffer(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bytes<ByteBuffer> elasticByteBuffer(int initialCapacity, int maxSize) {
        NativeBytesStore<ByteBuffer> bs = NativeBytesStore.elasticByteBuffer(initialCapacity, maxSize);
        try {
            Bytes bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<ByteBuffer> elasticByteBuffer(int initialCapacity) {
        return Bytes.elasticByteBuffer(initialCapacity, MAX_BYTE_BUFFER_CAPACITY);
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticHeapByteBuffer(int initialCapacity) {
        HeapBytesStore<ByteBuffer> bs = HeapBytesStore.wrap(ByteBuffer.allocate(initialCapacity));
        try {
            NativeBytes<ByteBuffer> nativeBytes = new NativeBytes<ByteBuffer>(bs);
            return nativeBytes;
        }
        finally {
            bs.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bytes<ByteBuffer> wrapForRead(@NotNull ByteBuffer byteBuffer) {
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForRead();
            bbb.readLimit(byteBuffer.limit());
            bbb.readPosition(byteBuffer.position());
            Bytes<ByteBuffer> bytes = bbb;
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bytes<ByteBuffer> wrapForWrite(@NotNull ByteBuffer byteBuffer) {
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForWrite();
            bbb.writePosition(byteBuffer.position());
            bbb.writeLimit(byteBuffer.limit());
            Bytes<ByteBuffer> bytes = bbb;
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<byte[]> wrapForRead(@NotNull byte[] byteArray) {
        HeapBytesStore<byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForRead();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<byte[]> wrapForWrite(@NotNull byte[] byteArray) {
        HeapBytesStore<byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static Bytes<byte[]> from(@NotNull CharSequence text) {
        if (text instanceof BytesStore) {
            return ((BytesStore)text).copy().bytesForRead();
        }
        return Bytes.wrapForRead(text.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    public static Bytes<byte[]> fromString(@NotNull String text) throws IllegalArgumentException, IllegalStateException {
        return Bytes.wrapForRead(text.getBytes(StandardCharsets.ISO_8859_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VanillaBytes<Void> allocateDirect(long capacity) throws IllegalArgumentException {
        NativeBytesStore<Void> bs = NativeBytesStore.nativeStoreWithFixedCapacity(capacity);
        try {
            Bytes bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release();
        }
    }

    public static NativeBytes<Void> allocateElasticDirect() {
        return NativeBytes.nativeBytes();
    }

    public static NativeBytes<Void> allocateElasticDirect(long initialCapacity) throws IllegalArgumentException {
        return NativeBytes.nativeBytes(initialCapacity);
    }

    public static String toString(@NotNull Bytes<?> buffer) throws BufferUnderflowException {
        return Bytes.toString(buffer, 0x7FFFFFFBL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(@NotNull Bytes<?> buffer, long maxLen) throws BufferUnderflowException {
        if (buffer.refCount() < 1L) {
            return "<unknown>";
        }
        buffer.reserve();
        try {
            if (buffer.readRemaining() == 0L) {
                String string = "";
                return string;
            }
            long length = Math.min(maxLen + 1L, buffer.readRemaining());
            StringBuilder builder = new StringBuilder();
            try {
                buffer.readWithLength(length, (S b) -> {
                    while (buffer.readRemaining() > 0L) {
                        if ((long)builder.length() >= maxLen) {
                            builder.append("...");
                            break;
                        }
                        builder.append((char)buffer.readByte());
                    }
                });
            }
            catch (Exception e) {
                builder.append(' ').append(e);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(@NotNull Bytes buffer, long position, long len) throws BufferUnderflowException {
        long pos = buffer.readPosition();
        long limit = buffer.readLimit();
        buffer.readPositionRemaining(position, len);
        try {
            StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.readLimit(limit);
            buffer.readPosition(pos);
        }
    }

    @NotNull
    public static Bytes allocateDirect(@NotNull byte[] bytes) throws IllegalArgumentException {
        VanillaBytes<Void> result = Bytes.allocateDirect(bytes.length);
        try {
            result.write(bytes);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return result;
    }

    public static Bytes fromHexString(@NotNull String s) {
        return BytesInternal.fromHexString(s);
    }

    public static int indexOf(@NotNull BytesStore source, @NotNull BytesStore target, int fromIndex) {
        long sourceOffset = source.readPosition();
        long targetOffset = target.readPosition();
        long sourceCount = source.readRemaining();
        long targetCount = target.readRemaining();
        if ((long)fromIndex >= sourceCount) {
            return Math.toIntExact(targetCount == 0L ? sourceCount : -1L);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0L) {
            return fromIndex;
        }
        byte firstByte = target.readByte(targetOffset);
        long max = sourceOffset + (sourceCount - targetCount);
        for (long i = sourceOffset + (long)fromIndex; i <= max; ++i) {
            if (source.readByte(i) != firstByte) {
                while (++i <= max && source.readByte(i) != firstByte) {
                }
            }
            if (i > max) continue;
            long j = i + 1L;
            long end = j + targetCount - 1L;
            long k = targetOffset + 1L;
            while (j < end && source.readByte(j) == target.readByte(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return Math.toIntExact(i - sourceOffset);
        }
        return -1;
    }

    @NotNull
    default public Bytes<Underlying> unchecked(boolean unchecked) throws IllegalStateException {
        if (unchecked) {
            if (this.isElastic()) {
                Jvm.warn().on(this.getClass(), "Wrapping elastic bytes with unchecked() will convert it to fixed capacity!");
            }
            return this.start() == 0L && this.bytesStore().isDirectMemory() ? new UncheckedNativeBytes(this) : new UncheckedBytes(this);
        }
        return this;
    }

    default public boolean unchecked() {
        return false;
    }

    @Override
    default public long safeLimit() {
        return this.bytesStore().safeLimit();
    }

    @Override
    default public boolean isClear() {
        return this.start() == this.readPosition() && this.writeLimit() == this.capacity();
    }

    @Override
    default public long realCapacity() {
        return BytesStore.super.realCapacity();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy();

    @NotNull
    default public String toHexString() {
        return this.toHexString(1024L);
    }

    @NotNull
    default public String toHexString(long maxLength) {
        return this.toHexString(this.readPosition(), maxLength);
    }

    @NotNull
    default public String toHexString(long offset, long maxLength) {
        long maxLength2 = Math.min(maxLength, this.readLimit() - offset);
        String ret = BytesInternal.toHexString(this, offset, maxLength2);
        return maxLength2 < this.readLimit() - offset ? ret + "... truncated" : ret;
    }

    public boolean isElastic();

    default public void ensureCapacity(long size) throws IllegalArgumentException {
        if (size > this.capacity()) {
            throw new IllegalArgumentException(this.isElastic() ? "todo" : "not elastic");
        }
    }

    @Override
    @NotNull
    default public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        return this.isClear() ? BytesStore.super.bytesForRead() : new SubBytes((BytesStore)this, this.readPosition(), this.readLimit() + this.start());
    }

    @Override
    @Nullable
    public BytesStore bytesStore();

    default public boolean isEqual(String s) {
        return StringUtils.isEqual(this, (CharSequence)s);
    }

    @NotNull
    public Bytes<Underlying> compact();

    @Override
    default public long copyTo(@NotNull BytesStore store) {
        return BytesStore.super.copyTo(store);
    }

    @Override
    default public void copyTo(OutputStream out) throws IOException {
        BytesStore.super.copyTo(out);
    }

    @Override
    default public boolean sharedMemory() {
        return this.bytesStore().sharedMemory();
    }

    default public void unwrite(long fromOffset, int count) {
        this.write(fromOffset, this, fromOffset + (long)count, this.readRemaining() - 1L);
        this.writeSkip(-count);
    }

    @NotNull
    default public BigDecimal readBigDecimal() {
        return new BigDecimal(this.readBigInteger(), Maths.toUInt31(this.readStopBit()));
    }

    @NotNull
    default public BigInteger readBigInteger() {
        int length = Maths.toUInt31(this.readStopBit());
        byte[] bytes = new byte[length];
        this.read(bytes);
        return new BigInteger(bytes);
    }

    default public long indexOf(@NotNull Bytes source) {
        return this.indexOf(source, 0);
    }

    default public int indexOf(@NotNull BytesStore source, int fromIndex) {
        return Bytes.indexOf(this, source, fromIndex);
    }

    @Deprecated
    default public long indexOf(@NotNull Bytes source, int fromIndex) {
        return Bytes.indexOf(this, source, fromIndex);
    }

    @Override
    @NotNull
    public Bytes<Underlying> clear();

    @Override
    default public boolean readWrite() {
        return this.bytesStore().readWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength(long length, @NotNull BytesOut<Underlying> bytesOut) throws BufferUnderflowException, IORuntimeException {
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            bytesOut.write(this);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public <T extends ReadBytesMarshallable> T readMarshallableLength16(Class<T> tClass, T object) {
        if (object == null) {
            object = (ReadBytesMarshallable)ObjectUtils.newInstance(tClass);
        }
        int length = this.readUnsignedShort();
        long limit = this.readLimit();
        long end = this.readPosition() + (long)length;
        try {
            this.readLimit(end);
            object.readMarshallable(this);
        }
        finally {
            this.readPosition(end);
            this.readLimit(limit);
        }
        return (T)object;
    }

    @Override
    default public void writeMarshallableLength16(WriteBytesMarshallable marshallable) {
        long position = this.writePosition();
        this.writeUnsignedShort(0);
        marshallable.writeMarshallable(this);
        long length = this.writePosition() - position - 2L;
        if (length >= 65536L) {
            throw new IllegalStateException("Marshallable " + marshallable.getClass() + " too long was " + length);
        }
        this.writeUnsignedShort(position, (int)length);
    }
}

