/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableDirectoryListing
implements DirectoryListing {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDirectoryListing.class);
    private static final String HIGHEST_CREATED_CYCLE = "listing.highestCycle";
    private static final String LOWEST_CREATED_CYCLE = "listing.lowestCycle";
    static final String LOCK = "listing.exclusiveLock";
    private static final String MOD_COUNT = "listing.modCount";
    private static final int UNSET_MAX_CYCLE = Integer.MIN_VALUE;
    private static final int UNSET_MIN_CYCLE = Integer.MAX_VALUE;
    private final TableStore tableStore;
    private final Path queuePath;
    private final ToIntFunction<File> fileToCycleFunction;
    private volatile LongValue maxCycleValue;
    private volatile LongValue minCycleValue;
    private volatile LongValue lock;
    private volatile LongValue modCount;
    private final boolean readOnly;

    TableDirectoryListing(TableStore tableStore, Path queuePath, ToIntFunction<File> fileToCycleFunction, boolean readOnly) {
        this.tableStore = tableStore;
        this.queuePath = queuePath;
        this.fileToCycleFunction = fileToCycleFunction;
        this.readOnly = readOnly;
    }

    @Override
    public void init() {
        this.tableStore.doWithExclusiveLock(ts -> {
            this.maxCycleValue = ts.acquireValueFor(HIGHEST_CREATED_CYCLE);
            this.minCycleValue = ts.acquireValueFor(LOWEST_CREATED_CYCLE);
            this.minCycleValue.compareAndSwapValue(Long.MIN_VALUE, Integer.MAX_VALUE);
            this.lock = ts.acquireValueFor(LOCK);
            this.modCount = ts.acquireValueFor(MOD_COUNT);
            if (this.lock.getVolatileValue() == Long.MIN_VALUE) {
                this.lock.compareAndSwapValue(Long.MIN_VALUE, 0L);
            }
            if (this.modCount.getVolatileValue() == Long.MIN_VALUE) {
                this.modCount.compareAndSwapValue(Long.MIN_VALUE, 0L);
            }
            return this;
        });
    }

    @Override
    public void refresh() {
        this.closeCheck();
        if (this.readOnly) {
            return;
        }
        this.refreshIndex();
    }

    @Override
    public void onFileCreated(File file, int cycle) {
        this.closeCheck();
        if (this.readOnly) {
            LOGGER.warn("DirectoryListing is read-only, not updating listing");
            return;
        }
        this.modCount.addAtomicValue(1L);
        if (cycle > this.getMaxCreatedCycle()) {
            this.maxCycleValue.setMaxValue(cycle);
        }
        if (cycle < this.getMinCycleValue()) {
            this.minCycleValue.setMinValue(cycle);
        }
    }

    @Override
    public int getMaxCreatedCycle() {
        this.closeCheck();
        return this.getMaxCycleValue();
    }

    @Override
    public int getMinCreatedCycle() {
        this.closeCheck();
        return this.getMinCycleValue();
    }

    @Override
    public long modCount() {
        this.closeCheck();
        return this.modCount.getVolatileValue();
    }

    public String toString() {
        return this.tableStore.dump();
    }

    @Override
    public void close() {
        this.tableStore.close();
    }

    private void closeCheck() {
        if (this.tableStore.isClosed()) {
            throw new IllegalStateException("Underlying TableStore is already closed - was the Queue closed?");
        }
    }

    private int getMaxCycleValue() {
        return (int)this.maxCycleValue.getVolatileValue();
    }

    private int getMinCycleValue() {
        return (int)this.minCycleValue.getVolatileValue();
    }

    private void refreshIndex() {
        if (this.tableStore.isClosed()) {
            return;
        }
        File[] queueFiles = this.queuePath.toFile().listFiles((d, f) -> f.endsWith(".cq4"));
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        if (queueFiles != null) {
            for (File queueFile : queueFiles) {
                min = Math.min(this.fileToCycleFunction.applyAsInt(queueFile), min);
                max = Math.max(this.fileToCycleFunction.applyAsInt(queueFile), max);
            }
            this.maxCycleValue.setOrderedValue(max);
            this.minCycleValue.setOrderedValue(min);
        }
    }
}

