/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.util.Arrays;
import java.util.List;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public enum Slf4jExceptionHandler implements ExceptionHandler
{
    FATAL{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).error("FATAL error " + message, thrown);
            if (!Slf4jExceptionHandler.isJUnitTest()) {
                System.exit(-1);
            }
        }
    }
    ,
    WARN{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).warn(message, thrown);
        }
    }
    ,
    DEBUG{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).debug(message, thrown);
        }

        @Override
        public boolean isEnabled(Class clazz) {
            return LoggerFactory.getLogger(clazz).isDebugEnabled();
        }
    };


    private static boolean isJUnitTest() {
        for (StackTraceElement[] stackTrace : Thread.getAllStackTraces().values()) {
            List<StackTraceElement> list = Arrays.asList(stackTrace);
            for (StackTraceElement element : list) {
                if (!element.getClassName().contains(".junit")) continue;
                return true;
            }
        }
        return false;
    }
}

