/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.single.RollCycleEncodeSequence;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SimpleStoreRecovery;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueStore
implements WireStore {
    @NotNull
    final SCQIndexing indexing;
    @NotNull
    private final WireType wireType;
    @NotNull
    private final SCQRoll roll;
    @NotNull
    private final LongValue writePosition;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    @NotNull
    private final ReferenceCounter refCount;
    @Nullable
    private final StoreRecovery recovery;
    private int deltaCheckpointInterval = -1;
    @Nullable
    private LongValue lastAcknowledgedIndexReplicated;
    private LongValue lastIndexReplicated;
    private int sourceId;
    @NotNull
    private transient Sequence sequence;

    @UsedViaReflection
    private SingleChronicleQueueStore(@NotNull WireIn wire) {
        assert (wire.startUse());
        try {
            this.wireType = (WireType)wire.read((WireKey)MetaDataField.wireType).object(WireType.class);
            assert (this.wireType != null);
            this.writePosition = this.loadWritePosition(wire);
            this.roll = (SCQRoll)wire.read((WireKey)MetaDataField.roll).typedMarshallable();
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            this.refCount = ReferenceCounter.onReleased(this::onCleanup);
            this.indexing = (SCQIndexing)wire.read((WireKey)MetaDataField.indexing).typedMarshallable();
            assert (this.indexing != null);
            this.indexing.writePosition = this.writePosition;
            this.lastAcknowledgedIndexReplicated = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.lastAcknowledgedIndexReplicated).int64ForBinding(null) : null;
            this.recovery = wire.bytes().readRemaining() > 0L ? (StoreRecovery)wire.read((WireKey)MetaDataField.recovery).typedMarshallable() : new SimpleStoreRecovery();
            this.deltaCheckpointInterval = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.deltaCheckpointInterval).int32() : -1;
            this.sequence = new RollCycleEncodeSequence(this.writePosition, this.rollIndexCount(), this.rollIndexSpacing());
            this.lastIndexReplicated = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.lastIndexReplicated).int64ForBinding(null) : null;
            if (wire.bytes().readRemaining() > 0L) {
                this.sourceId = wire.read((WireKey)MetaDataField.sourceId).int32();
            }
        }
        finally {
            assert (wire.endUse());
        }
    }

    @Override
    public int sourceId() {
        return this.sourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongValue loadWritePosition(@NotNull WireIn wire) {
        int code;
        ValueIn read = wire.read((WireKey)MetaDataField.writePosition);
        long start = wire.bytes().readPosition();
        try {
            wire.consumePadding();
            code = wire.bytes().uncheckedReadUnsignedByte();
        }
        finally {
            wire.bytes().readPosition(start);
        }
        if (code == 141) {
            TwoLongValue result = wire.newTwoLongReference();
            read.int128(result);
            return result;
        }
        LongValue result = wire.newLongReference();
        read.int64(result);
        return result;
    }

    public SingleChronicleQueueStore(@Nullable RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, long epoch, int indexCount, int indexSpacing, StoreRecovery recovery, int deltaCheckpointInterval, int sourceId) {
        this.recovery = recovery;
        this.roll = new SCQRoll(rollCycle, epoch);
        this.wireType = wireType;
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        indexCount = Maths.nextPower2((int)indexCount, (int)8);
        indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.indexing = new SCQIndexing(wireType, indexCount, indexSpacing);
        this.indexing.writePosition = this.writePosition = (LongValue)wireType.newTwoLongReference().get();
        this.indexing.sequence = this.sequence = new RollCycleEncodeSequence(this.writePosition, rollCycle.defaultIndexCount(), rollCycle.defaultIndexSpacing());
        this.lastAcknowledgedIndexReplicated = (LongValue)wireType.newLongReference().get();
        this.deltaCheckpointInterval = deltaCheckpointInterval;
        this.lastIndexReplicated = (LongValue)wireType.newLongReference().get();
        this.sourceId = sourceId;
    }

    public static void dumpStore(@NotNull Wire wire) {
        Bytes bytes = wire.bytes();
        bytes.readPositionUnlimited(0L);
        Jvm.debug().on(SingleChronicleQueueStore.class, Wires.fromSizePrefixedBlobs((WireIn)wire));
    }

    @NotNull
    public static String dump(@NotNull String directoryFilePath) {
        SingleChronicleQueue q = SingleChronicleQueueBuilder.binary(directoryFilePath).build();
        return q.dump();
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @Nullable
    public File file() {
        return this.mappedFile == null ? null : this.mappedFile.file();
    }

    @Override
    public long lastAcknowledgedIndexReplicated() {
        return this.lastAcknowledgedIndexReplicated == null ? -1L : this.lastAcknowledgedIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastAcknowledgedIndexReplicated(long newValue) {
        if (this.lastAcknowledgedIndexReplicated != null) {
            this.lastAcknowledgedIndexReplicated.setMaxValue(newValue);
        }
    }

    @Override
    public long lastIndexReplicated() {
        return this.lastIndexReplicated == null ? -1L : this.lastIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastIndexReplicated(long indexReplicated) {
        if (this.lastIndexReplicated != null) {
            this.lastIndexReplicated.setMaxValue(indexReplicated);
        }
    }

    @Override
    @NotNull
    public String dump() {
        MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            String string = Wires.fromSizePrefixedBlobs((Bytes)bytes);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    public long writePosition() {
        return this.writePosition.getVolatileValue();
    }

    @Override
    @NotNull
    public WireStore writePosition(long position) {
        assert (this.writePosition.getVolatileValue() + this.mappedFile.chunkSize() > position);
        int header = this.mappedBytes.readVolatileInt(position);
        if (!Wires.isReadyData((int)header)) {
            throw new AssertionError();
        }
        this.writePosition.setMaxValue(position);
        return this;
    }

    @Override
    public long epoch() {
        return this.roll.epoch();
    }

    @Override
    @Nullable
    public ScanResult moveToIndexForRead(@NotNull ExcerptContext ec, long index) {
        try {
            return this.indexing.moveToIndex(this.recovery, ec, index);
        }
        catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
            return ScanResult.NOT_REACHED;
        }
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    public void close() {
        while (this.refCount.get() > 0L) {
            this.refCount.release();
        }
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        return MappedBytes.mappedBytes((MappedFile)this.mappedFile);
    }

    @Override
    public long sequenceForPosition(@NotNull ExcerptContext ec, long position, boolean inclusive) throws UnrecoverableTimeoutException, StreamCorruptedException {
        return this.indexing.sequenceForPosition(this.recovery, ec, position, inclusive);
    }

    @Override
    public long lastSequenceNumber(@NotNull ExcerptContext ec) throws StreamCorruptedException {
        return this.indexing.lastSequenceNumber(this.recovery, ec);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SingleChronicleQueueStore{indexing=").append(this.indexing).append(", wireType=").append(this.wireType).append(", checkpointInterval=").append(this.deltaCheckpointInterval).append(", roll=").append(this.roll).append(", writePosition=").append(this.writePosition.getValue());
        sb.append(", lastSequence=").append(Long.toHexString(((TwoLongValue)this.writePosition).getValue2()));
        sb.append(", mappedFile=").append(this.mappedFile).append(", refCount=").append(this.refCount).append(", lastAcknowledgedIndexReplicated=").append(this.lastAcknowledgedIndexReplicated).append('}');
        return sb.toString();
    }

    private void onCleanup() {
        this.mappedBytes.release();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        if (this.lastAcknowledgedIndexReplicated == null) {
            this.lastAcknowledgedIndexReplicated = wire.newLongReference();
        }
        ValueOut wireOut = wire.write((WireKey)MetaDataField.wireType).object((Object)this.wireType).writeAlignTo(16, 0).write((WireKey)MetaDataField.writePosition);
        SingleChronicleQueueStore.intForBinding(wireOut, this.writePosition).write((WireKey)MetaDataField.roll).typedMarshallable((WriteMarshallable)this.roll).write((WireKey)MetaDataField.indexing).typedMarshallable((WriteMarshallable)this.indexing).write((WireKey)MetaDataField.lastAcknowledgedIndexReplicated).int64forBinding(-1L, this.lastAcknowledgedIndexReplicated);
        wire.write((WireKey)MetaDataField.recovery).typedMarshallable((WriteMarshallable)this.recovery);
        wire.write((WireKey)MetaDataField.deltaCheckpointInterval).int32(this.deltaCheckpointInterval);
        if (Boolean.getBoolean("includeQueueHeaderField-lastIndexReplicated-and-sourceId")) {
            wire.write((WireKey)MetaDataField.lastIndexReplicated).int64forBinding(-1L, this.lastIndexReplicated);
            wire.write((WireKey)MetaDataField.sourceId).int32(this.sourceId);
        }
        wire.padToCacheAlign();
    }

    private static WireOut intForBinding(ValueOut wireOut, LongValue value) {
        return value instanceof TwoLongValue ? wireOut.int128forBinding(0L, 0L, (TwoLongValue)value) : wireOut.int64forBinding(0L, value);
    }

    @Override
    public boolean indexable(long index) {
        return this.indexing.indexable(index);
    }

    @Override
    public void setPositionForSequenceNumber(@NotNull ExcerptContext ec, long sequenceNumber, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
        this.sequence.setSequence(sequenceNumber, position);
        long nextSequence = this.indexing.nextEntryToBeIndexed();
        if (nextSequence > sequenceNumber) {
            return;
        }
        try {
            this.indexing.setPositionForSequenceNumber(this.recovery, ec, sequenceNumber, position);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public ScanResult linearScanTo(long index, long knownIndex, ExcerptContext ec, long knownAddress) {
        return this.indexing.linearScanTo(index, knownIndex, ec, knownAddress);
    }

    @Override
    public long writeHeader(@NotNull Wire wire, int safeLength, long timeoutMS) throws EOFException, UnrecoverableTimeoutException {
        return this.recovery.writeHeader(wire, safeLength, timeoutMS, this.writePosition, this.sequence);
    }

    @Override
    public long tryWriteHeader(Wire wire, int safeLength) {
        return this.recovery.tryWriteHeader(wire, safeLength);
    }

    @Override
    public void writeEOF(@NotNull Wire wire, long timeoutMS) {
        if (wire.bytes().tryReserve()) {
            wire.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS, this.writePosition());
            wire.bytes().release();
        } else {
            Jvm.debug().on(this.getClass(), "Tried to writeEOF to as it was being closed");
        }
    }

    @Override
    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval;
    }

    int rollCycleLength() {
        return this.roll.length();
    }

    int rollIndexCount() {
        return this.indexing.indexCount();
    }

    int rollIndexSpacing() {
        return this.indexing.indexSpacing();
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{SCQIndexing.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "Roll");
    }
}

