/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.wire.DocumentContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public final class TailerSequenceRaceConditionTest {
    private final AtomicBoolean failedToMoveToEnd = new AtomicBoolean(false);
    private final ExecutorService threadPool = Executors.newFixedThreadPool(8);

    @Ignore
    @Test
    public void shouldAlwaysBeAbleToTail() throws Exception {
        for (int i = 0; i < 10; ++i) {
            int j;
            SingleChronicleQueue queue = this.createNewQueue();
            for (j = 0; j < 4; ++j) {
                this.threadPool.submit(() -> this.attemptToMoveToTail(queue));
            }
            this.threadPool.submit(() -> this.appendToQueue(queue));
            for (j = 0; j < 4; ++j) {
                this.threadPool.submit(() -> this.attemptToMoveToTail(queue));
            }
        }
        this.threadPool.shutdown();
        Assert.assertThat((Object)this.threadPool.awaitTermination(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.failedToMoveToEnd.get(), (Matcher)CoreMatchers.is((Object)false));
    }

    @After
    public void tearDown() throws Exception {
        this.threadPool.shutdownNow();
    }

    private void appendToQueue(SingleChronicleQueue queue) {
        for (int i = 0; i < 31; ++i) {
            ExcerptAppender appender = queue.acquireAppender();
            if (queue.isClosed()) {
                return;
            }
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"foo");
                continue;
            }
        }
    }

    private void attemptToMoveToTail(SingleChronicleQueue queue) {
        SingleChronicleQueueExcerpts.StoreTailer tailer = (SingleChronicleQueueExcerpts.StoreTailer)queue.createTailer();
        try {
            tailer.toEnd();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.failedToMoveToEnd.set(true);
        }
    }

    private SingleChronicleQueue createNewQueue() {
        return SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir(TailerSequenceRaceConditionTest.class.getSimpleName())).build();
    }
}

