/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListing;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableDirectoryListingTest {
    private TableDirectoryListing listing;
    private File testDirectory;
    private File tableFile;
    private File tempFile;

    @Before
    public void setUp() throws Exception {
        this.testDirectory = TableDirectoryListingTest.testDirectory();
        this.testDirectory.mkdirs();
        this.tableFile = new File(this.testDirectory, "dir-list.cq4t");
        this.listing = new TableDirectoryListing(SingleTableBuilder.binary((File)this.tableFile).build(), this.testDirectory.toPath(), f -> Integer.parseInt(f.getName().split("\\.")[0]), false);
        this.listing.init();
        this.tempFile = File.createTempFile("foo", "bar");
        this.tempFile.deleteOnExit();
    }

    @Test
    public void shouldTrackMaxValue() throws Exception {
        this.listing.refresh();
        this.listing.onFileCreated(this.tempFile, 7);
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)7));
        Assert.assertThat((Object)this.listing.getMinCreatedCycle(), (Matcher)CoreMatchers.is((Object)7));
        this.listing.onFileCreated(this.tempFile, 8);
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)8));
        Assert.assertThat((Object)this.listing.getMinCreatedCycle(), (Matcher)CoreMatchers.is((Object)7));
    }

    @Test
    public void shouldInitialiseFromFilesystem() throws Exception {
        new File(this.testDirectory, "1.cq4").createNewFile();
        new File(this.testDirectory, "2.cq4").createNewFile();
        new File(this.testDirectory, "3.cq4").createNewFile();
        this.listing.refresh();
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)this.listing.getMinCreatedCycle(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void lockShouldTimeOut() throws Exception {
        this.listing.onFileCreated(this.tempFile, 8);
        TableStore tableCopy = SingleTableBuilder.binary((File)this.tableFile).build();
        LongValue lock = tableCopy.acquireValueFor((CharSequence)"listing.exclusiveLock");
        lock.setOrderedValue(System.currentTimeMillis() - (TimeUnit.SECONDS.toMillis(9L) + 500L));
        this.listing.onFileCreated(this.tempFile, 9);
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)9));
    }

    @NotNull
    private static File testDirectory() {
        return DirectoryUtils.tempDir(TableDirectoryListingTest.class.getSimpleName());
    }
}

