/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.single.SimpleStoreRecovery;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class SingleTableStore
implements TableStore {
    private static final long timeoutMS = Long.getLong("chronicle.table.store.timeoutMS", 10000L);
    @NotNull
    private final WireType wireType;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    @NotNull
    private final Wire mappedWire;
    @NotNull
    private final ReferenceCounter refCount;
    @NotNull
    private final StoreRecovery recovery;

    @UsedViaReflection
    private SingleTableStore(@NotNull WireIn wire) {
        assert (wire.startUse());
        try {
            this.wireType = wire.read(MetaDataField.wireType).object(WireType.class);
            assert (this.wireType != null);
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            this.refCount = ReferenceCounter.onReleased(this::onCleanup);
            this.recovery = wire.bytes().readRemaining() > 0L ? (StoreRecovery)wire.read(MetaDataField.recovery).typedMarshallable() : new SimpleStoreRecovery();
            this.mappedWire = (Wire)this.wireType.apply(this.mappedBytes);
        }
        finally {
            assert (wire.endUse());
        }
    }

    public SingleTableStore(@NotNull WireType wireType, @NotNull MappedBytes mappedBytes, @NotNull StoreRecovery recovery) {
        this.recovery = recovery;
        this.wireType = wireType;
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        this.mappedWire = (Wire)wireType.apply(mappedBytes);
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @NotNull
    public File file() {
        return this.mappedFile.file();
    }

    @Override
    @NotNull
    public String dump() {
        MappedBytes bytes = MappedBytes.mappedBytes(this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            String string = Wires.fromSizePrefixedBlobs(bytes);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    @Override
    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    @Override
    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public void close() {
        while (this.refCount.get() > 0L) {
            this.refCount.release();
        }
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        return MappedBytes.mappedBytes(this.mappedFile);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{wireType=" + this.wireType + ", mappedFile=" + this.mappedFile + ", refCount=" + this.refCount + '}';
    }

    private void onCleanup() {
        this.mappedBytes.release();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write(MetaDataField.wireType).object(this.wireType);
        wire.write(MetaDataField.recovery).typedMarshallable(this.recovery);
        wire.padToCacheAlign();
    }

    @Override
    public long writeHeader(@NotNull Wire wire, int length, int safeLength, long timeoutMS) throws EOFException, UnrecoverableTimeoutException {
        return this.recovery.writeHeader(wire, length, safeLength, timeoutMS, null, null);
    }

    @Override
    public long tryWriteHeader(@NotNull Wire wire, int length, int safeLength) {
        return this.recovery.tryWriteHeader(wire, length, safeLength);
    }

    @Override
    public synchronized LongValue acquireValueFor(CharSequence key) {
        StringBuilder sb = Wires.acquireStringBuilder();
        this.mappedBytes.reserve();
        try {
            int header;
            this.mappedBytes.readPosition(0L);
            this.mappedBytes.readLimit(this.mappedBytes.realCapacity());
            while (this.mappedWire.readDataHeader() && !Wires.isNotComplete(header = this.mappedBytes.readInt())) {
                long readPosition = this.mappedBytes.readPosition();
                int length = Wires.lengthOf(header);
                ValueIn valueIn = this.mappedWire.readEventName(sb);
                if (StringUtils.equalsCaseIgnore(key, sb)) {
                    LongValue longValue = valueIn.int64ForBinding(null);
                    return longValue;
                }
                this.mappedBytes.readPosition(readPosition + (long)length);
            }
            int safeLength = Maths.toUInt31(this.mappedBytes.realCapacity() - this.mappedBytes.readPosition());
            this.mappedBytes.writeLimit(this.mappedBytes.realCapacity());
            this.mappedBytes.writePosition(this.mappedBytes.readPosition());
            long pos = this.recovery.writeHeader(this.mappedWire, 0, safeLength, timeoutMS, null, null);
            LongValue longValue = this.wireType.newLongReference().get();
            this.mappedWire.writeEventName(key).int64forBinding(Long.MIN_VALUE, longValue);
            this.mappedWire.updateHeader(pos, false);
            LongValue longValue2 = longValue;
            return longValue2;
        }
        catch (EOFException | StreamCorruptedException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.mappedBytes.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R doWithExclusiveLock(Function<TableStore, ? extends R> code) {
        long timeoutAt = System.currentTimeMillis() + 2L * timeoutMS;
        boolean warnedOnFailure = false;
        try (FileChannel channel = FileChannel.open(this.file().toPath(), StandardOpenOption.WRITE);){
            while (System.currentTimeMillis() < timeoutAt) {
                block21: {
                    try {
                        FileLock fileLock = channel.tryLock();
                        if (fileLock != null) {
                            R r = code.apply(this);
                            return r;
                        }
                    }
                    catch (IOException | OverlappingFileLockException e) {
                        if (warnedOnFailure) break block21;
                        Jvm.debug().on(this.getClass(), "Failed to acquire a lock on the table store file. Retrying");
                        warnedOnFailure = true;
                    }
                }
                Jvm.pause(50L);
            }
            throw new IllegalStateException("Unable to claim exclusive lock on file " + this.file());
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't open table store file for writing", e);
        }
    }
}

