/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.Sequence;

class RollCycleEncodeSequence
implements Sequence {
    private static final long THIRTY_ONE_BITS = Integer.MAX_VALUE;
    private final TwoLongValue writePositionAndSequence;
    private final int cycleShift;
    private final long sequenceMask;

    RollCycleEncodeSequence(LongValue writePositionAndSequence, int indexCount, int indexSpacing) {
        this.cycleShift = Math.max(32, Maths.intLog2(indexCount) * 2 + Maths.intLog2(indexSpacing));
        this.sequenceMask = (1L << this.cycleShift) - 1L;
        this.writePositionAndSequence = writePositionAndSequence instanceof TwoLongValue ? (TwoLongValue)writePositionAndSequence : null;
    }

    @Override
    public void setSequence(long sequence, long position) {
        if (this.writePositionAndSequence == null) {
            return;
        }
        long value = this.toLongValue(position, sequence);
        this.writePositionAndSequence.setOrderedValue2(value);
    }

    @Override
    public long toIndex(long headerNumber, long sequence) {
        int cycle = this.toCycle(headerNumber);
        return this.toLongValue(cycle, sequence);
    }

    @Override
    public long getSequence(long forWritePosition) {
        long toLowerBitsWritePosition;
        if (this.writePositionAndSequence == null) {
            return -1L;
        }
        long sequenceValue = this.writePositionAndSequence.getVolatileValue2();
        if (sequenceValue == 0L) {
            return -1L;
        }
        int writePositionCycle = (int)this.cycleMask(forWritePosition);
        long lowerBitsOfWp = this.toLowerBitsWritePosition(this.toLongValue(writePositionCycle, 0L));
        if (lowerBitsOfWp == (toLowerBitsWritePosition = this.toLowerBitsWritePosition(this.cycleMask(sequenceValue)))) {
            return this.toSequenceNumber(sequenceValue);
        }
        return Long.MIN_VALUE;
    }

    private long cycleMask(long number) {
        return number & Integer.MAX_VALUE;
    }

    private long toLongValue(long cycle, long sequenceNumber) {
        return (cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    @Override
    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    private long toLowerBitsWritePosition(long index) {
        return index >> this.cycleShift;
    }

    private int toCycle(long number) {
        return Maths.toUInt31(number >> this.cycleShift);
    }
}

