/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UncheckedLongReference
implements LongReference {
    private long address;
    private Unsafe unsafe;

    @NotNull
    public static LongReference create(BytesStore bytesStore, long offset, int size) {
        LongReference ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.address = bytes.addressForRead(offset);
        this.unsafe = UnsafeMemory.UNSAFE;
    }

    @NotNull
    public BytesStore bytesStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.address == 0L ? "addressForRead is 0" : "value: " + this.getValue();
    }

    @Override
    public long getValue() {
        return this.unsafe.getLong(this.address);
    }

    @Override
    public void setValue(long value) {
        this.unsafe.putLong(this.address, value);
    }

    @Override
    public long getVolatileValue() {
        return this.unsafe.getLong(this.address);
    }

    @Override
    public void setOrderedValue(long value) {
        this.unsafe.putOrderedLong(null, this.address, value);
    }

    @Override
    public long addValue(long delta) {
        return this.unsafe.getAndAddLong(null, this.address, delta) + delta;
    }

    @Override
    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    @Override
    public boolean compareAndSwapValue(long expected, long value) {
        return this.unsafe.compareAndSwapLong(null, this.address, expected, value);
    }
}

