/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.EOFException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesComment;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.threads.BusyTimedPauser;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.HeadNumberChecker;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireObjectInput;
import net.openhft.chronicle.wire.WireObjectOutput;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWire
implements Wire {
    protected static final boolean ASSERTIONS;
    private static final String INSIDE_HEADER_MESSAGE = "you cant put a header inside a header, check that you have not nested the documents. If you are using Chronicle-Queue please ensure that you have a unique instance of the Appender per thread, in other-words you can not share appenders across threads.";
    private static long ignoreHeaderCountIfNumberOfBytesBehindExceeds;
    private static boolean disableFastForwardHeaderNumber;
    @NotNull
    protected final Bytes<?> bytes;
    protected final boolean use8bit;
    protected ClassLookup classLookup = ClassAliasPool.CLASS_ALIASES;
    protected Object parent;
    @Nullable
    volatile Thread usedBy;
    @Nullable
    volatile Throwable usedHere;
    @Nullable
    volatile Throwable lastEnded;
    int usedCount = 0;
    private Pauser pauser;
    private Pauser timedParser;
    private long headerNumber = Long.MIN_VALUE;
    private boolean notCompleteIsNotPresent;
    private ObjectOutput objectOutput;
    private ObjectInput objectInput;
    private boolean insideHeader;
    private HeadNumberChecker headNumberChecker;

    public AbstractWire(@NotNull Bytes bytes, boolean use8bit) {
        this.bytes = bytes;
        this.use8bit = use8bit;
        this.notCompleteIsNotPresent = bytes.sharedMemory();
    }

    private static long throwNotEnoughSpace(int maxlen, @NotNull Bytes<?> bytes) {
        throw new IllegalStateException("not enough space to write " + maxlen + " was " + bytes.writeRemaining() + " limit " + bytes.writeLimit() + " type " + bytes.getClass());
    }

    private static void throwLengthMismatch(int length, int actualLength) throws StreamCorruptedException {
        throw new StreamCorruptedException("Wrote " + actualLength + " when " + length + " was set initially.");
    }

    @NotNull
    private Pauser acquireTimedParser() {
        return this.timedParser != null ? this.timedParser : (this.timedParser = new BusyTimedPauser());
    }

    public boolean isInsideHeader() {
        return this.insideHeader;
    }

    @Override
    public Pauser pauser() {
        if (this.pauser == null) {
            this.pauser = this.acquireTimedParser();
        }
        return this.pauser;
    }

    @Override
    public void pauser(Pauser pauser) {
        this.pauser = pauser;
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.headerNumber(Long.MIN_VALUE);
    }

    @NotNull
    private Wire headerNumber(long position, long headerNumber) {
        assert (this.checkHeader(position, headerNumber));
        return this.headerNumber0(headerNumber);
    }

    private boolean checkHeader(long position, long headerNumber) {
        return this.headNumberChecker == null || this.headNumberChecker.checkHeaderNumber(headerNumber, position);
    }

    @Override
    @NotNull
    public Wire headerNumber(long headerNumber) {
        return this.headerNumber(this.bytes().writePosition(), headerNumber);
    }

    @NotNull
    private Wire headerNumber0(long headerNumber) {
        this.headerNumber = headerNumber;
        return this;
    }

    public void headNumberCheck(HeadNumberChecker headNumberChecker) {
        this.headNumberChecker = headNumberChecker;
    }

    @Override
    public long headerNumber() {
        return this.headerNumber;
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public BytesComment<?> bytesComment() {
        return this.bytes;
    }

    @Override
    @NotNull
    public WireIn.HeaderType readDataHeader(boolean includeMetaData) throws EOFException {
        int header;
        while (Wires.isReady(header = this.bytes.peekVolatileInt())) {
            if (header == 0) {
                return WireIn.HeaderType.NONE;
            }
            if (Wires.isData(header)) {
                return WireIn.HeaderType.DATA;
            }
            if (includeMetaData && Wires.isReadyMetaData(header)) {
                return WireIn.HeaderType.META_DATA;
            }
            int bytesToSkip = Wires.lengthOf(header) + 4;
            this.bytes.readSkip(bytesToSkip);
        }
        if (header == -1073741824) {
            throw new EOFException();
        }
        return WireIn.HeaderType.NONE;
    }

    @Override
    public void readAndSetLength(long position) {
        int header = this.bytes.peekVolatileInt();
        if (Wires.isReady(header)) {
            if (header == 0) {
                this.throwISE();
            }
            long start = position + 4L;
            this.bytes.readPositionRemaining(start, Wires.lengthOf(header));
            return;
        }
        this.throwISE();
    }

    private void throwISE() {
        throw new IllegalStateException();
    }

    @Override
    public void readMetaDataHeader() {
        int header = this.bytes.peekVolatileInt();
        if (Wires.isReady(header)) {
            if (header == 0) {
                throw new IllegalStateException("Meta data not initialised");
            }
            if (Wires.isReadyMetaData(header)) {
                this.setLimitPosition(header);
                return;
            }
        }
        throw new IllegalStateException("Meta data not ready " + Integer.toHexString(header));
    }

    private void setLimitPosition(int header) {
        ((Bytes)this.bytes.readLimit(this.bytes.readPosition() + (long)Wires.lengthOf(header) + 4L)).readSkip(4L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFirstHeader(long timeout, TimeUnit timeUnit) throws TimeoutException, StreamCorruptedException {
        int header;
        try {
            while (!Wires.isReady(header = this.bytes.readVolatileInt(0L))) {
                this.acquireTimedParser().pause(timeout, timeUnit);
            }
        }
        finally {
            this.resetTimedPauser();
        }
        int len = Wires.lengthOf(header);
        if (!Wires.isReadyMetaData(header) || len > 65536) {
            throw new StreamCorruptedException("Unexpected magic number " + Integer.toHexString(header));
        }
        this.bytes.readPositionRemaining(4L, len);
    }

    @Override
    public long writeHeaderOfUnknownLength(int safeLength, long timeout, TimeUnit timeUnit, @Nullable LongValue lastPosition, Sequence sequence) throws TimeoutException, EOFException {
        assert (!this.insideHeader) : "you cant put a header inside a header, check that you have not nested the documents. If you are using Chronicle-Queue please ensure that you have a unique instance of the Appender per thread, in other-words you can not share appenders across threads.";
        this.insideHeader = true;
        try {
            long tryPos = this.tryWriteHeader0(0, safeLength);
            if (tryPos != -1L) {
                return tryPos;
            }
            if (lastPosition != null && sequence != null) {
                this.tryMoveToEndOfQueue(lastPosition, sequence);
            }
            return this.writeHeader0(0, safeLength, timeout, timeUnit);
        }
        catch (Throwable t) {
            this.insideHeader = false;
            throw t;
        }
    }

    private void tryMoveToEndOfQueue(@NotNull LongValue lastPosition, @NotNull Sequence sequence) {
        long lastPositionValue = lastPosition.getVolatileValue();
        if (lastPositionValue <= this.bytes.writePosition()) {
            return;
        }
        if (this.headerNumber == Long.MIN_VALUE) {
            this.fastForwardDontWriteHeaderNumber(lastPositionValue);
            return;
        }
        try {
            int maxAttempts = 128;
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                long lastSequence = sequence.getSequence(lastPositionValue);
                if (lastSequence == -1L) {
                    this.fastForwardDontWriteHeaderNumber(lastPositionValue);
                    break;
                }
                if (lastSequence != Long.MIN_VALUE) {
                    long currentSequence = sequence.toSequenceNumber(this.headerNumber);
                    if (currentSequence > lastSequence) break;
                    long newHeaderNumber = sequence.toIndex(this.headerNumber, lastSequence - 1L);
                    if (!disableFastForwardHeaderNumber) {
                        this.headerNumber(newHeaderNumber);
                        this.bytes.writePosition(lastPositionValue);
                        break;
                    }
                }
                if (attempt == maxAttempts - 1) {
                    this.fastForwardDontWriteHeaderNumber(lastPositionValue);
                    break;
                }
                lastPositionValue = lastPosition.getVolatileValue();
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    private void fastForwardDontWriteHeaderNumber(long lastPositionValue) {
        if (lastPositionValue > this.bytes.writePosition() + ignoreHeaderCountIfNumberOfBytesBehindExceeds) {
            this.headerNumber(Long.MIN_VALUE);
            this.bytes.writePosition(lastPositionValue);
        }
    }

    @Override
    public long tryWriteHeader(int safeLength) {
        assert (!this.insideHeader) : "you cant put a header inside a header, check that you have not nested the documents. If you are using Chronicle-Queue please ensure that you have a unique instance of the Appender per thread, in other-words you can not share appenders across threads.";
        this.insideHeader = true;
        try {
            long tryPos = this.tryWriteHeader0(0, safeLength);
            this.insideHeader = tryPos != -1L;
            return tryPos;
        }
        catch (Throwable t) {
            this.insideHeader = false;
            throw t;
        }
    }

    private long tryWriteHeader0(int length, int safeLength) {
        int value;
        if (length < 0 || length > safeLength) {
            throw new IllegalArgumentException();
        }
        long pos = this.bytes.writePosition();
        if (this.bytes.compareAndSwapInt(pos, 0, value = Wires.addMaskedTidToHeader(Integer.MIN_VALUE | length))) {
            int maxlen;
            int n = maxlen = length == 0 ? safeLength : length;
            if (length != safeLength && (long)maxlen > this.bytes.writeRemaining()) {
                return AbstractWire.throwNotEnoughSpace(maxlen, this.bytes);
            }
            this.bytes.writePositionRemaining(pos + 4L, maxlen);
            return pos;
        }
        return -1L;
    }

    private long writeHeader0(int length, int safeLength, long timeout, TimeUnit timeUnit) throws TimeoutException, EOFException {
        if (length < 0 || length > safeLength) {
            this.throwISE();
        }
        long pos = this.bytes.writePosition();
        this.resetTimedPauser();
        try {
            int value = Wires.addMaskedTidToHeader(Integer.MIN_VALUE | length);
            while (true) {
                int header2;
                if (this.bytes.compareAndSwapInt(pos, 0, value)) {
                    int maxlen;
                    this.bytes.writePosition(pos + 4L);
                    int n = maxlen = length == 0 ? safeLength : length;
                    if ((long)maxlen > this.bytes.writeRemaining()) {
                        AbstractWire.throwNotEnoughSpace(maxlen, this.bytes);
                    }
                    this.bytes.writeLimit(this.bytes.writePosition() + (long)maxlen);
                    long l = pos;
                    return l;
                }
                this.bytes.readPositionRemaining(pos, 0L);
                int header = this.bytes.readVolatileInt(pos);
                if (Wires.isEndOfFile(header)) {
                    throw new EOFException();
                }
                if (Wires.isNotComplete(header)) {
                    this.acquireTimedParser().pause(timeout, timeUnit);
                    continue;
                }
                this.acquireTimedParser().reset();
                int len = Wires.lengthOf(header);
                int nextHeader = Wires.lengthOf(this.bytes.readVolatileInt(pos + (long)len + 4L));
                if (nextHeader > 1024 && (header2 = this.bytes.readVolatileInt(pos)) != header) {
                    Jvm.warn().on(this.getClass(), "At pos: " + pos + " header: " + header + " header2: " + header2);
                    header = header2;
                }
                pos += (long)(len + 4);
                if (!Wires.isData(header)) continue;
                this.incrementHeaderNumber(pos);
            }
        }
        finally {
            this.resetTimedPauser();
        }
    }

    @Override
    public void updateHeader(long position, boolean metaData) throws StreamCorruptedException, EOFException {
        if (position <= 0L) {
            IllegalStateException ex = new IllegalStateException("Attempt to write to position=" + position);
            Slf4jExceptionHandler.WARN.on(this.getClass(), "Attempt to update header at position=" + position, ex);
            throw ex;
        }
        if (this.bytes.writePosition() == position + 4L) {
            this.addPadding(1);
        }
        long pos = this.bytes.writePosition();
        int actualLength = Maths.toUInt31(pos - position - 4L);
        int expectedHeader = Wires.addMaskedTidToHeader(Integer.MIN_VALUE);
        int header = actualLength;
        if (metaData) {
            header |= 0x40000000;
        }
        if (header == 0) {
            throw new UnsupportedOperationException("Data messages of 0 length are not supported.");
        }
        assert (this.insideHeader);
        this.insideHeader = false;
        this.updateHeaderAssertions(position, pos, expectedHeader, header);
        this.bytes.writeLimit(this.bytes.capacity());
        if (!metaData) {
            this.incrementHeaderNumber(position);
        }
    }

    private void updateHeaderAssertions(long position, long pos, int expectedHeader, int header) throws StreamCorruptedException, EOFException {
        if (ASSERTIONS) {
            this.checkNoDataAfterEnd(pos);
        }
        if (!this.bytes.compareAndSwapInt(position, expectedHeader, header)) {
            int currentHeader = this.bytes.readVolatileInt(position);
            if (Wires.isEndOfFile(currentHeader)) {
                throw new EOFException();
            }
            throw new StreamCorruptedException("Data at " + position + " overwritten? Expected: " + Integer.toHexString(expectedHeader) + " was " + Integer.toHexString(currentHeader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNoDataAfterEnd(long pos) {
        int value;
        if (pos <= this.bytes.realCapacity() - 4L && (value = this.bytes.bytesStore().readVolatileInt(pos)) != 0) {
            String text;
            long pos0 = this.bytes.readPosition();
            try {
                this.bytes.readPosition(pos);
                text = this.bytes.toDebugString();
            }
            finally {
                this.bytes.readPosition(pos0);
            }
            throw new IllegalStateException("Data was written after the end of the message, zero out data before rewinding " + text);
        }
    }

    private void incrementHeaderNumber(long pos) {
        if (this.headerNumber != Long.MIN_VALUE) {
            this.headerNumber(pos, this.headerNumber + 1L);
        }
    }

    @Override
    public boolean writeFirstHeader() {
        boolean cas = this.bytes.compareAndSwapInt(0L, 0, Integer.MIN_VALUE);
        if (cas) {
            this.bytes.writeSkip(4L);
        }
        return cas;
    }

    @Override
    public void updateFirstHeader() {
        this.padToCacheAlign();
        long pos = this.bytes.writePosition();
        long actualLength = pos - 4L;
        if (actualLength >= 0x40000000L) {
            throw new IllegalStateException("Header too large was " + actualLength);
        }
        int header = (int)(0x40000000L | actualLength);
        if (!this.bytes.compareAndSwapInt(0L, Integer.MIN_VALUE, header)) {
            throw new IllegalStateException("Data at 0 overwritten? Expected: " + Integer.toHexString(Integer.MIN_VALUE) + " was " + Integer.toHexString(this.bytes.readVolatileInt(0L)));
        }
    }

    @Override
    public void writeEndOfWire(long timeout, TimeUnit timeUnit, long lastPosition) {
        long pos = Math.max(lastPosition, this.bytes.writePosition());
        this.headerNumber = Long.MIN_VALUE;
        try {
            while (true) {
                if (this.bytes.compareAndSwapInt(pos, 0, -1073741824)) {
                    this.bytes.writePosition(pos + 4L);
                    return;
                }
                int header = this.bytes.readVolatileInt(pos);
                if (header == -1073741824) {
                    return;
                }
                if (Wires.isNotComplete(header)) {
                    try {
                        this.acquireTimedParser().pause(timeout, timeUnit);
                    }
                    catch (TimeoutException e) {
                        boolean success = this.bytes.compareAndSwapInt(pos, header, -1073741824);
                        Jvm.warn().on(this.getClass(), "resetting header after timeout, header: " + Integer.toHexString(header) + ", pos: " + pos + ", success: " + success);
                    }
                    continue;
                }
                this.acquireTimedParser().reset();
                int len = Wires.lengthOf(header);
                pos += (long)(len + 4);
            }
        }
        finally {
            this.resetTimedPauser();
        }
    }

    private void resetTimedPauser() {
        if (this.timedParser != null) {
            this.timedParser.reset();
        }
    }

    @Override
    public Object parent() {
        return this.parent;
    }

    @Override
    public void parent(Object parent) {
        this.parent = parent;
    }

    @Override
    public boolean startUse() {
        Throwable usedHere = this.usedHere;
        Thread usedBy = this.usedBy;
        if (usedBy != Thread.currentThread() && usedBy != null) {
            throw new IllegalStateException("Used by " + usedBy + " while trying to use it in " + Thread.currentThread(), usedHere);
        }
        this.usedBy = Thread.currentThread();
        this.usedHere = new Throwable();
        ++this.usedCount;
        return true;
    }

    @Override
    public boolean endUse() {
        if (this.usedBy != Thread.currentThread()) {
            throw new IllegalStateException("Used by " + this.usedHere, this.usedHere);
        }
        if (--this.usedCount <= 0) {
            this.usedBy = null;
            this.usedHere = null;
            this.usedCount = 0;
            this.lastEnded = new Throwable();
        }
        return true;
    }

    @Override
    public boolean notCompleteIsNotPresent() {
        return this.notCompleteIsNotPresent;
    }

    @Override
    public void notCompleteIsNotPresent(boolean notCompleteIsNotPresent) {
        this.notCompleteIsNotPresent = notCompleteIsNotPresent;
    }

    @Override
    public ObjectOutput objectOutput() {
        if (this.objectOutput == null) {
            this.objectOutput = new WireObjectOutput(this);
        }
        return this.objectOutput;
    }

    @Override
    public ObjectInput objectInput() {
        if (this.objectInput == null) {
            this.objectInput = new WireObjectInput(this);
        }
        return this.objectInput;
    }

    @Override
    public long readEventNumber() {
        return Long.MIN_VALUE;
    }

    public void forceNotInsideHeader() {
        this.insideHeader = false;
    }

    static {
        ignoreHeaderCountIfNumberOfBytesBehindExceeds = Integer.getInteger("ignoreHeaderCountIfNumberOfBytesBehindExceeds", 0x100000).intValue();
        disableFastForwardHeaderNumber = Boolean.getBoolean("disableFastForwardHeaderNumber");
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERTIONS = assertions;
        WireInternal.addAliases();
    }
}

