/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.junit.Assert;
import org.junit.Test;

public class TestWriteWhenCurrentCycleGotEOF
extends ChronicleQueueTestBase {
    @Test
    public void shouldBeAbleToWriteIfCurrentCycleGotEOF() throws TimeoutException {
        File tmpDir = this.getTmpDir();
        this.createQueueWithOnlyHeaderFile(tmpDir);
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().build();
        ExcerptAppender appender = queue.acquireAppender();
        try (DocumentContext dc = appender.writingDocument();){
            dc.wire().write((CharSequence)"test").text("Hello world");
        }
        dc = queue.acquireTailer().readingDocument();
        var5_5 = null;
        try {
            Assert.assertEquals((Object)"Hello world", (Object)dc.wire().read("test").text());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var5_5 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
    }

    private void createQueueWithOnlyHeaderFile(File dir) {
        Wire wire;
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();
        queue.storeForCycle(queue.cycle(), queue.epoch(), true);
        SingleChronicleQueueExcerpts.StoreTailer tailer = queue.acquireTailer();
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
        ExcerptAppender excerptAppender = queue.acquireAppender();
        try (DocumentContext dc = excerptAppender.writingDocument();){
            wire = dc.wire();
        }
        Bytes bytes = wire.bytes();
        bytes.writeVolatileInt(bytes.writePosition() - 5L, -1073741824);
        bytes.writeVolatileInt(bytes.writePosition() - 1L, 0);
    }
}

