/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.micros.Order;
import net.openhft.chronicle.queue.micros.Side;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SingleCQFormat2Test {
    private final boolean lazyIndexing;
    private int appendMode;
    private ThreadDump threadDump;

    public SingleCQFormat2Test(String testType, boolean lazyIndexing) {
        this.lazyIndexing = lazyIndexing;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"eager", false}, {"lazy", true});
    }

    private static void assertHexEquals(long a, long b) {
        if (a != b) {
            Assert.assertEquals((String)(Long.toHexString(a) + " != " + Long.toHexString(b)), (long)a, (long)b);
        }
    }

    private static void expected(@NotNull ExcerptTailer tailer, String expected) {
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertTrue((boolean)dc.isPresent());
            VanillaBytes bytes2 = Bytes.allocateDirect((long)128L);
            dc.wire().copyTo((WireOut)new TextWire((Bytes)bytes2));
            Assert.assertEquals((Object)expected, (Object)bytes2.toString());
        }
    }

    @Test
    public void testMyData() {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{MyData.class});
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            try (DocumentContext dc = appender.writingDocument();){
                MyData name = new MyData("name", 12345L, 1.2, 111);
                System.out.println((Object)name);
                name.writeMarshallable((WireOut)dc.wire());
                MyData name2 = new MyData("name2", 12346L, 1.3, 112);
                System.out.println((Object)name2);
                name2.writeMarshallable((WireOut)dc.wire());
            }
            String dump = queue.dump();
            Assert.assertTrue((String)dump, (this.lazyIndexing != dump.contains("--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  640,\n  0, 0, 0, 0, 0, 0, 0\n]") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWritingThreeMessages() throws FileNotFoundException {
        for (int m = 0; m <= 2; ++m) {
            this.appendMode = m;
            File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
            dir.mkdir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(1).build();){
                long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
                this.appendMessage(queue, start, "Hello World");
                String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    640,\n    2748779069440\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  640,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 640, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 130408 bytes remaining\n";
                String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    442,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 462,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 462, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n...\n# 130412 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), this.lazyIndexing ? expectedLazy : expectedEager);
                this.appendMessage(queue, start + 1L, "Another Hello World");
                String expectedEager2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    660,\n    2834678415361\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  640,\n  660,\n  0, 0, 0, 0, 0, 0\n]\n# position: 640, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 660, header: 1\n--- !!data #binary\nmsg: Another Hello World\n...\n# 130380 bytes remaining\n";
                String expectedLazy2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    656,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 462,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 462, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 656, header: 1\n--- !!data #binary\nmsg: Another Hello World\n...\n# 130384 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), this.lazyIndexing ? expectedLazy2 : expectedEager2);
                this.appendMessage(queue, start + 2L, "Bye for now");
                String expectedEager3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    688,\n    2954937499650\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 3\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  640,\n  660,\n  688,\n  0, 0, 0, 0, 0\n]\n# position: 640, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 660, header: 1\n--- !!data #binary\nmsg: Another Hello World\n# position: 688, header: 2\n--- !!data #binary\nmsg: Bye for now\n...\n# 130360 bytes remaining\n";
                String expectedLazy3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    684,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 462,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 462, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 656, header: 1\n--- !!data #binary\nmsg: Another Hello World\n# position: 684, header: 2\n--- !!data #binary\nmsg: Bye for now\n...\n# 130364 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), this.lazyIndexing ? expectedLazy3 : expectedEager3);
                continue;
            }
        }
    }

    private File getFirstQueueFile(File file) {
        return file.listFiles((d, n) -> n.endsWith(".cq4"))[0];
    }

    public void checkFileContents(@NotNull File file, String expected) throws FileNotFoundException {
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)65536L);
        bytes.readLimit(bytes.realCapacity());
        Assert.assertEquals((Object)expected, (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes));
        bytes.release();
    }

    @Test
    public void testWritingTwentyMessagesTinyIndex() throws FileNotFoundException, TimeoutException {
        for (int spacing : new int[]{1, 2, 4}) {
            File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
            dir.mkdir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(spacing).build();){
                long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
                ExcerptTailer tailer = queue.createTailer();
                Assert.assertFalse((boolean)tailer.moveToIndex(start));
                this.appendMessage(queue, start, "Hello World");
                String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    640,\n    2748779069440\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  640,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 640, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 130408 bytes remaining\n";
                String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    442,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 462,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 462, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n...\n# 130412 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), (this.lazyIndexing ? expectedLazy : expectedEager).replace("indexSpacing: 1", "indexSpacing: " + spacing).replace("lastIndex: 1", "lastIndex: " + spacing));
                Assert.assertTrue((boolean)tailer.moveToIndex(start));
                for (int i = 1; i < 19; ++i) {
                    Assert.assertFalse((boolean)tailer.moveToIndex(start + (long)i));
                    this.appendMessage(queue, start + (long)i, "Another Hello World " + (i + 1));
                    Assert.assertTrue((boolean)tailer.moveToIndex(start + (long)i));
                }
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 19L));
                this.appendMessage(queue, start + 19L, "Bye for now");
                Assert.assertTrue((boolean)tailer.moveToIndex(start + 19L));
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 20L));
                String expected1 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    1408,\n    6047313952787\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  544,\n  900,\n  1247,\n  0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  640,\n  660,\n  690,\n  720,\n  750,\n  780,\n  810,\n  840\n]\n# position: 640, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 660, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 690, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 720, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 750, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 780, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 810, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 840, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 870, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 900, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  870,\n  992,\n  1024,\n  1055,\n  1088,\n  1119,\n  1152,\n  1183\n]\n# position: 992, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 1024, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 1055, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 1088, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 1119, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 1152, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1183, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1216, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1247, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 4\n  1216,\n  1344,\n  1375,\n  1408,\n  0, 0, 0, 0\n]\n# position: 1344, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1375, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1408, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129640 bytes remaining\n";
                String expected2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    1311,\n    5630702125075\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 2,\n    index2Index: 442,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 2\n  544,\n  1152,\n  0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  640,\n  690,\n  750,\n  810,\n  870,\n  931,\n  993,\n  1055\n]\n# position: 640, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 660, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 690, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 720, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 750, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 780, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 810, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 840, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 870, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 900, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 931, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 962, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 993, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 1024, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 1055, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1088, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1119, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1152, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  1119,\n  1280,\n  0, 0, 0, 0, 0, 0\n]\n# position: 1248, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1280, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1311, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129737 bytes remaining\n";
                String expected3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    1216,\n    5222680231955\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 4,\n    index2Index: 442,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 5\n  640,\n  750,\n  870,\n  993,\n  1119,\n  0, 0, 0\n]\n# position: 640, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 660, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 690, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 720, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 750, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 780, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 810, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 840, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 870, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 900, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 931, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 962, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 993, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 1024, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 1055, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1088, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1119, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1152, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1183, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1216, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129832 bytes remaining\n";
                String lazy1 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    1216,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 462,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 462, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 656, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 686, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 716, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 746, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 776, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 806, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 836, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 866, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 896, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 927, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 960, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 991, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 1024, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 1055, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1088, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1119, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1152, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1183, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1216, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129832 bytes remaining\n";
                String lazy2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    1216,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 2,\n    index2Index: 462,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 462, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 656, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 686, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 716, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 746, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 776, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 806, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 836, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 866, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 896, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 927, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 960, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 991, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 1024, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 1055, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1088, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1119, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1152, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1183, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1216, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129832 bytes remaining\n";
                String lazy3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    1216,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 4,\n    index2Index: 462,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 462, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 656, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 686, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 716, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 746, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 776, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 806, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 836, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 866, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 896, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 927, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 960, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 991, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 1024, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 1055, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1088, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1119, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1152, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1183, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1216, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129832 bytes remaining\n";
                Assert.assertNotEquals((Object)lazy1, (Object)expected1);
                Assert.assertNotEquals((Object)lazy2, (Object)expected2);
                Assert.assertNotEquals((Object)lazy3, (Object)expected3);
                String expected = this.lazyIndexing ? (spacing == 1 ? lazy1 : (spacing == 2 ? lazy2 : lazy3)) : (spacing == 1 ? expected1 : (spacing == 2 ? expected2 : expected3));
                this.checkFileContents(this.getFirstQueueFile(dir), expected);
            }
        }
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
        this.threadDump.ignore("queue-thread-local-cleaner-daemon");
        this.threadDump.ignore("main/disk-space-checker");
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void resetAppendMode() {
        this.appendMode = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void appendMessage(@NotNull SingleChronicleQueue queue, long expectedIndex, String msg) {
        appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
        switch (this.appendMode) {
            case 1: {
                appender.writeDocument((WriteMarshallable)LambdaMetafactory.metafactory(null, null, null, (Lnet/openhft/chronicle/wire/WireOut;)V, lambda$appendMessage$2(java.lang.String net.openhft.chronicle.wire.WireOut ), (Lnet/openhft/chronicle/wire/WireOut;)V)((String)msg));
                break;
            }
            case 2: {
                bytes = Bytes.elasticByteBuffer();
                new BinaryWire(bytes).write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$3(), ()Ljava/lang/CharSequence;)()).text(msg);
                appender.writeBytes(bytes);
                bytes.release();
                break;
            }
            default: {
                dc = appender.writingDocument();
                var8_8 = null;
                wire = dc.wire();
                wire.write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$4(), ()Ljava/lang/CharSequence;)()).text(msg);
                if (dc == null) break;
                if (var8_8 == null) ** GOTO lbl28
                try {
                    dc.close();
                }
                catch (Throwable var9_10) {
                    var8_8.addSuppressed(var9_10);
                }
                break;
lbl28:
                // 1 sources

                dc.close();
                break;
                catch (Throwable var9_11) {
                    try {
                        var8_8 = var9_11;
                        throw var9_11;
                    }
                    catch (Throwable var10_12) {
                        if (dc != null) {
                            if (var8_8 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable var11_13) {
                                    var8_8.addSuppressed(var11_13);
                                }
                            } else {
                                dc.close();
                            }
                        }
                        throw var10_12;
                    }
                }
            }
        }
        index = appender.lastIndexAppended();
        SingleCQFormat2Test.assertHexEquals(expectedIndex, index);
    }

    public void readTwo(@NotNull ExcerptTailer tailer) {
        long start = RollCycles.DAILY.toIndex(1, 0L);
        Assert.assertEquals((long)start, (long)tailer.index());
        SingleCQFormat2Test.expected(tailer, "msg: Hello world\n");
        Assert.assertEquals((long)(start + 1L), (long)tailer.index());
        SingleCQFormat2Test.expected(tailer, "msg: Also hello world\n");
        Assert.assertEquals((long)(start + 2L), (long)tailer.index());
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
        Assert.assertEquals((long)(start + 2L), (long)tailer.index());
    }

    @Test
    public void writeMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("abc", "def");
        map.put("hello", "world");
        map.put("number", 1L);
        map.put("double", 1.28);
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            appender.writeMap(map);
            map.put("abc", "aye-bee-see");
            appender.writeMap(map);
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    700,\n    3006477107201\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  640,\n  700,\n  0, 0, 0, 0, 0, 0\n]\n# position: 640, header: 0\n--- !!data #binary\nabc: def\ndouble: 1.28\nhello: world\nnumber: 1\n# position: 700, header: 1\n--- !!data #binary\nabc: aye-bee-see\ndouble: 1.28\nhello: world\nnumber: 1\n...\n# 130300 bytes remaining\n";
            String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    502,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nabc: def\ndouble: 1.28\nhello: world\nnumber: 1\n# position: 502, header: 1\n--- !!data #binary\nabc: aye-bee-see\ndouble: 1.28\nhello: world\nnumber: 1\n...\n# 130498 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
            ExcerptTailer tailer = queue.createTailer();
            Map map2 = tailer.readMap();
            Map map3 = tailer.readMap();
            Assert.assertEquals((Object)"{abc=def, double=1.28, hello=world, number=1}", (Object)map2.toString());
            Assert.assertEquals((Object)"{abc=aye-bee-see, double=1.28, hello=world, number=1}", (Object)map3.toString());
            Assert.assertNull((Object)tailer.readMap());
        }
    }

    @Test
    public void writeMarshallable() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Order.class});
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            appender.writeDocument((WriteMarshallable)new Order("Symbol", Side.Buy, 1.2345, 1000000.0));
            appender.writeDocument(w -> w.write((CharSequence)"newOrder").object((Object)new Order("Symbol2", Side.Sell, 2.999, 1.0E7)));
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    695,\n    2985002270721\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  640,\n  695,\n  0, 0, 0, 0, 0, 0\n]\n# position: 640, header: 0\n--- !!data #binary\nsymbol: Symbol\nside: Buy\nlimitPrice: 1.2345\nquantity: 1E6\n# position: 695, header: 1\n--- !!data #binary\nnewOrder: !Order {\n  symbol: Symbol2,\n  side: Sell,\n  limitPrice: 2.999,\n  quantity: 10E6\n}\n...\n# 130294 bytes remaining\n";
            String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    497,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\nsymbol: Symbol\nside: Buy\nlimitPrice: 1.2345\nquantity: 1E6\n# position: 497, header: 1\n--- !!data #binary\nnewOrder: !Order {\n  symbol: Symbol2,\n  side: Sell,\n  limitPrice: 2.999,\n  quantity: 10E6\n}\n...\n# 130492 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
        }
    }

    @Test
    public void testWritingIndex() {
        String dir = OS.TARGET + "/testWritingIndex-" + System.nanoTime();
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single((String)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            appender.writeText((CharSequence)"msg-1");
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    640,\n    2748779069440\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  640,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 640, header: 0\n--- !!data\nmsg-1\n...\n# 130419 bytes remaining\n";
            String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    442,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data\nmsg-1\n...\n# 130617 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
            for (int i = 1; i <= 16; ++i) {
                appender.writeText((CharSequence)("msg-" + i));
            }
            String expectedEager2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    885,\n    3801046056976\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 17\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  544,\n  721,\n  895,\n  0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  640,\n  649,\n  658,\n  667,\n  676,\n  685,\n  694,\n  703\n]\n# position: 640, header: 0\n--- !!data\nmsg-1\n# position: 649, header: 1\n--- !!data\nmsg-1\n# position: 658, header: 2\n--- !!data\nmsg-2\n# position: 667, header: 3\n--- !!data\nmsg-3\n# position: 676, header: 4\n--- !!data\nmsg-4\n# position: 685, header: 5\n--- !!data\nmsg-5\n# position: 694, header: 6\n--- !!data\nmsg-6\n# position: 703, header: 7\n--- !!data\nmsg-7\n# position: 712, header: 8\n--- !!data\nmsg-8\n# position: 721, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  712,\n  816,\n  825,\n  835,\n  845,\n  855,\n  865,\n  875\n]\n# position: 816, header: 9\n--- !!data\nmsg-9\n# position: 825, header: 10\n--- !!data\nmsg-10\n# position: 835, header: 11\n--- !!data\nmsg-11\n# position: 845, header: 12\n--- !!data\nmsg-12\n# position: 855, header: 13\n--- !!data\nmsg-13\n# position: 865, header: 14\n--- !!data\nmsg-14\n# position: 875, header: 15\n--- !!data\nmsg-15\n# position: 885, header: 16\n--- !!data\nmsg-16\n# position: 895, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  885,\n  0, 0, 0, 0, 0, 0, 0\n]\n...\n# 130076 bytes remaining\n";
            String expectedLazy2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    592,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data\nmsg-1\n# position: 451, header: 1\n--- !!data\nmsg-1\n# position: 460, header: 2\n--- !!data\nmsg-2\n# position: 469, header: 3\n--- !!data\nmsg-3\n# position: 478, header: 4\n--- !!data\nmsg-4\n# position: 487, header: 5\n--- !!data\nmsg-5\n# position: 496, header: 6\n--- !!data\nmsg-6\n# position: 505, header: 7\n--- !!data\nmsg-7\n# position: 514, header: 8\n--- !!data\nmsg-8\n# position: 523, header: 9\n--- !!data\nmsg-9\n# position: 532, header: 10\n--- !!data\nmsg-10\n# position: 542, header: 11\n--- !!data\nmsg-11\n# position: 552, header: 12\n--- !!data\nmsg-12\n# position: 562, header: 13\n--- !!data\nmsg-13\n# position: 572, header: 14\n--- !!data\nmsg-14\n# position: 582, header: 15\n--- !!data\nmsg-15\n# position: 592, header: 16\n--- !!data\nmsg-16\n...\n# 130466 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy2 : expectedEager2), (Object)queue.dump());
        }
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$4() {
        return "msg";
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$3() {
        return "msg";
    }

    private static /* synthetic */ void lambda$appendMessage$2(String msg, WireOut w) {
        w.write(() -> "msg").text(msg);
    }

    static {
        SingleChronicleQueueBuilder.init();
    }

    private static class MyData
    extends AbstractMarshallable {
        final String name;
        final long num;
        final double d;
        final int counter;

        MyData(String name, long num, double d, int counter) {
            this.name = name;
            this.num = num;
            this.d = d;
            this.counter = counter;
        }
    }
}

