/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;

public class MonitorEventLoop
implements EventLoop,
Runnable,
Closeable {
    static int MONITOR_INITIAL_DELAY = Integer.getInteger("MonitorInitialDelay", 60000);
    final ExecutorService service;
    private final EventLoop parent;
    private final List<EventHandler> handlers = new ArrayList<EventHandler>();
    private final Pauser pauser;
    private volatile boolean running = true;

    public MonitorEventLoop(EventLoop parent, Pauser pauser) {
        this(parent, "", pauser);
    }

    public MonitorEventLoop(EventLoop parent, String name, Pauser pauser) {
        this.parent = parent;
        this.pauser = pauser;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name + "event-loop-monitor", true));
    }

    @Override
    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void start() {
        this.running = true;
        this.service.submit(this);
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public boolean isClosed() {
        return !this.service.isShutdown();
    }

    @Override
    public boolean isAlive() {
        return this.running;
    }

    @Override
    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        this.addHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(@NotNull EventHandler handler) {
        List<EventHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
            handler.eventLoop(this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try {
            for (int i = 0; i < MONITOR_INITIAL_DELAY; i += 50) {
                if (!this.running) continue;
                Jvm.pause(50L);
            }
            while (this.running && !Thread.currentThread().isInterrupted()) {
                boolean busy;
                List<EventHandler> list = this.handlers;
                synchronized (list) {
                    busy = this.runHandlers();
                }
                this.pauser.pause();
                if (!busy) continue;
                this.pauser.reset();
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @HotMethod
    private boolean runHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            EventHandler handler = this.handlers.get(i);
            if (handler == null) continue;
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.handlers.remove(i--);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), "Loop terminated due to exception", e);
            }
        }
        return busy;
    }

    @Override
    public void close() {
        this.stop();
        Threads.shutdownDaemon(this.service);
    }
}

