/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import net.openhft.chronicle.threads.Pauser;

public class TSQueueLock
implements QueueLock {
    private static final String QUEUE_LOCK_FILE = "queue-lock.cq4t";
    private static final String LOCK_KEY = "chronicle.queue.lock";
    private static final long LOCK_WAIT_TIMEOUT = Long.getLong("chronicle.queue.lock.timeoutMS", 15000L);
    private static final long UNLOCKED = Long.MIN_VALUE;
    private static final long PID = Jvm.getProcessId();
    private final LongValue lock;
    private final Pauser pauser;
    private final ThreadLocal<Long> lockHolderTidTL = new ThreadLocal();
    private final String path;

    public TSQueueLock(File queueDirectoryPath, Supplier<Pauser> pauser) {
        File storeFilePath;
        if ("".equals(queueDirectoryPath.getPath())) {
            storeFilePath = new File(QUEUE_LOCK_FILE);
        } else {
            storeFilePath = new File(queueDirectoryPath, QUEUE_LOCK_FILE);
            queueDirectoryPath.mkdirs();
        }
        TableStore tableStore = SingleTableBuilder.binary(storeFilePath).build();
        this.lock = tableStore.doWithExclusiveLock(ts -> ts.acquireValueFor(LOCK_KEY));
        this.pauser = pauser.get();
        this.path = storeFilePath.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock() {
        long tid = Thread.currentThread().getId();
        try {
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, PID)) {
                if (Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(LOCK_WAIT_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            this.lockHolderTidTL.set(tid);
        }
        catch (TimeoutException e) {
            Jvm.warn().on(this.getClass(), "Couldn't acquire lock after " + LOCK_WAIT_TIMEOUT + "ms for the lock file:" + this.path + ", overriding the lock. Lock was held by PID " + this.lock.getVolatileValue());
            this.forceUnlock();
            this.acquireLock();
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void checkLock() {
        if (this.isLockHeldByCurrentThread()) {
            return;
        }
        try {
            while (this.lock.getVolatileValue() != Long.MIN_VALUE) {
                if (Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(LOCK_WAIT_TIMEOUT, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException e) {
            Jvm.warn().on(this.getClass(), "Queue lock is still held after " + LOCK_WAIT_TIMEOUT + "ms for the lock file:" + this.path + ". Lock is held by PID " + this.lock.getVolatileValue() + ". Unlocking forcibly");
            this.forceUnlock();
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void unlock() {
        if (!this.isLockHeldByCurrentThread()) {
            throw new IllegalStateException("Can't unlock when lock is not held by this thread");
        }
        if (!this.lock.compareAndSwapValue(PID, Long.MIN_VALUE)) {
            Jvm.warn().on(this.getClass(), "Queue lock was unlocked by someone else!");
        }
        this.lockHolderTidTL.remove();
    }

    private boolean isLockHeldByCurrentThread() {
        long tid = Thread.currentThread().getId();
        Long lockHolderTid = this.lockHolderTidTL.get();
        return lockHolderTid != null && lockHolderTid == tid;
    }

    private void forceUnlock() {
        this.lock.setValue(Long.MIN_VALUE);
    }
}

