/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedNativeBytes<Underlying>
implements Bytes<Underlying> {
    protected final long capacity;
    @NotNull
    private final Bytes<Underlying> underlyingBytes;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    @NotNull
    protected NativeBytesStore<Underlying> bytesStore;
    protected long readPosition;
    protected long writePosition;
    protected long writeLimit;
    private int lastDecimalPlaces = 0;

    public UncheckedNativeBytes(@NotNull Bytes<Underlying> underlyingBytes) throws IllegalStateException {
        this.underlyingBytes = underlyingBytes;
        this.bytesStore = (NativeBytesStore)underlyingBytes.bytesStore();
        assert (this.bytesStore.start() == 0L);
        this.writePosition = underlyingBytes.writePosition();
        this.writeLimit = underlyingBytes.writeLimit();
        this.readPosition = underlyingBytes.readPosition();
        this.capacity = this.bytesStore.capacity();
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        if (size > this.realCapacity()) {
            this.underlyingBytes.ensureCapacity(size);
            this.bytesStore = (NativeBytesStore)this.underlyingBytes.bytesStore();
        }
    }

    @Override
    public boolean unchecked() {
        return true;
    }

    @Override
    public boolean isDirectMemory() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<Underlying> unchecked(boolean unchecked) {
        return this;
    }

    @Override
    public void move(long from, long to, long length) {
        this.bytesStore.move(from - this.start(), to - this.start(), length);
    }

    @Override
    @NotNull
    public Bytes<Underlying> compact() {
        long start = this.start();
        long readRemaining = this.readRemaining();
        if (readRemaining > 0L && start < this.readPosition) {
            this.bytesStore.move(this.readPosition, start, readRemaining);
            this.readPosition = start;
            this.writePosition = this.readPosition + readRemaining;
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readPosition(long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readLimit(long limit) {
        this.writePosition = limit;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writePosition(long position) {
        this.writePosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public void uncheckedReadSkipOne() {
        ++this.readPosition;
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        --this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSkip(long bytesToSkip) {
        this.writePosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLimit(long limit) {
        this.writeLimit = limit;
        return this;
    }

    @Override
    @NotNull
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    protected long readOffsetPositionMoved(long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    protected long writeOffsetPositionMoved(long adding) {
        return this.writeOffsetPositionMoved(adding, adding);
    }

    protected long writeOffsetPositionMoved(long adding, long advance) {
        long oldPosition = this.writePosition;
        long writeEnd = oldPosition + adding;
        assert (writeEnd <= this.bytesStore.safeLimit());
        this.writePosition += advance;
        return oldPosition;
    }

    protected long prewriteOffsetPositionMoved(long substracting) {
        return this.readPosition -= substracting;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes, long offset, long length) throws BufferUnderflowException, BufferOverflowException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (length >= 16L && bytes.isDirectMemory()) {
            this.rawCopy(bytes, offset, length);
        } else {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    public void rawCopy(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            OS.memory().copyMemory(bytes.addressForRead(offset), this.addressForWrite(this.writePosition()), len);
            this.writeSkip(len);
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> clear() {
        this.readPosition = this.writePosition = this.start();
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> clearAndPad(long length) throws BufferOverflowException {
        if (this.start() + length > this.capacity()) {
            throw new BufferOverflowException();
        }
        this.readPosition = this.writePosition = this.start() + length;
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @ForceInline
    public long readLimit() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    @ForceInline
    public long realCapacity() {
        return this.capacity();
    }

    @Override
    @ForceInline
    public long capacity() {
        return this.capacity;
    }

    @Override
    @Nullable
    public Underlying underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    @ForceInline
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    @ForceInline
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    void performRelease() {
        this.underlyingBytes.release();
    }

    @Override
    public int readUnsignedByte() {
        long offset = this.readOffsetPositionMoved(1L);
        return this.bytesStore.memory.readByte(this.bytesStore.address + offset) & 0xFF;
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        return this.readUnsignedByte();
    }

    @Override
    @ForceInline
    public byte readByte() {
        long offset = this.readOffsetPositionMoved(1L);
        return this.bytesStore.memory.readByte(this.bytesStore.address + offset);
    }

    @Override
    @ForceInline
    public int peekUnsignedByte() {
        try {
            return this.readRemaining() > 0L ? this.bytesStore.readUnsignedByte(this.readPosition) : -1;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    @ForceInline
    public short readShort() {
        long offset = this.readOffsetPositionMoved(2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readDouble(offset);
    }

    @Override
    @ForceInline
    public int readVolatileInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    @ForceInline
    public long readVolatileLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    @Override
    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    @Override
    public long refCount() {
        return this.refCount.get();
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeByte(long offset, byte i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeShort(long offset, short i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeInt(long offset, int i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedInt(long offset, int i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeLong(long offset, long i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long offset, long i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeFloat(long offset, float d) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeDouble(long offset, double d) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, @NotNull RandomDataInput bytes, long offset, long length) throws BufferUnderflowException, BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @ForceInline
    void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
    }

    private boolean writeCheckOffset0(long offset, long adding) throws BufferOverflowException {
        if (offset < this.start()) {
            throw new BufferOverflowException();
        }
        if (offset + adding > this.writeLimit()) {
            assert (offset + adding <= this.writeLimit()) : "cant add bytes past the limit : limit=" + this.writeLimit() + ",offset=" + offset + ",adding=" + adding;
            throw new BufferOverflowException();
        }
        return true;
    }

    @Override
    @ForceInline
    public byte readByte(long offset) {
        return this.bytesStore.readByte(offset);
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.bytesStore.memory.readByte(this.bytesStore.address + offset) & 0xFF;
    }

    @Override
    public int peekUnsignedByte(long offset) {
        return offset >= this.writePosition ? -1 : (int)this.readByte(offset);
    }

    @Override
    @ForceInline
    public short readShort(long offset) {
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt(long offset) {
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong(long offset) {
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat(long offset) {
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble(long offset) {
        return this.bytesStore.readDouble(offset);
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.memory.writeByte(this.bytesStore.address + offset, i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteByte(byte i8) {
        long offset = this.prewriteOffsetPositionMoved(1L);
        this.bytesStore.memory.writeByte(this.bytesStore.address + offset, i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeShort(short i16) {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteShort(short i16) {
        long offset = this.prewriteOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeIntAdv(int i, int advance) {
        long offset = this.writeOffsetPositionMoved(4L, advance);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteInt(int i) {
        long offset = this.prewriteOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeLong(long i64) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeLongAdv(long i64, int advance) {
        long offset = this.writeOffsetPositionMoved(8L, advance);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteLong(long i64) {
        long offset = this.prewriteOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeFloat(float f) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeDouble(double d) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeDoubleAndInt(double d, int i) {
        long offset = this.writeOffsetPositionMoved(12L);
        this.bytesStore.writeDouble(offset, d);
        this.bytesStore.writeInt(offset + 8L, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(@NotNull byte[] bytes, int offset, int length) {
        if (length + offset > bytes.length) {
            throw new ArrayIndexOutOfBoundsException("bytes.length=" + bytes.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        long offsetInRDO = this.writeOffsetPositionMoved(length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewrite(@NotNull byte[] bytes) {
        long offsetInRDO = this.prewriteOffsetPositionMoved(bytes.length);
        this.bytesStore.write(offsetInRDO, bytes);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewrite(@NotNull BytesStore bytes) {
        long offsetInRDO = this.prewriteOffsetPositionMoved(bytes.length());
        this.bytesStore.write(offsetInRDO, bytes);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeSome(@NotNull ByteBuffer buffer) {
        this.bytesStore.write(this.writePosition, buffer, buffer.position(), buffer.limit());
        this.writePosition += (long)buffer.remaining();
        assert (this.writePosition <= this.writeLimit());
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long i) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException {
        return this.bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForWrite(long offset) throws BufferOverflowException {
        return this.bytesStore.addressForWrite(offset);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("todo");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bytes)) {
            return false;
        }
        Bytes b2 = (Bytes)obj;
        long remaining = this.readRemaining();
        return b2.readRemaining() == remaining && this.equalsBytes(b2, remaining);
    }

    public boolean equalsBytes(@NotNull Bytes b2, long remaining) {
        try {
            long i;
            for (i = 0L; i < remaining - 7L; i += 8L) {
                if (this.readLong(this.readPosition() + i) == b2.readLong(b2.readPosition() + i)) continue;
                return false;
            }
            while (i < remaining) {
                if (this.readByte(this.readPosition() + i) != b2.readByte(b2.readPosition() + i)) {
                    return false;
                }
                ++i;
            }
        }
        catch (BufferUnderflowException e) {
            throw Jvm.rethrow(e);
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return BytesInternal.toString(this);
    }

    @Override
    @ForceInline
    public void nativeRead(long address, long size) {
        this.bytesStore.nativeRead(this.readPosition(), address, size);
        this.readSkip(size);
    }

    @Override
    public void lenient(boolean lenient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean lenient() {
        return false;
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long size) {
        this.bytesStore.nativeWrite(address, this.writePosition(), size);
        this.writeSkip(size);
    }

    @Override
    @ForceInline
    public void nativeRead(long position, long address, long size) {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long position, long size) {
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this.bytesStore;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        NativeBytesStore bytesStore = (NativeBytesStore)this.bytesStore();
        return bytesStore.byteCheckSum(this.readPosition(), this.readLimit());
    }

    @Override
    @NotNull
    public Bytes<Underlying> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException {
        if (cs instanceof BytesStore) {
            return this.write((BytesStore)cs);
        }
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        long address = this.bytesStore.addressForWrite(offset);
        Memory memory = this.bytesStore.memory;
        assert (memory != null);
        try {
            char c;
            int i;
            for (i = 0; i < length - 1; i += 2) {
                c = cs.charAt(i);
                char c2 = cs.charAt(i + 1);
                memory.writeByte(address + (long)i, (byte)c);
                memory.writeByte(address + (long)i + 1L, (byte)c2);
            }
            while (i < length) {
                c = cs.charAt(i);
                memory.writeByte(address + (long)i, (byte)c);
                ++i;
            }
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        this.ensureCapacity(this.writePosition() + (long)length);
        NativeBytesStore<Underlying> nbs = this.bytesStore;
        long position = nbs.appendUtf8(this.writePosition(), chars, offset, length);
        this.writePosition(position);
        return this;
    }

    @Override
    public int lastDecimalPlaces() {
        return this.lastDecimalPlaces;
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.lastDecimalPlaces = Math.max(0, lastDecimalPlaces);
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes) {
        assert (bytes != this) : "you should not write to yourself !";
        try {
            return this.write(bytes, bytes.readPosition(), Math.min(this.writeRemaining(), bytes.readRemaining()));
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }
}

