/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedBytes
extends AbstractBytes<Void>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedBytes.class);
    private static final boolean ENFORCE_SINGLE_THREADED_ACCESS = Boolean.getBoolean("chronicle.bytes.enforceSingleThreadedAccess");
    @NotNull
    private final MappedFile mappedFile;
    private final boolean backingFileIsReadOnly;
    private volatile Thread lastAccessedThread;
    private volatile RuntimeException writeStack;

    protected MappedBytes(@NotNull MappedFile mappedFile) throws IllegalStateException {
        this(mappedFile, "");
    }

    protected MappedBytes(@NotNull MappedFile mappedFile, String name) throws IllegalStateException {
        super(NoBytesStore.noBytesStore(), NoBytesStore.noBytesStore().writePosition(), NoBytesStore.noBytesStore().writeLimit(), name);
        this.mappedFile = MappedBytes.reserve(mappedFile);
        boolean bl = this.backingFileIsReadOnly = !mappedFile.file().canWrite();
        assert (!mappedFile.isClosed());
        this.clear();
    }

    @NotNull
    private static MappedFile reserve(@NotNull MappedFile mappedFile) {
        mappedFile.reserve();
        return mappedFile;
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull String filename, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(file, chunkSize, OS.pageSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException, IllegalStateException {
        MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, false);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize, boolean readOnly) throws FileNotFoundException, IllegalStateException {
        MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, readOnly);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release();
        }
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull MappedFile rw) {
        return new MappedBytes(rw);
    }

    @NotNull
    public static MappedBytes readOnly(@NotNull File file) throws FileNotFoundException {
        return new MappedBytes(MappedFile.readOnly(file));
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.mappedFile.setNewChunkListener(listener);
    }

    @NotNull
    public MappedFile mappedFile() {
        return this.mappedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MappedBytes withSizes(long chunkSize, long overlapSize) {
        MappedFile mappedFile2 = this.mappedFile.withSizes(chunkSize, overlapSize);
        if (mappedFile2 == this.mappedFile) {
            return this;
        }
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(mappedFile2);
            return mappedBytes;
        }
        finally {
            mappedFile2.release();
            this.release();
        }
    }

    @Override
    public BytesStore<Bytes<Void>, Void> copy() {
        return NativeBytes.copyOf(this);
    }

    @Override
    public long capacity() {
        return this.mappedFile == null ? 0L : this.mappedFile.capacity();
    }

    @Override
    public long realCapacity() {
        try {
            return this.mappedFile.actualSize();
        }
        catch (IORuntimeException e) {
            Jvm.warn().on(this.getClass(), "Unable to obtain the real size for " + this.mappedFile.file(), e);
            return 0L;
        }
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionRemaining(long position, long remaining) throws BufferUnderflowException {
        long limit = position + remaining;
        if (!this.bytesStore.inside(position)) {
            this.acquireNextByteStore(position, true);
        } else if (!this.bytesStore.inside(limit)) {
            this.acquireNextByteStore(limit, false);
        }
        if (this.writeLimit < limit) {
            this.writeLimit(limit);
        }
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (debug) {
            this.readLimit(limit);
        } else {
            this.uncheckedWritePosition(limit);
        }
        return this.readPosition(position);
    }

    @Override
    @NotNull
    public Bytes<Void> readPosition(long position) throws BufferUnderflowException {
        if (this.bytesStore.inside(position)) {
            return super.readPosition(position);
        }
        this.acquireNextByteStore(position, true);
        return this;
    }

    @Override
    protected void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException {
        long check;
        long l = check = adding >= 0L ? offset : offset + adding;
        if (!this.bytesStore.inside(check)) {
            this.acquireNextByteStore(offset, false);
        }
        super.readCheckOffset(offset, adding, given);
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        if (offset < 0L || offset > this.mappedFile.capacity() - adding) {
            throw this.writeBufferOverflowException(offset);
        }
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset, false);
        }
    }

    @NotNull
    private BufferOverflowException writeBufferOverflowException(long offset) {
        BufferOverflowException exception = new BufferOverflowException();
        exception.initCause(new IllegalArgumentException("Offset out of bound " + offset));
        return exception;
    }

    private synchronized void acquireNextByteStore(long offset, boolean set) throws BufferOverflowException {
        BytesStore oldBS = this.bytesStore;
        if (oldBS.inside(offset)) {
            return;
        }
        try {
            MappedBytesStore newBS = this.mappedFile.acquireByteStore(offset);
            this.bytesStore = newBS;
            oldBS.release();
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.initCause(e);
            throw boe;
        }
        if (set) {
            if (this.writeLimit() < this.readPosition) {
                this.writeLimit(this.readPosition);
            }
            if (this.readLimit() < this.readPosition) {
                this.readLimit(this.readPosition);
            }
            this.readPosition = offset;
        }
    }

    @Override
    @NotNull
    public Bytes<Void> readSkip(long bytesToSkip) throws BufferUnderflowException {
        long check;
        if (this.readPosition + bytesToSkip > this.readLimit()) {
            throw new BufferUnderflowException();
        }
        long l = check = bytesToSkip >= 0L ? this.readPosition : this.readPosition + bytesToSkip;
        if (!this.bytesStore.inside(check)) {
            this.acquireNextByteStore(this.readPosition, false);
        }
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @Nullable
    public MappedBytesStore bytesStore() {
        return (MappedBytesStore)super.bytesStore();
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    @NotNull
    public Bytes<Void> writePosition(long position) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        if (position > this.writeLimit) {
            throw new BufferOverflowException();
        }
        if (position < 0L) {
            throw new BufferUnderflowException();
        }
        if (position < this.readPosition) {
            this.readPosition = position;
        }
        this.writePosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> clear() {
        long start;
        this.readPosition = start = 0L;
        this.writePosition = start;
        this.writeLimit = this.mappedFile.capacity();
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeByte(byte i8) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        long oldPosition = this.writePosition;
        if (this.writePosition < 0L || this.writePosition > this.capacity() - 1L) {
            throw this.writeBufferOverflowException(this.writePosition);
        }
        if (!this.bytesStore.inside(this.writePosition)) {
            this.acquireNextByteStore(this.writePosition, false);
        }
        ++this.writePosition;
        this.bytesStore.writeByte(oldPosition, i8);
        return this;
    }

    @Override
    protected void performRelease() throws IllegalStateException {
        super.performRelease();
        this.mappedFile.release();
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    public boolean isBackingFileReadOnly() {
        return this.backingFileIsReadOnly;
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NotNull BytesStore bytes, long offset, long length) throws BufferUnderflowException, BufferOverflowException {
        assert (this.singleThreadedAccess());
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.isDirectMemory() && length >= 16L) {
            this.rawCopy(bytes, offset, length);
        } else {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    public void rawCopy(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
        if (len > 0L) {
            OS.memory().copyMemory(bytes.addressForRead(offset), this.addressForWrite(this.writePosition()), len);
            this.uncheckedWritePosition(this.writePosition() + len);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> append8bit(@NotNull CharSequence cs, int start, int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        assert (this.singleThreadedAccess());
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(cs instanceof String) || pos + (long)((end - start) * 3) + 5L >= this.safeLimit()) {
            return (Bytes)super.append8bit(cs, start, end);
        }
        return this.append8bit0((String)cs, start, end - start);
    }

    @Override
    @NotNull
    public MappedBytes write8bit(CharSequence s, int start, int length) {
        assert (this.singleThreadedAccess());
        if (s == null) {
            this.writeStopBit(-1L);
            return this;
        }
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(s instanceof String) || pos + (long)(length * 3) + 5L >= this.safeLimit()) {
            super.write8bit(s, start, length);
            return this;
        }
        this.writeStopBit(length);
        return this.append8bit0((String)s, start, length);
    }

    @NotNull
    private MappedBytes append8bit0(@NotNull String s, int start, int length) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        if (Jvm.isJava9Plus()) {
            int i;
            byte[] bytes = StringUtils.extractBytes(s);
            long address = this.addressForWrite(this.writePosition());
            Memory memory = this.bytesStore().memory;
            for (i = 0; i < length - 3; i += 4) {
                int c0 = bytes[i + start] & 0xFF;
                int c1 = bytes[i + start + 1] & 0xFF;
                int c2 = bytes[i + start + 2] & 0xFF;
                int c3 = bytes[i + start + 3] & 0xFF;
                memory.writeInt(address, c3 << 24 | c2 << 16 | c1 << 8 | c0);
                address += 4L;
            }
            while (i < length) {
                byte c = bytes[i + start];
                memory.writeByte(address++, c);
                ++i;
            }
            this.writeSkip(length);
        } else {
            int i;
            char[] chars = StringUtils.extractChars(s);
            long address = this.addressForWrite(this.writePosition());
            Memory memory = this.bytesStore().memory;
            for (i = 0; i < length - 3; i += 4) {
                int c0 = chars[i + start] & 0xFF;
                int c1 = chars[i + start + 1] & 0xFF;
                int c2 = chars[i + start + 2] & 0xFF;
                int c3 = chars[i + start + 3] & 0xFF;
                memory.writeInt(address, c3 << 24 | c2 << 16 | c1 << 8 | c0);
                address += 4L;
            }
            while (i < length) {
                char c = chars[i + start];
                memory.writeByte(address++, (byte)c);
                ++i;
            }
            this.writeSkip(length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> appendUtf8(CharSequence cs, int start, int length) throws BufferOverflowException, IllegalArgumentException {
        assert (this.singleThreadedAccess());
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(cs instanceof String) || pos + (long)(length * 3) + 5L >= this.safeLimit()) {
            super.appendUtf8(cs, start, length);
            return this;
        }
        if (Jvm.isJava9Plus()) {
            byte c;
            int i;
            byte[] bytes;
            block10: {
                bytes = StringUtils.extractBytes((String)cs);
                long address = this.addressForWrite(pos);
                Memory memory = OS.memory();
                for (i = 0; i < length; ++i) {
                    c = bytes[i + start];
                    if (c > 127) {
                        this.writeSkip(i);
                        break block10;
                    }
                    memory.writeByte(address++, c);
                }
                this.writeSkip(length);
                return this;
            }
            while (i < length) {
                c = bytes[i + start];
                this.appendUtf8(c);
                ++i;
            }
        } else {
            char c;
            int i;
            char[] chars;
            block11: {
                chars = StringUtils.extractChars((String)cs);
                long address = this.addressForWrite(pos);
                Memory memory = OS.memory();
                for (i = 0; i < length; ++i) {
                    c = chars[i + start];
                    if (c > '\u007f') {
                        this.writeSkip(i);
                        break block11;
                    }
                    memory.writeByte(address++, (byte)c);
                }
                this.writeSkip(length);
                return this;
            }
            while (i < length) {
                c = chars[i + start];
                this.appendUtf8(c);
                ++i;
            }
        }
        return this;
    }

    @Override
    public boolean sharedMemory() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(long offset, int i) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        assert (this.writeCheckOffset0(offset, 4L));
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset, false);
        }
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset, false);
        }
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset, false);
        }
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset, false);
        }
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        if (!this.bytesStore.inside(offset)) {
            this.acquireNextByteStore(offset, false);
        }
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public int peekVolatileInt() {
        if (!this.bytesStore.inside(this.readPosition)) {
            this.acquireNextByteStore(this.readPosition, true);
        }
        MappedBytesStore bytesStore = (MappedBytesStore)this.bytesStore;
        long address = bytesStore.address + bytesStore.translate(this.readPosition);
        Memory memory = bytesStore.memory;
        if ((address & 0x3FL) <= 60L) {
            memory.getClass();
            return UnsafeMemory.UNSAFE.getIntVolatile(null, address);
        }
        return memory.readVolatileInt(address);
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public boolean isClosed() {
        return this.refCount() <= 0L;
    }

    @Override
    @NotNull
    public MappedBytes write(@NotNull BytesStore bytes) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        assert (bytes != this) : "you should not write to yourself !";
        long offset = bytes.readPosition();
        long length = Math.min(this.writeRemaining(), bytes.readRemaining());
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.isDirectMemory() && length >= 16L && length <= this.writeRemaining()) {
            this.rawCopy(bytes, offset, length);
        } else {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeUtf8(CharSequence str) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        if (str instanceof String) {
            this.writeUtf8((String)str);
            return this;
        }
        if (str == null) {
            this.writeStopBit(-1L);
        } else {
            try {
                long utfLength = AppendableUtil.findUtf8Length(str);
                this.writeStopBit(utfLength);
                BytesInternal.appendUtf8(this, str, 0, str.length());
            }
            catch (IndexOutOfBoundsException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this;
    }

    @Override
    public Bytes<Void> writeUtf8(String str) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        if (str == null) {
            this.writeStopBit(-1L);
            return this;
        }
        try {
            if (Jvm.isJava9Plus()) {
                byte[] strBytes = StringUtils.extractBytes(str);
                byte coder = StringUtils.getStringCoder(str);
                long utfLength = AppendableUtil.findUtf8Length(strBytes, coder);
                this.writeStopBit(utfLength);
                this.appendUtf8(strBytes, 0, str.length(), coder);
            } else {
                char[] chars = StringUtils.extractChars(str);
                long utfLength = AppendableUtil.findUtf8Length(chars);
                this.writeStopBit(utfLength);
                this.appendUtf8(chars, 0, chars.length);
            }
            return this;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        char c;
        int i;
        block6: {
            assert (this.singleThreadedAccess());
            if (this.writePosition < 0L || this.writePosition > this.capacity() - 1L + (long)length) {
                throw this.writeBufferOverflowException(this.writePosition);
            }
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    long oldPosition = this.writePosition;
                    if ((this.writePosition & 0xFFL) == 0L && !this.bytesStore.inside(this.writePosition)) {
                        this.acquireNextByteStore(this.writePosition, false);
                    }
                    ++this.writePosition;
                    this.bytesStore.writeByte(oldPosition, (byte)c);
                    continue;
                }
                break block6;
            }
            return this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeStopBit(long n) throws BufferOverflowException {
        assert (this.singleThreadedAccess());
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.writeByte((byte)(n & 0x7FL));
            return this;
        }
        if (((n ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.writeByte((byte)(0x80L | n ^ 0xFFFFFFFFFFFFFFFFL));
            this.writeByte((byte)0);
            return this;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            this.writeByte((byte)(n & 0x7FL | 0x80L));
            this.writeByte((byte)(n >> 7));
            return this;
        }
        BytesInternal.writeStopBit0(this, n);
        return this;
    }

    private boolean singleThreadedAccess() {
        boolean isSingleThreaded;
        if (!ENFORCE_SINGLE_THREADED_ACCESS) {
            return true;
        }
        if (this.lastAccessedThread == null) {
            this.lastAccessedThread = Thread.currentThread();
        }
        boolean bl = isSingleThreaded = this.lastAccessedThread == Thread.currentThread();
        if (!isSingleThreaded) {
            LOGGER.warn("Detected multi-threaded write access. Initial write stack:", this.writeStack);
            LOGGER.warn("Current write stack: ", new RuntimeException());
        }
        if (this.writeStack == null) {
            this.writeStack = new RuntimeException();
        }
        return isSingleThreaded;
    }
}

