/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.Wires;

public final class QueueInspector {
    private static final int NO_CURRENT_WRITER = Integer.MIN_VALUE;
    private final SingleChronicleQueue queue;

    public QueueInspector(SingleChronicleQueue queue) {
        this.queue = queue;
    }

    public int getWritingThreadId() {
        WireStore wireStore = this.queue.storeForCycle(this.queue.cycle(), this.queue.epoch(), false);
        if (wireStore != null) {
            long position = wireStore.writePosition();
            int header = wireStore.bytes().readVolatileInt(position);
            if (Wires.isReady((int)header)) {
                long nextHeaderPosition = position + (long)Wires.lengthOf((int)header) + 4L;
                int unfinishedHeader = wireStore.bytes().readVolatileInt(nextHeaderPosition);
                if (Wires.isNotComplete((int)unfinishedHeader) && unfinishedHeader != 0) {
                    return Wires.extractTidFromHeader((int)unfinishedHeader);
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    public static boolean isValidThreadId(int writingThreadId) {
        return writingThreadId != Integer.MIN_VALUE;
    }
}

