/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class WriteBytesTest {
    final Bytes outgoingBytes = Bytes.elasticByteBuffer();
    private final byte[] incomingMsgBytes = new byte[100];
    private final byte[] outgoingMsgBytes = new byte[100];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteBytes() {
        File dir = DirectoryUtils.tempDir("WriteBytesTest");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();){
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer tailer = queue.createTailer();
            this.outgoingMsgBytes[0] = 65;
            this.outgoingBytes.write(this.outgoingMsgBytes);
            this.postOneMessage(appender);
            this.fetchOneMessage(tailer, this.incomingMsgBytes);
            System.out.println(new String(this.incomingMsgBytes));
            this.outgoingBytes.clear();
            this.outgoingMsgBytes[0] = 65;
            this.outgoingMsgBytes[1] = 66;
            this.outgoingBytes.write(this.outgoingMsgBytes);
            this.postOneMessage(appender);
            this.fetchOneMessage(tailer, this.incomingMsgBytes);
            System.out.println(new String(this.incomingMsgBytes));
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)dir, (int)2);
            }
            catch (IORuntimeException iORuntimeException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteBytesAndDump() {
        File dir = DirectoryUtils.tempDir("WriteBytesTestAndDump");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST4_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            for (int i = -128; i <= 127; ++i) {
                byte finalI = (byte)i;
                appender.writeBytes(b -> b.writeLong((long)finalI * 0x101010101010101L));
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    4368,\n    18760417149183\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 442,\n    lastIndex: 256\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 2\n  736,\n  2572,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 736, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 32\n  1024,\n  1072,\n  1120,\n  1168,\n  1216,\n  1264,\n  1312,\n  1360,\n  1408,\n  1456,\n  1504,\n  1552,\n  1600,\n  1648,\n  1696,\n  1744,\n  1792,\n  1840,\n  1888,\n  1936,\n  1984,\n  2032,\n  2080,\n  2128,\n  2176,\n  2224,\n  2272,\n  2320,\n  2368,\n  2416,\n  2464,\n  2512\n]\n# position: 1024, header: 0\n--- !!data #binary\n00000400             80 7f 7f 7f  7f 7f 7f 7f                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1036, header: 1\n--- !!data #binary\n00000410 81 80 80 80 80 80 80 80                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1048, header: 2\n--- !!data #binary\n00000410                                      82 81 81 81              \u00b7\u00b7\u00b7\u00b7\n00000420 81 81 81 81                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1060, header: 3\n--- !!data #binary\n00000420                          83 82 82 82 82 82 82 82          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1072, header: 4\n--- !!data #binary\n# # Unknown_0x84\n# # Unknown_0x83\n# # Unknown_0x83\n# # Unknown_0x83\n# # Unknown_0x83\n# # Unknown_0x83\n# # Unknown_0x83\n# # Unknown_0x83\n# position: 1084, header: 5\n--- !!data #binary\n# # Unknown_0x85\n# # Unknown_0x84\n# # Unknown_0x84\n# # Unknown_0x84\n# # Unknown_0x84\n# # Unknown_0x84\n# # Unknown_0x84\n# # Unknown_0x84\n# position: 1096, header: 6\n--- !!data #binary\n# # Unknown_0x86\n# # Unknown_0x85\n# # Unknown_0x85\n# # Unknown_0x85\n# # Unknown_0x85\n# # Unknown_0x85\n# # Unknown_0x85\n# # Unknown_0x85\n# position: 1108, header: 7\n--- !!data #binary\n00000450                          87 86 86 86 86 86 86 86          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1120, header: 8\n--- !!data #binary\n00000460             88 87 87 87  87 87 87 87                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1132, header: 9\n--- !!data #binary\n00000470 89 88 88 88 88 88 88 88                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1144, header: 10\n--- !!data #binary\n\"\\x89\\x89\\x89\\x89\\x89\\x89\\x89\"\n# position: 1156, header: 11\n--- !!data #binary\n# # Unknown_0x8B\n\"\\x8A\\x8A\\x8A\\x8A\\x8A\\x8A\"\n# position: 1168, header: 12\n--- !!data #binary\n# # Unknown_0x8C\n# # Unknown_0x8B\n# # Unknown_0x8B\n# # Unknown_0x8B\n# # Unknown_0x8B\n# # Unknown_0x8B\n# # Unknown_0x8B\n# # Unknown_0x8B\n# position: 1180, header: 13\n--- !!data #binary\n000004a0 8d 8c 8c 8c 8c 8c 8c 8c                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1192, header: 14\n--- !!data #binary\n000004a0                                      8e 8d 8d 8d              \u00b7\u00b7\u00b7\u00b7\n000004b0 8d 8d 8d 8d                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1204, header: 15\n--- !!data #binary\n000004b0                          8f 8e 8e 8e 8e 8e 8e 8e          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1216, header: 16\n--- !!data #binary\n-1.4156185439721035E-29\n# position: 1228, header: 17\n--- !!data #binary\n# # FLOAT32\n-5.702071897398123E-29\n# # EndOfFile\n# position: 1240, header: 18\n--- !!data #binary\n-753555055760.82\n# position: 1252, header: 19\n--- !!data #binary\n# # FLOAT_STOP_2\n-48698841.79\n# position: 1264, header: 20\n--- !!data #binary\n-8422085917.3268\n# position: 1276, header: 21\n--- !!data #binary\n# # FLOAT_STOP_4\n-541098.2421\n# position: 1288, header: 22\n--- !!data #binary\n-93086212.770454\n# position: 1300, header: 23\n--- !!data #binary\n# # FLOAT_STOP_6\n-5952.080663\n# position: 1312, header: 24\n--- !!data #binary\n# # Unknown_0x97\n# # Unknown_0x97\n# # Unknown_0x97\n# # Unknown_0x97\n# position: 1324, header: 25\n--- !!data #binary\n# # Unknown_0x98\n# # Unknown_0x98\n# # Unknown_0x98\n# # Unknown_0x98\n# position: 1336, header: 26\n--- !!data #binary\n# # Unknown_0x99\n# # Unknown_0x99\n# # Unknown_0x99\n# # Unknown_0x99\n# position: 1348, header: 27\n--- !!data #binary\n# # FLOAT_SET_LOW_0\n# # FLOAT_SET_LOW_0\n# # FLOAT_SET_LOW_0\n# # FLOAT_SET_LOW_0\n# position: 1360, header: 28\n--- !!data #binary\n# # FLOAT_SET_LOW_2\n# # FLOAT_SET_LOW_2\n# # FLOAT_SET_LOW_2\n# # FLOAT_SET_LOW_2\n# position: 1372, header: 29\n--- !!data #binary\n# # FLOAT_SET_LOW_4\n# # FLOAT_SET_LOW_4\n# # FLOAT_SET_LOW_4\n# # FLOAT_SET_LOW_4\n# position: 1384, header: 30\n--- !!data #binary\n# # Unknown_0x9D\n# # Unknown_0x9D\n# # Unknown_0x9D\n# # Unknown_0x9D\n# position: 1396, header: 31\n--- !!data #binary\n# # Unknown_0x9E\n# # Unknown_0x9E\n# # Unknown_0x9E\n# # Unknown_0x9E\n# position: 1408, header: 32\n--- !!data #binary\n# # Unknown_0x9F\n# # Unknown_0x9F\n# # Unknown_0x9F\n# # Unknown_0x9F\n# position: 1420, header: 33\n--- !!data #binary\n!int 160\n# # UUID\n# # UUID\n# # UUID\n# position: 1432, header: 34\n--- !!data #binary\n!int 41377\n!int 161\n!int 161\n!int -1\n# position: 1444, header: 35\n--- !!data #binary\n2728567458\n!int 41634\n# position: 1456, header: 36\n--- !!data #binary\n!byte -93\n2745410467\n# # EndOfFile\n# position: 1468, header: 37\n--- !!data #binary\n!short -23388\n!byte -92\n!byte -92\n!byte 0\n# position: 1480, header: 38\n--- !!data #binary\n!int -1515870811\n!short -23131\n# position: 1492, header: 39\n--- !!data #binary\n# # INT32\n!int -1499027802\n# # EndOfFile\n# position: 1504, header: 40\n--- !!data #binary\n!int 167\n# # INT64\n# # INT64\n# # INT64\n# position: 1516, header: 41\n--- !!data #binary\n!int 43176\n!int 168\n!int 168\n!int -1\n# position: 1528, header: 42\n--- !!data #binary\n# # SET_LOW_INT16\n!int 43433\n!int 43433\n# position: 1540, header: 43\n--- !!data #binary\n# # Unknown_0xAA\n# # Unknown_0xAA\n# # Unknown_0xAA\n# # Unknown_0xAA\n# position: 1552, header: 44\n--- !!data #binary\n# # Unknown_0xAB\n# # Unknown_0xAB\n# # Unknown_0xAB\n# # Unknown_0xAB\n# position: 1564, header: 45\n--- !!data #binary\n# # Unknown_0xAC\n# # Unknown_0xAC\n# # Unknown_0xAC\n# # Unknown_0xAC\n# position: 1576, header: 46\n--- !!data #binary\n# # Unknown_0xAD\n# # Unknown_0xAD\n# # Unknown_0xAD\n# # Unknown_0xAD\n# position: 1588, header: 47\n--- !!data #binary\n# # Unknown_0xAE\n# # Unknown_0xAE\n# # Unknown_0xAE\n# # Unknown_0xAE\n# position: 1600, header: 48\n--- !!data #binary\nfalse\n# # INT64_0x\n# # INT64_0x\n# # INT64_0x\n# # EndOfFile\n# position: 1612, header: 49\n--- !!data #binary\ntrue\nfalse\nfalse\nfalse\nfalse\nfalse\nfalse\nfalse\n# position: 1624, header: 50\n--- !!data #binary\n00000650                                      b2 b1 b1 b1              \u00b7\u00b7\u00b7\u00b7\n00000660 b1 b1 b1 b1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1636, header: 51\n--- !!data #binary\n00000660                          b3 b2 b2 b2 b2 b2 b2 b2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1648, header: 52\n--- !!data #binary\n00000670             b4 b3 b3 b3  b3 b3 b3 b3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1660, header: 53\n--- !!data #binary\n00000680 b5 b4 b4 b4 b4 b4 b4 b4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1672, header: 54\n--- !!data #binary\n00000680                                      b6 b5 b5 b5              \u00b7\u00b7\u00b7\u00b7\n00000690 b5 b5 b5 b5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1684, header: 55\n--- !!data #binary\n00000690                          b7 b6 b6 b6 b6 b6 b6 b6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1696, header: 56\n--- !!data #binary\n000006a0             b8 b7 b7 b7  b7 b7 b7 b7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1708, header: 57\n--- !!data #binary\n000006b0 b9 b8 b8 b8 b8 b8 b8 b8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1720, header: 58\n--- !!data #binary\n\"-252662577519802\": \n# position: 1732, header: 59\n--- !!data #binary\n!!null \"\"\n\"-2008556674363\": \n# position: 1744, header: 60\n--- !!data #binary\n000006d0             bc bb bb bb  bb bb bb bb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1756, header: 61\n--- !!data #binary\n000006e0 bd bc bc bc bc bc bc bc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1768, header: 62\n--- !!data #binary\n000006e0                                      be bd bd bd              \u00b7\u00b7\u00b7\u00b7\n000006f0 bd bd bd bd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1780, header: 63\n--- !!data #binary\n000006f0                          bf be be be be be be be          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1792, header: 64\n--- !!data #binary\n\"\": # # HINT\n# # HINT\n# # HINT\n# # HINT\n# # HINT\n# # HINT\n# # HINT\n# position: 1804, header: 65\n--- !!data #binary\n\"\\xC0\": \"\": \"\": \"\": \"\": \"\": \"\": \n# position: 1816, header: 66\n--- !!data #binary\n00000710                                      c2 c1 c1 c1              \u00b7\u00b7\u00b7\u00b7\n00000720 c1 c1 c1 c1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1828, header: 67\n--- !!data #binary\n00000720                          c3 c2 c2 c2 c2 c2 c2 c2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1840, header: 68\n--- !!data #binary\n00000730             c4 c3 c3 c3  c3 c3 c3 c3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1852, header: 69\n--- !!data #binary\n00000740 c5 c4 c4 c4 c4 c4 c4 c4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1864, header: 70\n--- !!data #binary\n00000740                                      c6 c5 c5 c5              \u00b7\u00b7\u00b7\u00b7\n00000750 c5 c5 c5 c5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1876, header: 71\n--- !!data #binary\n\"\\xC6\\xC6\\xC6\\xC6\\xC6\\xC6\\xC6\": \n# position: 1888, header: 72\n--- !!data #binary\n00000760             c8 c7 c7 c7  c7 c7 c7 c7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1900, header: 73\n--- !!data #binary\n00000770 c9 c8 c8 c8 c8 c8 c8 c8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1912, header: 74\n--- !!data #binary\n00000770                                      ca c9 c9 c9              \u00b7\u00b7\u00b7\u00b7\n00000780 c9 c9 c9 c9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1924, header: 75\n--- !!data #binary\n00000780                          cb ca ca ca ca ca ca ca          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1936, header: 76\n--- !!data #binary\n00000790             cc cb cb cb  cb cb cb cb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1948, header: 77\n--- !!data #binary\n000007a0 cd cc cc cc cc cc cc cc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 1960, header: 78\n--- !!data #binary\n000007a0                                      ce cd cd cd              \u00b7\u00b7\u00b7\u00b7\n000007b0 cd cd cd cd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 1972, header: 79\n--- !!data #binary\n000007b0                          cf ce ce ce ce ce ce ce          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 1984, header: 80\n--- !!data #binary\n000007c0             d0 cf cf cf  cf cf cf cf                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 1996, header: 81\n--- !!data #binary\n000007d0 d1 d0 d0 d0 d0 d0 d0 d0                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2008, header: 82\n--- !!data #binary\n000007d0                                      d2 d1 d1 d1              \u00b7\u00b7\u00b7\u00b7\n000007e0 d1 d1 d1 d1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2020, header: 83\n--- !!data #binary\n000007e0                          d3 d2 d2 d2 d2 d2 d2 d2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2032, header: 84\n--- !!data #binary\n000007f0             d4 d3 d3 d3  d3 d3 d3 d3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2044, header: 85\n--- !!data #binary\n00000800 d5 d4 d4 d4 d4 d4 d4 d4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2056, header: 86\n--- !!data #binary\n00000800                                      d6 d5 d5 d5              \u00b7\u00b7\u00b7\u00b7\n00000810 d5 d5 d5 d5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2068, header: 87\n--- !!data #binary\n00000810                          d7 d6 d6 d6 d6 d6 d6 d6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2080, header: 88\n--- !!data #binary\n00000820             d8 d7 d7 d7  d7 d7 d7 d7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2092, header: 89\n--- !!data #binary\n00000830 d9 d8 d8 d8 d8 d8 d8 d8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2104, header: 90\n--- !!data #binary\n00000830                                      da d9 d9 d9              \u00b7\u00b7\u00b7\u00b7\n00000840 d9 d9 d9 d9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2116, header: 91\n--- !!data #binary\n00000840                          db da da da da da da da          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2128, header: 92\n--- !!data #binary\n00000850             dc db db db  db db db db                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2140, header: 93\n--- !!data #binary\n00000860 dd dc dc dc dc dc dc dc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2152, header: 94\n--- !!data #binary\n00000860                                      de dd dd dd              \u00b7\u00b7\u00b7\u00b7\n00000870 dd dd dd dd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2164, header: 95\n--- !!data #binary\n00000870                          df de de de de de de de          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2176, header: 96\n--- !!data #binary\n00000880             e0 df df df  df df df df                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2188, header: 97\n--- !!data #binary\n00000890 e1 e0 e0 e0 e0 e0 e0 e0                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2200, header: 98\n--- !!data #binary\n00000890                                      e2 e1 e1 e1              \u00b7\u00b7\u00b7\u00b7\n000008a0 e1 e1 e1 e1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2212, header: 99\n--- !!data #binary\n000008a0                          e3 e2 e2 e2 e2 e2 e2 e2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2224, header: 100\n--- !!data #binary\n000008b0             e4 e3 e3 e3  e3 e3 e3 e3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2236, header: 101\n--- !!data #binary\n000008c0 e5 e4 e4 e4 e4 e4 e4 e4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2248, header: 102\n--- !!data #binary\n000008c0                                      e6 e5 e5 e5              \u00b7\u00b7\u00b7\u00b7\n000008d0 e5 e5 e5 e5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2260, header: 103\n--- !!data #binary\n000008d0                          e7 e6 e6 e6 e6 e6 e6 e6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2272, header: 104\n--- !!data #binary\n000008e0             e8 e7 e7 e7  e7 e7 e7 e7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2284, header: 105\n--- !!data #binary\n000008f0 e9 e8 e8 e8 e8 e8 e8 e8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2296, header: 106\n--- !!data #binary\n000008f0                                      ea e9 e9 e9              \u00b7\u00b7\u00b7\u00b7\n00000900 e9 e9 e9 e9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2308, header: 107\n--- !!data #binary\n00000900                          eb ea ea ea ea ea ea ea          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2320, header: 108\n--- !!data #binary\n00000910             ec eb eb eb  eb eb eb eb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2332, header: 109\n--- !!data #binary\n00000920 ed ec ec ec ec ec ec ec                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2344, header: 110\n--- !!data #binary\n00000920                                      ee ed ed ed              \u00b7\u00b7\u00b7\u00b7\n00000930 ed ed ed ed                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2356, header: 111\n--- !!data #binary\n00000930                          ef ee ee ee ee ee ee ee          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2368, header: 112\n--- !!data #binary\n00000940             f0 ef ef ef  ef ef ef ef                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2380, header: 113\n--- !!data #binary\n00000950 f1 f0 f0 f0 f0 f0 f0 f0                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2392, header: 114\n--- !!data #binary\n00000950                                      f2 f1 f1 f1              \u00b7\u00b7\u00b7\u00b7\n00000960 f1 f1 f1 f1                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2404, header: 115\n--- !!data #binary\n00000960                          f3 f2 f2 f2 f2 f2 f2 f2          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2416, header: 116\n--- !!data #binary\n00000970             f4 f3 f3 f3  f3 f3 f3 f3                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2428, header: 117\n--- !!data #binary\n00000980 f5 f4 f4 f4 f4 f4 f4 f4                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2440, header: 118\n--- !!data #binary\n00000980                                      f6 f5 f5 f5              \u00b7\u00b7\u00b7\u00b7\n00000990 f5 f5 f5 f5                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2452, header: 119\n--- !!data #binary\n00000990                          f7 f6 f6 f6 f6 f6 f6 f6          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2464, header: 120\n--- !!data #binary\n000009a0             f8 f7 f7 f7  f7 f7 f7 f7                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2476, header: 121\n--- !!data #binary\n000009b0 f9 f8 f8 f8 f8 f8 f8 f8                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2488, header: 122\n--- !!data #binary\n000009b0                                      fa f9 f9 f9              \u00b7\u00b7\u00b7\u00b7\n000009c0 f9 f9 f9 f9                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2500, header: 123\n--- !!data #binary\n000009c0                          fb fa fa fa fa fa fa fa          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2512, header: 124\n--- !!data #binary\n000009d0             fc fb fb fb  fb fb fb fb                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2524, header: 125\n--- !!data #binary\n000009e0 fd fc fc fc fc fc fc fc                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2536, header: 126\n--- !!data #binary\n000009e0                                      fe fd fd fd              \u00b7\u00b7\u00b7\u00b7\n000009f0 fd fd fd fd                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2548, header: 127\n--- !!data #binary\n000009f0                          ff fe fe fe fe fe fe fe          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2560, header: 128\n--- !!data #binary\n00000a00             00 00 00 00  00 00 00 00                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2572, header: 128\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 32\n  2560,\n  2892,\n  2940,\n  2988,\n  3036,\n  3084,\n  3132,\n  3180,\n  3228,\n  3276,\n  3324,\n  3372,\n  3420,\n  3468,\n  3516,\n  3564,\n  3612,\n  3660,\n  3708,\n  3756,\n  3804,\n  3852,\n  3900,\n  3948,\n  3996,\n  4044,\n  4092,\n  4140,\n  4188,\n  4236,\n  4284,\n  4332\n]\n# position: 2856, header: 129\n--- !!data #binary\n00000b20                                      01 01 01 01              \u00b7\u00b7\u00b7\u00b7\n00000b30 01 01 01 01                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2868, header: 130\n--- !!data #binary\n00000b30                          02 02 02 02 02 02 02 02          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2880, header: 131\n--- !!data #binary\n00000b40             03 03 03 03  03 03 03 03                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2892, header: 132\n--- !!data #binary\n00000b50 04 04 04 04 04 04 04 04                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2904, header: 133\n--- !!data #binary\n00000b50                                      05 05 05 05              \u00b7\u00b7\u00b7\u00b7\n00000b60 05 05 05 05                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2916, header: 134\n--- !!data #binary\n00000b60                          06 06 06 06 06 06 06 06          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 2928, header: 135\n--- !!data #binary\n00000b70             07 07 07 07  07 07 07 07                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2940, header: 136\n--- !!data #binary\n00000b80 08 08 08 08 08 08 08 08                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 2952, header: 137\n--- !!data #binary\n00000b80                                      09 09 09 09              \u00b7\u00b7\u00b7\u00b7\n00000b90 09 09 09 09                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 2964, header: 138\n--- !!data\n\n\n\n\n\n\n\n\n# position: 2976, header: 139\n--- !!data #binary\n00000ba0             0b 0b 0b 0b  0b 0b 0b 0b                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 2988, header: 140\n--- !!data #binary\n00000bb0 0c 0c 0c 0c 0c 0c 0c 0c                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 3000, header: 141\n--- !!data #binary\n00000bb0                                      0d 0d 0d 0d              \u00b7\u00b7\u00b7\u00b7\n00000bc0 0d 0d 0d 0d                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 3012, header: 142\n--- !!data #binary\n00000bc0                          0e 0e 0e 0e 0e 0e 0e 0e          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 3024, header: 143\n--- !!data #binary\n00000bd0             0f 0f 0f 0f  0f 0f 0f 0f                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 3036, header: 144\n--- !!data #binary\n00000be0 10 10 10 10 10 10 10 10                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 3048, header: 145\n--- !!data #binary\n00000be0                                      11 11 11 11              \u00b7\u00b7\u00b7\u00b7\n00000bf0 11 11 11 11                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 3060, header: 146\n--- !!data #binary\n00000bf0                          12 12 12 12 12 12 12 12          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 3072, header: 147\n--- !!data #binary\n00000c00             13 13 13 13  13 13 13 13                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 3084, header: 148\n--- !!data #binary\n00000c10 14 14 14 14 14 14 14 14                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 3096, header: 149\n--- !!data #binary\n00000c10                                      15 15 15 15              \u00b7\u00b7\u00b7\u00b7\n00000c20 15 15 15 15                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 3108, header: 150\n--- !!data #binary\n00000c20                          16 16 16 16 16 16 16 16          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 3120, header: 151\n--- !!data #binary\n00000c30             17 17 17 17  17 17 17 17                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 3132, header: 152\n--- !!data #binary\n00000c40 18 18 18 18 18 18 18 18                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 3144, header: 153\n--- !!data #binary\n00000c40                                      19 19 19 19              \u00b7\u00b7\u00b7\u00b7\n00000c50 19 19 19 19                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 3156, header: 154\n--- !!data #binary\n00000c50                          1a 1a 1a 1a 1a 1a 1a 1a          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 3168, header: 155\n--- !!data #binary\n00000c60             1b 1b 1b 1b  1b 1b 1b 1b                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 3180, header: 156\n--- !!data #binary\n00000c70 1c 1c 1c 1c 1c 1c 1c 1c                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n# position: 3192, header: 157\n--- !!data #binary\n00000c70                                      1d 1d 1d 1d              \u00b7\u00b7\u00b7\u00b7\n00000c80 1d 1d 1d 1d                                      \u00b7\u00b7\u00b7\u00b7             \n# position: 3204, header: 158\n--- !!data #binary\n00000c80                          1e 1e 1e 1e 1e 1e 1e 1e          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n# position: 3216, header: 159\n--- !!data #binary\n00000c90             1f 1f 1f 1f  1f 1f 1f 1f                 \u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7    \n# position: 3228, header: 160\n--- !!data\n        \n# position: 3240, header: 161\n--- !!data\n!!!!!!!!\n# position: 3252, header: 162\n--- !!data\n\"\"\"\"\"\"\"\"\n# position: 3264, header: 163\n--- !!data\n########\n# position: 3276, header: 164\n--- !!data\n$$$$$$$$\n# position: 3288, header: 165\n--- !!data\n%%%%%%%%\n# position: 3300, header: 166\n--- !!data\n&&&&&&&&\n# position: 3312, header: 167\n--- !!data\n''''''''\n# position: 3324, header: 168\n--- !!data\n((((((((\n# position: 3336, header: 169\n--- !!data\n))))))))\n# position: 3348, header: 170\n--- !!data\n********\n# position: 3360, header: 171\n--- !!data\n++++++++\n# position: 3372, header: 172\n--- !!data\n,,,,,,,,\n# position: 3384, header: 173\n--- !!data\n--------\n# position: 3396, header: 174\n--- !!data\n........\n# position: 3408, header: 175\n--- !!data\n////////\n# position: 3420, header: 176\n--- !!data\n00000000\n# position: 3432, header: 177\n--- !!data\n11111111\n# position: 3444, header: 178\n--- !!data\n22222222\n# position: 3456, header: 179\n--- !!data\n33333333\n# position: 3468, header: 180\n--- !!data\n44444444\n# position: 3480, header: 181\n--- !!data\n55555555\n# position: 3492, header: 182\n--- !!data\n66666666\n# position: 3504, header: 183\n--- !!data\n77777777\n# position: 3516, header: 184\n--- !!data\n88888888\n# position: 3528, header: 185\n--- !!data\n99999999\n# position: 3540, header: 186\n--- !!data\n::::::::\n# position: 3552, header: 187\n--- !!data\n;;;;;;;;\n# position: 3564, header: 188\n--- !!data\n<<<<<<<<\n# position: 3576, header: 189\n--- !!data\n========\n# position: 3588, header: 190\n--- !!data\n>>>>>>>>\n# position: 3600, header: 191\n--- !!data\n????????\n# position: 3612, header: 192\n--- !!data\n@@@@@@@@\n# position: 3624, header: 193\n--- !!data\nAAAAAAAA\n# position: 3636, header: 194\n--- !!data\nBBBBBBBB\n# position: 3648, header: 195\n--- !!data\nCCCCCCCC\n# position: 3660, header: 196\n--- !!data\nDDDDDDDD\n# position: 3672, header: 197\n--- !!data\nEEEEEEEE\n# position: 3684, header: 198\n--- !!data\nFFFFFFFF\n# position: 3696, header: 199\n--- !!data\nGGGGGGGG\n# position: 3708, header: 200\n--- !!data\nHHHHHHHH\n# position: 3720, header: 201\n--- !!data\nIIIIIIII\n# position: 3732, header: 202\n--- !!data\nJJJJJJJJ\n# position: 3744, header: 203\n--- !!data\nKKKKKKKK\n# position: 3756, header: 204\n--- !!data\nLLLLLLLL\n# position: 3768, header: 205\n--- !!data\nMMMMMMMM\n# position: 3780, header: 206\n--- !!data\nNNNNNNNN\n# position: 3792, header: 207\n--- !!data\nOOOOOOOO\n# position: 3804, header: 208\n--- !!data\nPPPPPPPP\n# position: 3816, header: 209\n--- !!data\nQQQQQQQQ\n# position: 3828, header: 210\n--- !!data\nRRRRRRRR\n# position: 3840, header: 211\n--- !!data\nSSSSSSSS\n# position: 3852, header: 212\n--- !!data\nTTTTTTTT\n# position: 3864, header: 213\n--- !!data\nUUUUUUUU\n# position: 3876, header: 214\n--- !!data\nVVVVVVVV\n# position: 3888, header: 215\n--- !!data\nWWWWWWWW\n# position: 3900, header: 216\n--- !!data\nXXXXXXXX\n# position: 3912, header: 217\n--- !!data\nYYYYYYYY\n# position: 3924, header: 218\n--- !!data\nZZZZZZZZ\n# position: 3936, header: 219\n--- !!data\n[[[[[[[[\n# position: 3948, header: 220\n--- !!data\n\\\\\\\\\\\\\\\\\n# position: 3960, header: 221\n--- !!data\n]]]]]]]]\n# position: 3972, header: 222\n--- !!data\n^^^^^^^^\n# position: 3984, header: 223\n--- !!data\n________\n# position: 3996, header: 224\n--- !!data\n````````\n# position: 4008, header: 225\n--- !!data\naaaaaaaa\n# position: 4020, header: 226\n--- !!data\nbbbbbbbb\n# position: 4032, header: 227\n--- !!data\ncccccccc\n# position: 4044, header: 228\n--- !!data\ndddddddd\n# position: 4056, header: 229\n--- !!data\neeeeeeee\n# position: 4068, header: 230\n--- !!data\nffffffff\n# position: 4080, header: 231\n--- !!data\ngggggggg\n# position: 4092, header: 232\n--- !!data\nhhhhhhhh\n# position: 4104, header: 233\n--- !!data\niiiiiiii\n# position: 4116, header: 234\n--- !!data\njjjjjjjj\n# position: 4128, header: 235\n--- !!data\nkkkkkkkk\n# position: 4140, header: 236\n--- !!data\nllllllll\n# position: 4152, header: 237\n--- !!data\nmmmmmmmm\n# position: 4164, header: 238\n--- !!data\nnnnnnnnn\n# position: 4176, header: 239\n--- !!data\noooooooo\n# position: 4188, header: 240\n--- !!data\npppppppp\n# position: 4200, header: 241\n--- !!data\nqqqqqqqq\n# position: 4212, header: 242\n--- !!data\nrrrrrrrr\n# position: 4224, header: 243\n--- !!data\nssssssss\n# position: 4236, header: 244\n--- !!data\ntttttttt\n# position: 4248, header: 245\n--- !!data\nuuuuuuuu\n# position: 4260, header: 246\n--- !!data\nvvvvvvvv\n# position: 4272, header: 247\n--- !!data\nwwwwwwww\n# position: 4284, header: 248\n--- !!data\nxxxxxxxx\n# position: 4296, header: 249\n--- !!data\nyyyyyyyy\n# position: 4308, header: 250\n--- !!data\nzzzzzzzz\n# position: 4320, header: 251\n--- !!data\n{{{{{{{{\n# position: 4332, header: 252\n--- !!data\n||||||||\n# position: 4344, header: 253\n--- !!data\n}}}}}}}}\n# position: 4356, header: 254\n--- !!data\n~~~~~~~~\n# position: 4368, header: 255\n--- !!data\n\u007f\u007f\u007f\u007f\u007f\u007f\u007f\u007f\n...\n# 126688 bytes remaining\n", (Object)queue.dump());
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)dir, (int)2);
            }
            catch (IORuntimeException iORuntimeException) {}
        }
    }

    public boolean postOneMessage(@NotNull ExcerptAppender appender) {
        appender.writeBytes(this.outgoingBytes);
        return true;
    }

    public int fetchOneMessage(@NotNull ExcerptTailer tailer, @NotNull byte[] using) {
        try (DocumentContext dc = tailer.readingDocument();){
            int n = !dc.isPresent() ? -1 : dc.wire().bytes().read(using);
            return n;
        }
    }

    @After
    public void checkRegisteredBytes() {
        this.outgoingBytes.release();
        BytesUtil.checkRegisteredBytes();
    }
}

