/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueBuilder<S extends SingleChronicleQueueBuilder>
extends AbstractChronicleQueueBuilder<SingleChronicleQueueBuilder<S>> {
    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull String path) {
        this(new File(path));
    }

    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull File path) {
        super(path);
        this.storeFactory(SingleChronicleQueueBuilder::createStore);
    }

    public static void init() {
    }

    @NotNull
    public static <S extends SingleChronicleQueueBuilder<S>> SingleChronicleQueueBuilder<S> builder(@NotNull Path path, WireType wireType) {
        return SingleChronicleQueueBuilder.builder(path.toFile(), wireType);
    }

    @NotNull
    public static SingleChronicleQueueBuilder builder(@NotNull File file, WireType wireType) {
        return new SingleChronicleQueueBuilder(file).wireType(wireType);
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull Path path) {
        return SingleChronicleQueueBuilder.binary(path.toFile());
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.binary(new File(basePath));
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.BINARY_LIGHT);
    }

    @NotNull
    public static SingleChronicleQueueBuilder fieldlessBinary(@NotNull File name) {
        return SingleChronicleQueueBuilder.builder(name, WireType.FIELDLESS_BINARY);
    }

    @NotNull
    public static SingleChronicleQueueBuilder defaultZeroBinary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.DEFAULT_ZERO_BINARY);
    }

    @Deprecated
    @NotNull
    public static SingleChronicleQueueBuilder text(@NotNull File name) {
        return SingleChronicleQueueBuilder.builder(name, WireType.TEXT);
    }

    @NotNull
    static SingleChronicleQueueStore createStore(RollingChronicleQueue queue, Wire wire) {
        SingleChronicleQueueStore wireStore = new SingleChronicleQueueStore(queue.rollCycle(), queue.wireType(), (MappedBytes)wire.bytes(), queue.epoch(), queue.indexCount(), queue.indexSpacing(), queue.recoverySupplier().apply(queue.wireType()), queue.deltaCheckpointInterval());
        wire.writeEventName((WireKey)MetaDataKeys.header).typedMarshallable((WriteMarshallable)wireStore);
        return wireStore;
    }

    @Override
    @NotNull
    public SingleChronicleQueue build() {
        if (this.buffered()) {
            this.onlyAvailableInEnterprise();
        }
        return new SingleChronicleQueue(this);
    }

    private void onlyAvailableInEnterprise() {
        this.getLogger().warn("Buffering is only supported in Chronicle Queue Enterprise");
    }

    @NotNull
    public SingleChronicleQueueBuilder<S> clone() {
        try {
            SingleChronicleQueueBuilder clone = (SingleChronicleQueueBuilder)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier() {
        return null;
    }

    public Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier() {
        return null;
    }

    public SingleChronicleQueueBuilder aesEncryption(@Nullable byte[] keyBytes) {
        if (keyBytes == null) {
            this.codingSuppliers(null, null);
            return this;
        }
        this.onlyAvailableInEnterprise();
        return this;
    }

    public SingleChronicleQueueBuilder codingSuppliers(@Nullable Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier, @Nullable Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier) {
        if (encodingSupplier != null || decodingSupplier != null) {
            this.onlyAvailableInEnterprise();
        }
        return this;
    }

    @Override
    public SingleChronicleQueueBuilder<S> testBlockSize() {
        super.testBlockSize();
        return this;
    }

    @Override
    public SingleChronicleQueueBuilder<S> sourceId(int sourceId) {
        return (SingleChronicleQueueBuilder)super.sourceId(sourceId);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> blockSize(int blockSize) {
        return (SingleChronicleQueueBuilder)super.blockSize(blockSize);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> wireType(@NotNull WireType wireType) {
        return (SingleChronicleQueueBuilder)super.wireType(wireType);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> rollCycle(@NotNull RollCycle rollCycle) {
        return (SingleChronicleQueueBuilder)super.rollCycle(rollCycle);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> bufferCapacity(long bufferCapacity) {
        return (SingleChronicleQueueBuilder)super.bufferCapacity(bufferCapacity);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> epoch(long epoch) {
        return (SingleChronicleQueueBuilder)super.epoch(epoch);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> buffered(boolean isBuffered) {
        return (SingleChronicleQueueBuilder)super.buffered(isBuffered);
    }

    @Override
    public SingleChronicleQueueBuilder<S> writeBufferMode(BufferMode writeBufferMode) {
        return (SingleChronicleQueueBuilder)super.writeBufferMode(writeBufferMode);
    }

    @Override
    public SingleChronicleQueueBuilder<S> readBufferMode(BufferMode readBufferMode) {
        return (SingleChronicleQueueBuilder)super.readBufferMode(readBufferMode);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> eventLoop(EventLoop eventLoop) {
        return (SingleChronicleQueueBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public SingleChronicleQueueBuilder<S> indexCount(int indexCount) {
        return (SingleChronicleQueueBuilder)super.indexCount(indexCount);
    }

    @Override
    public SingleChronicleQueueBuilder<S> indexSpacing(int indexSpacing) {
        return (SingleChronicleQueueBuilder)super.indexSpacing(indexSpacing);
    }

    @Override
    public SingleChronicleQueueBuilder<S> timeProvider(TimeProvider timeProvider) {
        return (SingleChronicleQueueBuilder)super.timeProvider(timeProvider);
    }

    @Override
    public SingleChronicleQueueBuilder<S> pauserSupplier(Supplier<Pauser> pauser) {
        return (SingleChronicleQueueBuilder)super.pauserSupplier(pauser);
    }

    @Override
    public SingleChronicleQueueBuilder<S> timeoutMS(long timeoutMS) {
        return (SingleChronicleQueueBuilder)super.timeoutMS(timeoutMS);
    }

    @Override
    public SingleChronicleQueueBuilder<S> readOnly(boolean readOnly) {
        return (SingleChronicleQueueBuilder)super.readOnly(readOnly);
    }

    @Override
    public SingleChronicleQueueBuilder<S> storeFileListener(StoreFileListener storeFileListener) {
        return (SingleChronicleQueueBuilder)super.storeFileListener(storeFileListener);
    }

    @Override
    public SingleChronicleQueueBuilder<S> recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        return (SingleChronicleQueueBuilder)super.recoverySupplier(recoverySupplier);
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{WireType.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "SCQSRoll");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class, "SCQSIndexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "SCQStore");
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{TimedStoreRecovery.class});
    }
}

