/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.core.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static File tempDir(String name) {
        File tmpDir = new File(OS.TARGET, name + "-" + System.nanoTime());
        DeleteStatic.INSTANCE.add(tmpDir);
        if (OS.isMacOSX()) {
            LOGGER.info("Tmp dir: {}", (Object)tmpDir);
        }
        return tmpDir;
    }

    static void deleteDir(File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Utils.deleteDir(file);
                    continue;
                }
                if (file.delete()) continue;
                LOGGER.info("... unable to delete {}", (Object)file);
            }
        }
        dir.delete();
    }

    static enum DeleteStatic {
        INSTANCE;

        final Set<File> toDeleteList = Collections.synchronizedSet(new LinkedHashSet());

        private DeleteStatic() {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.toDeleteList.forEach(Utils::deleteDir)));
        }

        synchronized void add(File path) {
            this.toDeleteList.add(path);
        }
    }
}

