/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SingleChronicleQueueTest
extends ChronicleQueueTestBase {
    private static final long TIMES = 0x400000L;
    protected final WireType wireType;
    protected final boolean encryption;
    private ThreadDump threadDump;
    private Map<ExceptionKey, Integer> exceptionKeyIntegerMap;

    public SingleChronicleQueueTest(@NotNull WireType wireType, boolean encryption) {
        this.wireType = wireType;
        this.encryption = encryption;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({WireType.BINARY, false}, {WireType.BINARY, true}, {WireType.BINARY_LIGHT, false}, {WireType.BINARY_LIGHT, true});
    }

    @Before
    public void before() {
        this.threadDump = new ThreadDump();
        this.exceptionKeyIntegerMap = Jvm.recordExceptions();
    }

    @After
    public void after() {
        this.threadDump.assertNoNewThreads();
        Jvm.dumpException(this.exceptionKeyIntegerMap);
        Assert.assertTrue((boolean)this.exceptionKeyIntegerMap.isEmpty());
        Jvm.resetExceptionHandlers();
    }

    @Test
    public void testAppend() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int i = 0;
            while (i < 10) {
                int n = i++;
                appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(n));
                Assert.assertEquals((long)n, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
            }
        }
    }

    @Test
    public void testWriteWithDocumentReadBytesDifferentThreads() throws InterruptedException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            String expected = "some long message";
            ExecutorService service1 = Executors.newSingleThreadExecutor();
            service1.submit(() -> SingleChronicleQueueTest.lambda$testWriteWithDocumentReadBytesDifferentThreads$2((ChronicleQueue)queue));
            ArrayBlockingQueue result = new ArrayBlockingQueue(10);
            ScheduledExecutorService service2 = Executors.newSingleThreadScheduledExecutor();
            service2.scheduleAtFixedRate(() -> SingleChronicleQueueTest.lambda$testWriteWithDocumentReadBytesDifferentThreads$3((ChronicleQueue)queue, result), 1L, 1L, TimeUnit.MICROSECONDS);
            Bytes poll = (Bytes)result.poll(10L, TimeUnit.SECONDS);
            String actual = ((Wire)this.wireType.apply((Object)poll)).read(() -> "key").text();
            Assert.assertEquals((Object)"some long message", (Object)actual);
            service1.shutdown();
            service2.shutdown();
        }
    }

    @Test
    public void testReadingLessBytesThanWritten() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = queue.acquireAppender();
            Bytes expected = Bytes.wrapForRead((byte[])"some long message".getBytes(StandardCharsets.ISO_8859_1));
            for (int i = 0; i < 10; ++i) {
                appender.writeBytes(expected);
            }
            ExcerptTailer tailer = queue.createTailer();
            for (int i = 0; i < 10; ++i) {
                VanillaBytes b = Bytes.allocateDirect((long)8L);
                tailer.readBytes((Bytes)b);
                Assert.assertEquals((long)expected.readInt(0L), (long)b.readInt(0L));
            }
        }
    }

    @Test
    public void testAppendAndRead() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            int n;
            ExcerptAppender appender = queue.acquireAppender();
            int cycle = appender.cycle();
            int i = 0;
            while (i < 10) {
                int n2 = i++;
                appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(n2));
                Assert.assertEquals((long)n2, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
            }
            ExcerptTailer tailer = queue.createTailer();
            int i2 = 0;
            while (i2 < 10) {
                n = i2++;
                Assert.assertTrue((boolean)tailer.readDocument(r -> Assert.assertEquals((long)n, (long)r.read((WireKey)ChronicleQueueTestBase.TestKey.test).int32())));
                Assert.assertEquals((long)(n + 1), (long)queue.rollCycle().toSequenceNumber(tailer.index()));
            }
            i2 = 0;
            while (i2 < 10) {
                n = i2++;
                Assert.assertTrue((String)("n: " + n), (boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, (long)n)));
                Assert.assertTrue((String)("n: " + n), (boolean)tailer.readDocument(r -> Assert.assertEquals((long)n, (long)r.read((WireKey)ChronicleQueueTestBase.TestKey.test).int32())));
                Assert.assertEquals((long)(n + 1), (long)queue.rollCycle().toSequenceNumber(tailer.index()));
            }
        }
    }

    @Test
    public void testReadAndAppend() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            int[] results = new int[2];
            Thread t = new Thread(() -> SingleChronicleQueueTest.lambda$testReadAndAppend$9((ChronicleQueue)queue, results));
            t.setDaemon(true);
            t.start();
            Jvm.pause((long)500L);
            ExcerptAppender appender = queue.acquireAppender();
            int i = 0;
            while (i < 2) {
                int n = i++;
                appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(n));
            }
            Jvm.pause((long)500L);
            Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])results);
        }
    }

    @Test
    public void testCheckIndexWithWritingDocument() {
        this.doTestCheckIndex((appender, n) -> {
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().writeEventName((CharSequence)"").object((Object)("" + n));
            }
        });
    }

    @Test
    public void testCheckIndexWithWritingDocument2() {
        this.doTestCheckIndex((appender, n) -> {
            try (DocumentContext dc = appender.writingDocument();){
                ((Bytes)((Bytes)((Bytes)dc.wire().bytes().writeUtf8("Hello")).writeStopBit(12345L)).writeStopBit(1.2)).writeInt(1);
            }
        });
    }

    @Test
    public void testCheckIndexWithWriteBytes() {
        this.doTestCheckIndex((appender, n) -> appender.writeBytes(Bytes.from((CharSequence)("Message-" + n))));
    }

    @Test
    public void testCheckIndexWithWriteBytes2() {
        this.doTestCheckIndex((appender, n) -> appender.writeBytes(b -> b.append8bit("Message-").append((long)n.intValue())));
    }

    @Test
    public void testCheckIndexWithWriteBytes3() {
        this.doTestCheckIndex((appender, n) -> appender.writeBytes(b -> b.writeUtf8("Hello").writeStopBit(12345L).writeStopBit(1.2).writeInt(1)));
    }

    @Test
    public void testCheckIndexWithWriteMap() {
        this.doTestCheckIndex((appender, n) -> appender.writeMap((Map)new HashMap<String, String>(){
            {
                this.put("key", "Message-" + n);
            }
        }));
    }

    @Test
    public void testCheckIndexWithWriteText() {
        this.doTestCheckIndex((appender, n) -> appender.writeText((CharSequence)("Message-" + n)));
    }

    void doTestCheckIndex(BiConsumer<ExcerptAppender, Integer> writeTo) {
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(System.currentTimeMillis() - 259200000L);
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).timeProvider((TimeProvider)stp).build();){
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer tailer = queue.createTailer();
            int cycle = appender.cycle();
            for (int i = 0; i <= 5; ++i) {
                int n = i;
                writeTo.accept(appender, n);
                try (DocumentContext dc = tailer.readingDocument();){
                    long index = tailer.index();
                    System.out.println(i + " index: " + Long.toHexString(index));
                    Assert.assertEquals((long)(cycle + i), (long)RollCycles.DAILY.toCycle(index));
                }
                stp.currentTimeMillis(stp.currentTimeMillis() + 86400000L);
            }
        }
    }

    @Test
    public void testAppendAndReadWithRollingB() {
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(System.currentTimeMillis() - 259200000L);
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST_DAILY).timeProvider((TimeProvider)stp).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(0));
            appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test2).int32(1000));
            int cycle = appender.cycle();
            for (int i = 1; i <= 5; ++i) {
                stp.currentTimeMillis(stp.currentTimeMillis() + 86400000L);
                int n = i;
                appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(n));
                Assert.assertEquals((long)(cycle + i), (long)appender.cycle());
                appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test2).int32(n + 1000));
                Assert.assertEquals((long)(cycle + i), (long)appender.cycle());
            }
            Assert.assertEquals((Object)this.expectedAppendAndReadWithRolling(), (Object)queue.dump());
            Assume.assumeFalse((boolean)this.encryption);
            Assume.assumeFalse((this.wireType == WireType.DEFAULT_ZERO_BINARY ? 1 : 0) != 0);
            ExcerptTailer tailer = queue.createTailer().toStart();
            for (int i = 0; i < 6; ++i) {
                int n = i;
                boolean condition = tailer.readDocument(r -> Assert.assertEquals((long)n, (long)r.read((WireKey)ChronicleQueueTestBase.TestKey.test).int32()));
                Assert.assertTrue((String)("i : " + i), (boolean)condition);
                Assert.assertEquals((long)(cycle + i), (long)tailer.cycle());
                boolean condition2 = tailer.readDocument(r -> Assert.assertEquals((long)(n + 1000), (long)r.read((WireKey)ChronicleQueueTestBase.TestKey.test2).int32()));
                Assert.assertTrue((String)("i2 : " + i), (boolean)condition2);
                Assert.assertEquals((long)(cycle + i), (long)tailer.cycle());
            }
        }
    }

    @NotNull
    protected String expectedAppendAndReadWithRolling() {
        if (this.wireType == WireType.BINARY) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 0\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1000\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 1\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1001\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 2\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1002\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 3\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1003\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 4\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1004\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 5\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1005\n...\n# 327085 bytes remaining\n";
        }
        if (this.wireType == WireType.BINARY_LIGHT) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 586,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  586,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\ntest: 0\n# position: 586, header: 1\n--- !!data #binary\ntest2: !short 1000\n# position: 599, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327077 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 586,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  586,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\ntest: 1\n# position: 586, header: 1\n--- !!data #binary\ntest2: !short 1001\n# position: 599, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327077 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 586,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  586,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\ntest: 2\n# position: 586, header: 1\n--- !!data #binary\ntest2: !short 1002\n# position: 599, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327077 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 586,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  586,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\ntest: 3\n# position: 586, header: 1\n--- !!data #binary\ntest2: !short 1003\n# position: 599, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327077 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 586,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  586,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\ntest: 4\n# position: 586, header: 1\n--- !!data #binary\ntest2: !short 1004\n# position: 599, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327077 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 586,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  586,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\ntest: 5\n# position: 586, header: 1\n--- !!data #binary\ntest2: !short 1005\n...\n# 327077 bytes remaining\n";
        }
        throw new IllegalStateException("unsupported wire-type=" + this.wireType);
    }

    @Test
    public void testAppendAndReadAtIndex() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int n = i;
                appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(n));
                Assert.assertEquals((long)i, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
            }
            ExcerptTailer tailer = queue.createTailer();
            int i = 0;
            while (i < 5) {
                long index = queue.rollCycle().toIndex(appender.cycle(), (long)i);
                Assert.assertTrue((boolean)tailer.moveToIndex(index));
                int n = i++;
                Assert.assertTrue((boolean)tailer.readDocument(arg_0 -> SingleChronicleQueueTest.lambda$testAppendAndReadAtIndex$27(n, (RollingChronicleQueue)queue, arg_0)));
                long index2 = tailer.index();
                long sequenceNumber = queue.rollCycle().toSequenceNumber(index2);
                Assert.assertEquals((long)(n + 1), (long)sequenceNumber);
            }
        }
    }

    @Test
    public void testSimpleWire() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            appender.writeDocument(wire -> wire.write(() -> "FirstName").text("Steve"));
            appender.writeDocument(wire -> wire.write(() -> "Surname").text("Jobs"));
            StringBuilder first = new StringBuilder();
            StringBuilder surname = new StringBuilder();
            ExcerptTailer tailer = chronicle.createTailer();
            tailer.readDocument(wire -> wire.read(() -> "FirstName").text(first));
            tailer.readDocument(wire -> wire.read(() -> "Surname").text(surname));
            Assert.assertEquals((Object)"Steve Jobs", (Object)(first + " " + surname));
        }
    }

    @Test
    public void testIndexWritingDocument() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            long index;
            ExcerptAppender appender = chronicle.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write(() -> "FirstName").text("Quartilla");
                index = dc.index();
            }
            dc = appender.writingDocument(true);
            var7_7 = null;
            try {
                dc.wire().write(() -> "FirstName").text("Quartilla");
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_7 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertEquals((long)index, (long)appender.lastIndexAppended());
        }
    }

    @Test
    public void testReadingWritingMarshallableDocument() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            MyMarshable myMarshable = new MyMarshable();
            ExcerptAppender appender = chronicle.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"myMarshable").typedMarshallable((WriteMarshallable)myMarshable);
            }
            ExcerptTailer tailer = chronicle.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertEquals((Object)((Object)myMarshable), (Object)dc.wire().read(() -> "myMarshable").typedMarshallable());
            }
        }
    }

    @Test
    public void testMetaData() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            ValueIn in2;
            Throwable throwable;
            DocumentContext dc;
            ExcerptAppender appender = chronicle.acquireAppender();
            try (DocumentContext dc2 = appender.writingDocument(true);){
                dc2.wire().write(() -> "FirstName").text("Quartilla");
            }
            dc2 = appender.writingDocument();
            var5_7 = null;
            try {
                dc2.wire().write(() -> "FirstName").text("Rob");
            }
            catch (Throwable throwable2) {
                var5_7 = throwable2;
                throw throwable2;
            }
            finally {
                if (dc2 != null) {
                    if (var5_7 != null) {
                        try {
                            dc2.close();
                        }
                        catch (Throwable throwable3) {
                            var5_7.addSuppressed(throwable3);
                        }
                    } else {
                        dc2.close();
                    }
                }
            }
            dc2 = appender.writingDocument(true);
            var5_7 = null;
            try {
                dc2.wire().write(() -> "FirstName").text("Steve");
            }
            catch (Throwable throwable4) {
                var5_7 = throwable4;
                throw throwable4;
            }
            finally {
                if (dc2 != null) {
                    if (var5_7 != null) {
                        try {
                            dc2.close();
                        }
                        catch (Throwable throwable5) {
                            var5_7.addSuppressed(throwable5);
                        }
                    } else {
                        dc2.close();
                    }
                }
            }
            ExcerptTailer tailer = chronicle.createTailer();
            StringBuilder event = new StringBuilder();
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    in2 = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in2.text((Object)"Quartilla", Assert::assertEquals);
                }
                catch (Throwable in2) {
                    throwable = in2;
                    throw in2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            dc = tailer.readingDocument(true);
            throwable = null;
            try {
                Assert.assertTrue((boolean)dc.isData());
                dc.wire().read(() -> "FirstName").text((Object)"Rob", Assert::assertEquals);
            }
            catch (Throwable in2) {
                throwable = in2;
                throw in2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable in2) {
                            throwable.addSuppressed(in2);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    in2 = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in2.text((Object)"Steve", Assert::assertEquals);
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testReadingSecondDocumentNotExist() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write(() -> "FirstName").text("Quartilla");
            }
            ExcerptTailer tailer = chronicle.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                String text = dc.wire().read(() -> "FirstName").text();
                Assert.assertEquals((Object)"Quartilla", (Object)text);
            }
            dc = tailer.readingDocument();
            var6_10 = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_10 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDocumentIndexTest() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                long index = dc.index();
                Assert.assertEquals((long)0L, (long)chronicle.rollCycle().toSequenceNumber(index));
                dc.wire().write(() -> "FirstName").text("Quartilla");
            }
            dc = appender.writingDocument();
            var5_7 = null;
            try {
                Assert.assertEquals((long)1L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
                dc.wire().write(() -> "FirstName").text("Rob");
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var5_7 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = appender.writingDocument();
            var5_7 = null;
            try {
                Assert.assertEquals((long)2L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
                dc.wire().write(() -> "FirstName").text("Rob");
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var5_7 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            ExcerptTailer tailer = chronicle.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                long index = dc.index();
                Assert.assertEquals((long)0L, (long)chronicle.rollCycle().toSequenceNumber(index));
            }
            dc = tailer.readingDocument();
            var6_15 = null;
            try {
                Assert.assertEquals((long)1L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
            }
            catch (Throwable throwable) {
                var6_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var6_15 = null;
            try {
                Assert.assertEquals((long)2L, (long)chronicle.rollCycle().toSequenceNumber(dc.index()));
            }
            catch (Throwable throwable) {
                var6_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReadingSecondDocumentNotExistIncludingMeta() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            Throwable throwable;
            DocumentContext dc;
            ExcerptAppender appender = chronicle.acquireAppender();
            try (DocumentContext dc2 = appender.writingDocument();){
                dc2.wire().write(() -> "FirstName").text("Quartilla");
            }
            ExcerptTailer tailer = chronicle.createTailer();
            StringBuilder event = new StringBuilder();
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    ValueIn in = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in.text((Object)"Quartilla", Assert::assertEquals);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testSimpleByteTest() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            Bytes steve = Bytes.allocateDirect((byte[])"Steve".getBytes());
            appender.writeBytes(steve);
            Bytes jobs = Bytes.allocateDirect((byte[])"Jobs".getBytes());
            appender.writeBytes(jobs);
            ExcerptTailer tailer = chronicle.createTailer();
            Bytes bytes = Bytes.elasticByteBuffer();
            tailer.readBytes(bytes);
            Assert.assertEquals((Object)"Steve", (Object)bytes.toString());
            tailer.readBytes(bytes);
            Assert.assertEquals((Object)"Jobs", (Object)bytes.toString());
        }
    }

    @Test
    public void testReadAtIndex() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).indexCount(8).indexSpacing(8).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int i = 0;
            while (i < 100) {
                int j = i++;
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=" + j));
            }
            long lastIndex = appender.lastIndexAppended();
            int cycle = queue.rollCycle().toCycle(lastIndex);
            Assert.assertEquals((long)queue.firstCycle(), (long)cycle);
            Assert.assertEquals((long)queue.lastCycle(), (long)cycle);
            ExcerptTailer tailer = queue.createTailer();
            System.out.println(queue.dump());
            StringBuilder sb = new StringBuilder();
            for (int i2 : new int[]{0, 8, 7, 9, 64, 65, 66}) {
                Assert.assertTrue((String)("i: " + i2), (boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, (long)i2)));
                tailer.readDocument(wire -> wire.read(() -> "key").text(sb));
                Assert.assertEquals((Object)("value=" + i2), (Object)sb.toString());
            }
        }
    }

    @Ignore(value="long running test")
    @Test
    public void testReadAtIndex4MB() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = queue.acquireAppender();
            System.out.print("Percent written=");
            for (long i = 0L; i < 0x400000L; ++i) {
                long j = i;
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=" + j));
                if (i % 209715L != 0L) continue;
                System.out.println("" + i * 100L / 0x400000L + "%, ");
            }
            long lastIndex = appender.lastIndexAppended();
            int cycle = queue.rollCycle().toCycle(lastIndex);
            ExcerptTailer tailer = queue.createTailer();
            StringBuilder sb = new StringBuilder();
            for (long i = 0L; i < 0x400000L; ++i) {
                Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, i)));
                tailer.readDocument(wire -> wire.read(() -> "key").text(sb));
                Assert.assertEquals((Object)("value=" + i), (Object)sb.toString());
                if (i % 209715L != 0L) continue;
                System.out.println("Percent read= " + i * 100L / 0x400000L + "%");
            }
        }
    }

    @Test
    public void testLastWrittenIndexPerAppender() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument(wire -> wire.write(() -> "key").text("test"));
            Assert.assertEquals((long)0L, (long)queue.rollCycle().toSequenceNumber(appender.lastIndexAppended()));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testLastWrittenIndexPerAppenderNoData() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            appender.lastIndexAppended();
            Assert.fail();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testNoMessagesWritten() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            appender.lastIndexAppended();
        }
    }

    @Test
    public void testHeaderIndexReadAtIndex() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int cycle = appender.cycle();
            int i = 0;
            while (i < 100) {
                int j = i++;
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=" + j));
            }
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 0L)));
            StringBuilder sb = new StringBuilder();
            tailer.readDocument(wire -> wire.read(() -> "key").text(sb));
            Assert.assertEquals((Object)"value=0", (Object)sb.toString());
        }
    }

    @Test
    public void testEPOC() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).epoch(System.currentTimeMillis()).rollCycle((RollCycle)RollCycles.HOURLY).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            appender.writeDocument(wire -> wire.write(() -> "key").text("value=v"));
            Assert.assertTrue((appender.cycle() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNegativeEPOC() {
        for (int h = -14; h <= 14; ++h) {
            try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).epoch(TimeUnit.HOURS.toMillis(h)).build();){
                ExcerptAppender appender = chronicle.acquireAppender();
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=v"));
                chronicle.createTailer().readDocument(wire -> Assert.assertEquals((Object)"value=v", (Object)wire.read("key").text()));
                continue;
            }
        }
    }

    @Test
    public void testIndex() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int cycle = appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int j = i;
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=" + j));
                if (i != 2) continue;
                long cycle1 = queue.rollCycle().toCycle(appender.lastIndexAppended());
                Assert.assertEquals((long)cycle1, (long)cycle);
            }
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 2L)));
            StringBuilder sb = new StringBuilder();
            tailer.readDocument(wire -> wire.read(() -> "key").text(sb));
            Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            tailer.readDocument(wire -> wire.read(() -> "key").text(sb));
            Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            tailer.readDocument(wire -> wire.read(() -> "key").text(sb));
            Assert.assertEquals((Object)"value=4", (Object)sb.toString());
        }
    }

    @Test
    public void testReadingDocument() {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            long cycle = appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int j = i;
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=" + j));
                if (i != 2) continue;
                long cycle1 = queue.rollCycle().toCycle(appender.lastIndexAppended());
                Assert.assertEquals((long)cycle1, (long)cycle);
            }
            ExcerptTailer tailer = queue.createTailer();
            StringBuilder sb = Wires.acquireStringBuilder();
            try (DocumentContext dc = tailer.readingDocument();){
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=0", (Object)sb.toString());
            }
            dc = tailer.readingDocument();
            var9_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=1", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var9_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var9_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var9_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=4", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var9_13 = null;
            try {
                assert (!dc.isPresent());
                assert (!dc.isData());
                assert (!dc.isMetaData());
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReadingDocumentWithFirstAMove() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int cycle = appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int j = i;
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=" + j));
                if (i != 2) continue;
                long cycle1 = queue.rollCycle().toCycle(appender.lastIndexAppended());
                Assert.assertEquals((long)cycle1, (long)cycle);
            }
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 2L)));
            StringBuilder sb = Wires.acquireStringBuilder();
            try (DocumentContext dc = tailer.readingDocument();){
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            }
            dc = tailer.readingDocument();
            var8_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var8_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=4", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var8_13 = null;
            try {
                assert (!dc.isPresent());
                assert (!dc.isData());
                assert (!dc.isMetaData());
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReadingDocumentWithFirstAMoveWithEpoch() throws TimeoutException {
        try (SingleChronicleQueue queue = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).epoch(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int cycle = appender.cycle();
            for (int i = 0; i < 5; ++i) {
                int j = i;
                appender.writeDocument(wire -> wire.write(() -> "key").text("value=" + j));
                if (i != 2) continue;
                long cycle1 = queue.rollCycle().toCycle(appender.lastIndexAppended());
                Assert.assertEquals((long)cycle1, (long)cycle);
            }
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertTrue((boolean)tailer.moveToIndex(queue.rollCycle().toIndex(cycle, 2L)));
            StringBuilder sb = Wires.acquireStringBuilder();
            try (DocumentContext dc = tailer.readingDocument();){
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=2", (Object)sb.toString());
            }
            dc = tailer.readingDocument();
            var8_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=3", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var8_13 = null;
            try {
                assert (dc.isPresent());
                assert (dc.isData());
                dc.wire().read(() -> "key").text(sb);
                Assert.assertEquals((Object)"value=4", (Object)sb.toString());
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var8_13 = null;
            try {
                assert (!dc.isPresent());
                assert (!dc.isData());
                assert (!dc.isMetaData());
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_13 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_13.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testToEnd() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).build();){
            ExcerptTailer tailer = chronicle.createTailer();
            tailer.toEnd();
            try (SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).build();){
                ExcerptAppender append = chronicle2.acquireAppender();
                append.writeDocument(w -> w.write(() -> "test").text("text"));
            }
            Assert.assertTrue((boolean)tailer.readDocument(w -> w.read(() -> "test").text((Object)"text", Assert::assertEquals)));
        }
    }

    @Test
    public void testAppendedBeforeToEnd() throws Exception {
        File dir = this.getTmpDir();
        SingleChronicleQueue chronicle = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        ExcerptTailer tailer = chronicle.createTailer();
        SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        ExcerptAppender append = chronicle2.acquireAppender();
        append.writeDocument(w -> w.write(() -> "test").text("text"));
        tailer.toEnd();
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
        append.writeDocument(w -> w.write(() -> "test").text("text2"));
        Assert.assertTrue((boolean)tailer.readDocument(w -> w.read(() -> "test").text((Object)"text2", Assert::assertEquals)));
    }

    @Test
    public void testToEnd2() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).build();
             SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).build();){
            ExcerptAppender append = chronicle2.acquireAppender();
            append.writeDocument(w -> w.write(() -> "test").text("before text"));
            ExcerptTailer tailer = chronicle.createTailer();
            tailer.toEnd();
            append.writeDocument(w -> w.write(() -> "test").text("text"));
            Assert.assertTrue((boolean)tailer.readDocument(w -> w.read(() -> "test").text((Object)"text", Assert::assertEquals)));
        }
    }

    @Test
    public void testReadWrite() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).blockSize(0x200000).build();
             SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).blockSize(0x200000).build();){
            ExcerptAppender append = chronicle2.acquireAppender();
            for (int i = 0; i < 50000; ++i) {
                append.writeDocument(w -> w.write(() -> "test - message").text("text"));
            }
            ExcerptTailer tailer = chronicle.createTailer();
            ExcerptTailer tailer2 = chronicle.createTailer();
            ExcerptTailer tailer3 = chronicle.createTailer();
            ExcerptTailer tailer4 = chronicle.createTailer();
            for (int i = 0; i < 50000; ++i) {
                if (i % 10000 == 0) {
                    System.gc();
                }
                if (i % 2 == 0) {
                    Assert.assertTrue((boolean)tailer2.readDocument(w -> w.read(() -> "test - message").text((Object)"text", Assert::assertEquals)));
                }
                if (i % 3 == 0) {
                    Assert.assertTrue((boolean)tailer3.readDocument(w -> w.read(() -> "test - message").text((Object)"text", Assert::assertEquals)));
                }
                if (i % 4 == 0) {
                    Assert.assertTrue((boolean)tailer4.readDocument(w -> w.read(() -> "test - message").text((Object)"text", Assert::assertEquals)));
                }
                Assert.assertTrue((boolean)tailer.readDocument(w -> w.read(() -> "test - message").text((Object)"text", Assert::assertEquals)));
            }
        }
    }

    @Test
    public void testReadingDocumentForEmptyQueue() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue chronicle = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).build();){
            ExcerptTailer tailer = chronicle.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
            var6_8 = null;
            try (SingleChronicleQueue chronicle2 = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.HOURLY).build();){
                ExcerptAppender appender = chronicle2.acquireAppender();
                appender.writeDocument(w -> w.write(() -> "test - message").text("text"));
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertTrue((boolean)dc.isPresent());
                    dc.wire().read(() -> "test - message").text((Object)"text", Assert::assertEquals);
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testMetaData6() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ValueIn in2;
            Throwable throwable;
            DocumentContext dc;
            ExcerptAppender appender = chronicle.acquireAppender();
            try (DocumentContext dc2 = appender.writingDocument(true);){
                dc2.wire().write(() -> "FirstName").text("Quartilla");
            }
            dc2 = appender.writingDocument();
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)dc2.isMetaData());
                dc2.wire().write(() -> "FirstName").text("Helen");
            }
            catch (Throwable throwable2) {
                var5_7 = throwable2;
                throw throwable2;
            }
            finally {
                if (dc2 != null) {
                    if (var5_7 != null) {
                        try {
                            dc2.close();
                        }
                        catch (Throwable throwable3) {
                            var5_7.addSuppressed(throwable3);
                        }
                    } else {
                        dc2.close();
                    }
                }
            }
            dc2 = appender.writingDocument(true);
            var5_7 = null;
            try {
                dc2.wire().write(() -> "FirstName").text("Steve");
            }
            catch (Throwable throwable4) {
                var5_7 = throwable4;
                throw throwable4;
            }
            finally {
                if (dc2 != null) {
                    if (var5_7 != null) {
                        try {
                            dc2.close();
                        }
                        catch (Throwable throwable5) {
                            var5_7.addSuppressed(throwable5);
                        }
                    } else {
                        dc2.close();
                    }
                }
            }
            Assert.assertEquals((Object)this.expectedMetaDataTest2(), (Object)chronicle.dump());
            ExcerptTailer tailer = chronicle.createTailer();
            StringBuilder event = new StringBuilder();
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    in2 = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in2.text((Object)"Quartilla", Assert::assertEquals);
                }
                catch (Throwable in2) {
                    throwable = in2;
                    throw in2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            dc = tailer.readingDocument(true);
            throwable = null;
            try {
                Assert.assertTrue((boolean)dc.isData());
                Assert.assertTrue((boolean)dc.isPresent());
                dc.wire().read(() -> "FirstName").text((Object)"Helen", Assert::assertEquals);
            }
            catch (Throwable in2) {
                throwable = in2;
                throw in2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable in2) {
                            throwable.addSuppressed(in2);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            while (true) {
                dc = tailer.readingDocument(true);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)dc.isMetaData());
                    in2 = dc.wire().read(event);
                    if (!StringUtils.isEqual((StringBuilder)event, (CharSequence)"FirstName")) continue;
                    in2.text((Object)"Steve", Assert::assertEquals);
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
    }

    @NotNull
    protected String expectedMetaData6() {
        if (this.wireType == WireType.BINARY) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 0\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1000\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 1\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1001\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 2\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1002\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 3\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1003\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 4\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1004\n# position: 591, header: 1 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327085 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 578,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  568,\n  578,\n  0, 0, 0, 0, 0, 0\n]\n# position: 568, header: 0\n--- !!data #binary\ntest: 5\n# position: 578, header: 1\n--- !!data #binary\ntest2: !short 1005\n...\n# 327085 bytes remaining\n";
        }
        if (this.wireType == WireType.BINARY_LIGHT) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 728,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  728,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: -1\n--- !!meta-data #binary\nFirstName: Quartilla\n# position: 728, header: 0\n--- !!data #binary\nFirstName: Helen\n# position: 748, header: 0\n--- !!meta-data #binary\nFirstName: Steve\n...\n# 326908 bytes remaining\n";
        }
        throw new IllegalStateException("unknown type");
    }

    @NotNull
    protected String expectedMetaDataTest2() {
        if (this.wireType == WireType.BINARY) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 720,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 369,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  536,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 536, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  720,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 696, header: -1\n--- !!meta-data #binary\nFirstName: Quartilla\n# position: 720, header: 0\n--- !!data #binary\nFirstName: Helen\n# position: 740, header: 0\n--- !!meta-data #binary\nFirstName: Steve\n...\n# 326916 bytes remaining\n";
        }
        if (this.wireType == WireType.BINARY_LIGHT) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 728,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  728,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: -1\n--- !!meta-data #binary\nFirstName: Quartilla\n# position: 728, header: 0\n--- !!data #binary\nFirstName: Helen\n# position: 748, header: 0\n--- !!meta-data #binary\nFirstName: Steve\n...\n# 326908 bytes remaining\n";
        }
        throw new IllegalStateException("unknown type");
    }

    @Test(expected=IllegalArgumentException.class)
    public void dontPassQueueToReader() {
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).build();){
            queue.createTailer().afterLastWritten((ChronicleQueue)queue).methodReader(new Object[0]);
        }
    }

    @Test
    public void testToEndBeforeWrite() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            ExcerptTailer tailer = chronicle.createTailer();
            int entries = chronicle.rollCycle().defaultIndexSpacing() * 2 + 2;
            int i = 0;
            while (i < entries) {
                tailer.toEnd();
                int finalI = i++;
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world" + finalI));
                tailer.readDocument(w -> w.read().text((Object)("world" + finalI), Assert::assertEquals));
            }
        }
    }

    @Test
    public void testSomeMessages() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            ExcerptTailer tailer = chronicle.createTailer();
            int entries = chronicle.rollCycle().defaultIndexSpacing() * 2 + 2;
            for (long i = 0L; i < (long)entries; ++i) {
                long finalI = i;
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").int64(finalI));
                long seq = chronicle.rollCycle().toSequenceNumber(appender.lastIndexAppended());
                Assert.assertEquals((long)i, (long)seq);
                tailer.readDocument(w -> w.read().int64((Object)finalI, (a, b) -> Assert.assertEquals((long)a, (long)b)));
            }
        }
    }

    @Test
    public void testForwardFollowedBackBackwardTailer() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            int entries = chronicle.rollCycle().defaultIndexSpacing() + 2;
            int i = 0;
            while (i < entries) {
                int finalI = i++;
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world" + finalI));
            }
            for (i = 0; i < 3; ++i) {
                this.readForward((ChronicleQueue)chronicle, entries);
                this.readBackward((ChronicleQueue)chronicle, entries);
            }
        }
    }

    void readForward(ChronicleQueue chronicle, int entries) {
        ExcerptTailer forwardTailer = chronicle.createTailer().direction(TailerDirection.FORWARD).toStart();
        for (int i = 0; i < entries; ++i) {
            try (DocumentContext documentContext = forwardTailer.readingDocument();){
                Assert.assertTrue((boolean)documentContext.isPresent());
                Assert.assertEquals((long)i, (long)RollCycles.DAILY.toSequenceNumber(documentContext.index()));
                StringBuilder sb = Wires.acquireStringBuilder();
                ValueIn valueIn = documentContext.wire().readEventName(sb);
                Assert.assertTrue((boolean)"hello".contentEquals(sb));
                String actual = valueIn.text();
                Assert.assertEquals((Object)("world" + i), (Object)actual);
                continue;
            }
        }
        try (DocumentContext documentContext = forwardTailer.readingDocument();){
            Assert.assertFalse((boolean)documentContext.isPresent());
        }
    }

    void readBackward(ChronicleQueue chronicle, int entries) {
        ExcerptTailer backwardTailer = chronicle.createTailer().direction(TailerDirection.BACKWARD).toEnd();
        for (int i = entries - 1; i >= 0; --i) {
            try (DocumentContext documentContext = backwardTailer.readingDocument();){
                Assert.assertTrue((boolean)documentContext.isPresent());
                long index = documentContext.index();
                Assert.assertEquals((String)("index: " + index), (long)i, (long)((int)index));
                Assert.assertEquals((long)i, (long)RollCycles.DAILY.toSequenceNumber(index));
                Assert.assertTrue((boolean)documentContext.isPresent());
                StringBuilder sb = Wires.acquireStringBuilder();
                ValueIn valueIn = documentContext.wire().readEventName(sb);
                Assert.assertTrue((boolean)"hello".contentEquals(sb));
                String actual = valueIn.text();
                Assert.assertEquals((Object)("world" + i), (Object)actual);
                continue;
            }
        }
        try (DocumentContext documentContext = backwardTailer.readingDocument();){
            Assert.assertFalse((boolean)documentContext.isPresent());
        }
    }

    @Test
    public void testOverreadForwardFromFutureCycleThenReadBackwardTailer() {
        RollCycles cycle = RollCycles.TEST2_DAILY;
        AtomicBoolean forwardToFuture = new AtomicBoolean(false);
        TimeProvider timeProvider = () -> forwardToFuture.get() ? System.currentTimeMillis() + TimeUnit.MILLISECONDS.toDays(1L) : System.currentTimeMillis();
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)cycle).timeProvider(timeProvider).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world"));
            forwardToFuture.set(true);
            ExcerptTailer forwardTailer = chronicle.createTailer().direction(TailerDirection.FORWARD).toStart();
            try (DocumentContext context = forwardTailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
            context = forwardTailer.readingDocument();
            var9_11 = null;
            try {
                Assert.assertFalse((boolean)context.isPresent());
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var9_11 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            ExcerptTailer backwardTailer = chronicle.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            try (DocumentContext context = backwardTailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
        }
    }

    @Test
    public void testLastIndexAppended() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world0"));
            long nextIndexToWrite = appender.lastIndexAppended() + 1L;
            appender.writeDocument(w -> w.getValueOut().bytes(new byte[0]));
            Assert.assertEquals((long)nextIndexToWrite, (long)appender.lastIndexAppended());
        }
    }

    @Test
    public void testZeroLengthMessage() {
        try (SingleChronicleQueue chronicle = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = chronicle.acquireAppender();
            appender.writeDocument(w -> {});
            System.out.println(chronicle.dump());
            ExcerptTailer tailer = chronicle.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.wire().hasMore());
            }
        }
    }

    @Test
    public void testMoveToWithAppender() throws TimeoutException, StreamCorruptedException {
        try (SingleChronicleQueue syncQ = this.builder(this.getTmpDir(), this.wireType).build();){
            SingleChronicleQueueExcerpts.InternalAppender sync = (SingleChronicleQueueExcerpts.InternalAppender)syncQ.acquireAppender();
            File name2 = Utils.tempDir(this.testName.getMethodName());
            try (SingleChronicleQueue chronicle = this.builder(name2, this.wireType).build();){
                ExcerptAppender appender = chronicle.acquireAppender();
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world0"));
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world1"));
                appender.writeDocument(w -> w.writeEventName((CharSequence)"hello").text("world2"));
                ExcerptTailer tailer = chronicle.createTailer();
                try (DocumentContext documentContext = tailer.readingDocument();){
                    sync.writeBytes(documentContext.index(), (BytesStore)documentContext.wire().bytes());
                }
                documentContext = tailer.readingDocument();
                var10_14 = null;
                try {
                    String text = documentContext.wire().read().text();
                    Assert.assertEquals((Object)"world1", (Object)text);
                }
                catch (Throwable throwable) {
                    var10_14 = throwable;
                    throw throwable;
                }
                finally {
                    if (documentContext != null) {
                        if (var10_14 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable) {
                                var10_14.addSuppressed(throwable);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testMapWrapper() throws TimeoutException, StreamCorruptedException {
        try (SingleChronicleQueue syncQ = this.builder(this.getTmpDir(), this.wireType).build();){
            File name2 = Utils.tempDir(this.testName.getMethodName());
            try (SingleChronicleQueue chronicle = this.builder(name2, this.wireType).build();){
                ExcerptAppender appender = chronicle.acquireAppender();
                MapWrapper myMap = new MapWrapper();
                myMap.map.put("hello", 1.2);
                appender.writeDocument(w -> w.write().object((Object)myMap));
                ExcerptTailer tailer = chronicle.createTailer();
                try (DocumentContext documentContext = tailer.readingDocument();){
                    MapWrapper object = (MapWrapper)((Object)documentContext.wire().read().object(MapWrapper.class));
                    Assert.assertEquals((double)1.2, (double)object.map.get("hello"), (double)0.0);
                }
            }
        }
    }

    @Test
    public void testAppendedSkipToEnd() throws TimeoutException, ExecutionException, InterruptedException {
        try (SingleChronicleQueue q = this.builder(this.getTmpDir(), this.wireType).build();){
            ExcerptAppender appender = q.acquireAppender();
            ExcerptAppender appender2 = q.acquireAppender();
            int indexCount = 100;
            for (int i = 0; i < indexCount; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write((CharSequence)"key").text("some more 1");
                    Assert.assertEquals((long)i, (long)q.rollCycle().toSequenceNumber(dc.index()));
                    continue;
                }
            }
            try (DocumentContext dc = appender2.writingDocument();){
                dc.wire().write((CharSequence)"key").text("some data " + indexCount);
                Assert.assertEquals((long)indexCount, (long)q.rollCycle().toSequenceNumber(dc.index()));
            }
        }
    }

    @Test
    public void testAppendedSkipToEndMultiThreaded() throws TimeoutException, ExecutionException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 5; ++i2) {
            sb.append(UUID.randomUUID());
        }
        String text = sb.toString();
        try (SingleChronicleQueue q = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ThreadLocal<ExcerptAppender> tl = ThreadLocal.withInitial(() -> ((ChronicleQueue)q).acquireAppender());
            int size = 50000;
            IntStream.range(0, size).parallel().forEach(i -> this.writeTestDocument(tl, text));
            ExcerptTailer tailer = q.createTailer();
            for (int i3 = 0; i3 < size; ++i3) {
                try (DocumentContext dc = tailer.readingDocument(false);){
                    Assert.assertEquals((long)dc.index(), (long)dc.wire().read(() -> "key").int64());
                    continue;
                }
            }
        }
    }

    @Ignore(value="Long Running Test")
    @Test
    public void testRandomConcurrentReadWrite() throws TimeoutException, ExecutionException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            sb.append(UUID.randomUUID());
        }
        String text = sb.toString();
        for (int i = 0; i < 20; ++i) {
            ExecutorService executor = Executors.newWorkStealingPool(8);
            try (SingleChronicleQueue q = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.MINUTELY).build();){
                ThreadLocal<ExcerptAppender> tl = ThreadLocal.withInitial(() -> SingleChronicleQueueTest.lambda$testRandomConcurrentReadWrite$143((ChronicleQueue)q));
                ThreadLocal<ExcerptTailer> tlt = ThreadLocal.withInitial(() -> ((ChronicleQueue)q).createTailer());
                int size = 20000000;
                for (int j = 0; j < size; ++j) {
                    executor.execute(() -> this.doSomething(tl, tlt, text));
                }
                executor.shutdown();
                if (!executor.awaitTermination(10000L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
                System.out.println(". " + i);
                Jvm.pause((long)1000L);
                continue;
            }
        }
    }

    @Test
    public void testToEndPrevCycleEOF() throws TimeoutException, ExecutionException, InterruptedException {
        ExcerptTailer tailer2;
        File dir = this.getTmpDir();
        try (SingleChronicleQueue q = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            q.acquireAppender().writeText((CharSequence)"first");
        }
        Thread.sleep(1100L);
        q = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        var3_3 = null;
        try {
            tailer2 = q.createTailer();
            Assert.assertEquals((Object)"first", (Object)tailer2.readText());
            Assert.assertEquals(null, (Object)tailer2.readText());
        }
        catch (Throwable tailer2) {
            var3_3 = tailer2;
            throw tailer2;
        }
        finally {
            if (q != null) {
                if (var3_3 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable tailer2) {
                        var3_3.addSuppressed(tailer2);
                    }
                } else {
                    q.close();
                }
            }
        }
        q = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        var3_3 = null;
        try {
            tailer2 = q.createTailer().toEnd();
            try (DocumentContext documentContext = tailer2.readingDocument();){
                Assert.assertFalse((boolean)documentContext.isPresent());
            }
            documentContext = tailer2.readingDocument();
            var6_16 = null;
            try {
                Assert.assertFalse((boolean)documentContext.isPresent());
            }
            catch (Throwable throwable) {
                var6_16 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var6_16 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var6_16.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
        }
        catch (Throwable tailer3) {
            var3_3 = tailer3;
            throw tailer3;
        }
        finally {
            if (q != null) {
                if (var3_3 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable tailer3) {
                        var3_3.addSuppressed(tailer3);
                    }
                } else {
                    q.close();
                }
            }
        }
        q = this.builder(dir, this.wireType).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        var3_3 = null;
        try {
            ExcerptTailer excerptTailerBeforeAppend = q.createTailer().toEnd();
            q.acquireAppender().writeText((CharSequence)"more text");
            ExcerptTailer excerptTailerAfterAppend = q.createTailer().toEnd();
            q.acquireAppender().writeText((CharSequence)"even more text");
            Assert.assertEquals((Object)"more text", (Object)excerptTailerBeforeAppend.readText());
            Assert.assertEquals((Object)"even more text", (Object)excerptTailerAfterAppend.readText());
            Assert.assertEquals((Object)"even more text", (Object)excerptTailerBeforeAppend.readText());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (q != null) {
                if (var3_3 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    q.close();
                }
            }
        }
    }

    @Test
    public void testTailerWhenCyclesWhereSkippedOnWrite() throws Exception {
        SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        ExcerptAppender appender = queue.acquireAppender();
        ExcerptTailer tailer = queue.createTailer();
        List<String> stringsToPut = Arrays.asList("one", "two", "three");
        try (DocumentContext writingContext = appender.writingDocument();){
            writingContext.wire().write().bytes(stringsToPut.get(0).getBytes());
        }
        writingContext = appender.writingDocument();
        var6_6 = null;
        try {
            writingContext.wire().write().bytes(stringsToPut.get(1).getBytes());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (writingContext != null) {
                if (var6_6 != null) {
                    try {
                        writingContext.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    writingContext.close();
                }
            }
        }
        Thread.sleep(2100L);
        writingContext = appender.writingDocument();
        var6_6 = null;
        try {
            writingContext.wire().write().bytes(stringsToPut.get(2).getBytes());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (writingContext != null) {
                if (var6_6 != null) {
                    try {
                        writingContext.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    writingContext.close();
                }
            }
        }
        System.out.println(queue.dump());
        for (String expected : stringsToPut) {
            DocumentContext readingContext = tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!readingContext.isPresent()) {
                    Assert.fail();
                }
                String text = readingContext.wire().read().text();
                System.out.println("read=" + text);
                Assert.assertEquals((Object)expected, (Object)text);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (readingContext == null) continue;
                if (throwable != null) {
                    try {
                        readingContext.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                readingContext.close();
            }
        }
    }

    private void doSomething(ThreadLocal<ExcerptAppender> tla, ThreadLocal<ExcerptTailer> tlt, String text) {
        if (Math.random() > 0.5) {
            this.writeTestDocument(tla, text);
        } else {
            this.readDocument(tlt, text);
        }
    }

    private void readDocument(ThreadLocal<ExcerptTailer> tlt, String text) {
        try (DocumentContext dc = tlt.get().readingDocument();){
            if (!dc.isPresent()) {
                return;
            }
            Assert.assertEquals((long)dc.index(), (long)dc.wire().read(() -> "key").int64());
            Assert.assertEquals((Object)text, (Object)dc.wire().read(() -> "text").text());
        }
    }

    private void writeTestDocument(ThreadLocal<ExcerptAppender> tl, String text) {
        try (DocumentContext dc = tl.get().writingDocument();){
            long index = dc.index();
            dc.wire().write((CharSequence)"key").int64(index);
            dc.wire().write((CharSequence)"text").text(text);
        }
    }

    @Test
    public void testMultipleAppenders() {
        try (SingleChronicleQueue syncQ = this.builder(this.getTmpDir(), this.wireType).rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender syncA = syncQ.acquireAppender();
            ExcerptAppender syncB = syncQ.acquireAppender();
            ExcerptAppender syncC = syncQ.acquireAppender();
            int count = 0;
            for (int i = 0; i < 3; ++i) {
                syncA.writeText((CharSequence)("hello A" + i));
                Assert.assertEquals((long)count++, (long)((int)syncA.lastIndexAppended()));
                syncB.writeText((CharSequence)("hello B" + i));
                Assert.assertEquals((long)count++, (long)((int)syncB.lastIndexAppended()));
                try (DocumentContext dc = syncC.writingDocument(true);){
                    dc.wire().getValueOut().text("some meta " + i);
                    continue;
                }
            }
            String expected = this.expectedMultipleAppenders();
            Assert.assertEquals((Object)expected, (Object)syncQ.dump());
        }
    }

    @NotNull
    protected String expectedMultipleAppenders() {
        if (this.wireType == WireType.BINARY) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 660,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 369,\n    lastIndex: 6\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 369, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  472,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 472, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 6\n  568,\n  580,\n  608,\n  620,\n  648,\n  660,\n  0, 0\n]\n# position: 568, header: 0\n--- !!data\nhello A0\n# position: 580, header: 1\n--- !!data\nhello B0\n# position: 592, header: 1\n--- !!meta-data #binary\nsome meta 0\n# position: 608, header: 2\n--- !!data\nhello A1\n# position: 620, header: 3\n--- !!data\nhello B1\n# position: 632, header: 3\n--- !!meta-data #binary\nsome meta 1\n# position: 648, header: 4\n--- !!data\nhello A2\n# position: 660, header: 5\n--- !!data\nhello B2\n# position: 672, header: 5\n--- !!meta-data #binary\nsome meta 2\n...\n# 326988 bytes remaining\n";
        }
        if (this.wireType == WireType.BINARY_LIGHT) {
            return "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 668,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 6\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 6\n  576,\n  588,\n  616,\n  628,\n  656,\n  668,\n  0, 0\n]\n# position: 576, header: 0\n--- !!data\nhello A0\n# position: 588, header: 1\n--- !!data\nhello B0\n# position: 600, header: 1\n--- !!meta-data #binary\nsome meta 0\n# position: 616, header: 2\n--- !!data\nhello A1\n# position: 628, header: 3\n--- !!data\nhello B1\n# position: 640, header: 3\n--- !!meta-data #binary\nsome meta 1\n# position: 656, header: 4\n--- !!data\nhello A2\n# position: 668, header: 5\n--- !!data\nhello B2\n# position: 680, header: 5\n--- !!meta-data #binary\nsome meta 2\n...\n# 326980 bytes remaining\n";
        }
        throw new IllegalStateException("unknown wiretype=" + this.wireType);
    }

    @Test
    @Ignore(value="Long running")
    public void testCountExceptsBetweenCycles() throws Exception {
        SingleChronicleQueueBuilder builder = this.binary(this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY);
        SingleChronicleQueue queue = builder.build();
        ExcerptAppender appender = queue.createAppender();
        long[] indexs = new long[10];
        for (int i = 0; i < indexs.length; ++i) {
            System.out.println(".");
            try (DocumentContext writingContext = appender.writingDocument();){
                writingContext.wire().write().text("some-text-" + i);
                indexs[i] = writingContext.index();
            }
            if ((i + 1) % 5 == 0) {
                Thread.sleep(2000L);
                continue;
            }
            if ((i + 1) % 3 != 0) continue;
            Thread.sleep(1000L);
        }
        for (int lower = 0; lower < indexs.length; ++lower) {
            for (int upper = lower; upper < indexs.length; ++upper) {
                System.out.println("lower=" + lower + ",upper=" + upper);
                Assert.assertEquals((long)(upper - lower), (long)queue.countExcerpts(indexs[lower], indexs[upper]));
            }
        }
        Assert.assertEquals((long)6L, (long)queue.countExcerpts(indexs[0], indexs[6]));
        Assert.assertEquals((long)queue.rollCycle().toSequenceNumber(indexs[6]), (long)0L);
        Assert.assertEquals((long)5L, (long)queue.countExcerpts(indexs[0], indexs[6] - 1L));
        Assert.assertEquals((long)7L, (long)queue.countExcerpts(indexs[0] - 1L, indexs[6]));
    }

    @Test
    public void testReadingWritingWhenNextCycleIsInSequence() throws Exception {
        File dir = Utils.tempDir(this.testName.getMethodName());
        RollCycles rollCycle = RollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
            queue.acquireAppender().writeText((CharSequence)"first message");
        }
        Thread.sleep(1100L);
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();
        var4_4 = null;
        try {
            queue.acquireAppender().writeText((CharSequence)"second message");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();
        var4_4 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)"first message", (Object)tailer.readText());
            Assert.assertEquals((Object)"second message", (Object)tailer.readText());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testReadingWritingWhenCycleIsSkipped() throws Exception {
        File dir = Utils.tempDir(this.testName.getMethodName());
        RollCycles rollCycle = RollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
            queue.acquireAppender().writeText((CharSequence)"first message");
        }
        Thread.sleep(2100L);
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();
        var4_4 = null;
        try {
            queue.acquireAppender().writeText((CharSequence)"second message");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();
        var4_4 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)"first message", (Object)tailer.readText());
            Assert.assertEquals((Object)"second message", (Object)tailer.readText());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testReadingWritingWhenCycleIsSkippedBackwards() throws Exception {
        File dir = Utils.tempDir(this.testName.getMethodName());
        RollCycles rollCycle = RollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
            queue.acquireAppender().writeText((CharSequence)"first message");
        }
        Thread.sleep(2100L);
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();
        var4_4 = null;
        try {
            queue.acquireAppender().writeText((CharSequence)"second message");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();
        var4_4 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            ExcerptTailer excerptTailer = tailer.direction(TailerDirection.BACKWARD).toEnd();
            Assert.assertEquals((Object)"second message", (Object)excerptTailer.readText());
            Assert.assertEquals((Object)"first message", (Object)excerptTailer.readText());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testReadWritingWithTimeProvider() throws Exception {
        File dir = Utils.tempDir(this.testName.getMethodName());
        long time = System.currentTimeMillis();
        try (SingleChronicleQueue q1 = this.binary(dir).timeProvider(() -> time).build();
             SingleChronicleQueue q2 = this.binary(dir).timeProvider(() -> time).build();){
            ExcerptAppender appender2 = q2.acquireAppender();
            ExcerptTailer tailer1 = q1.createTailer();
            ExcerptTailer tailer2 = q2.createTailer();
            try (DocumentContext dc = appender2.writingDocument();){
                dc.wire().write().text("some data");
            }
            dc = tailer2.readingDocument();
            var12_16 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var12_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertTrue((boolean)q1.file().equals(q2.file()));
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = tailer1.readingDocument();){
                    if (dc.isPresent()) {
                        return;
                    }
                }
                Jvm.pause((long)1L);
            }
            Assert.fail();
        }
    }

    @Test
    public void testTailerSnappingRollWithNewAppender() throws Exception {
        File dir = Utils.tempDir(this.testName.getMethodName());
        RollCycles rollCycle = RollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            excerptAppender.writeText((CharSequence)"someText");
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<?> f1 = executorService.submit(() -> {
                try (SingleChronicleQueue queue2 = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
                    queue2.acquireAppender().writeText((CharSequence)"someText more");
                }
                Jvm.pause((long)1100L);
                queue2 = this.binary(dir).rollCycle((RollCycle)rollCycle).build();
                var4_4 = null;
                try {
                    queue2.acquireAppender().writeText((CharSequence)"someText more");
                }
                catch (Throwable throwable) {
                    var4_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (queue2 != null) {
                        if (var4_4 != null) {
                            try {
                                queue2.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            queue2.close();
                        }
                    }
                }
            });
            Future<?> f2 = executorService.submit(() -> {
                try (SingleChronicleQueue queue2 = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
                    for (int i = 0; i < 5; ++i) {
                        queue2.acquireAppender().writeText((CharSequence)"someText more");
                        Jvm.pause((long)400L);
                    }
                }
            });
            f1.get();
            f2.get();
            executorService.shutdownNow();
        }
    }

    @Test
    public void testLongLivingTailerAppenderReAcquiredEachSecond() throws Exception {
        File dir = Utils.tempDir(this.testName.getMethodName());
        RollCycles rollCycle = RollCycles.TEST_SECONDLY;
        try (SingleChronicleQueue queuet = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
            ExcerptTailer tailer = queuet.createTailer();
            try (SingleChronicleQueue queue = this.binary(dir).rollCycle((RollCycle)rollCycle).build();){
                for (int i = 0; i < 5; ++i) {
                    ExcerptAppender appender = queue.acquireAppender();
                    Thread.sleep(1100L);
                    try (DocumentContext dc = appender.writingDocument();){
                        dc.wire().write((CharSequence)"some").int32(i);
                    }
                    dc = tailer.readingDocument();
                    var11_15 = null;
                    try {
                        Assert.assertEquals((long)i, (long)dc.wire().read("some").int32());
                        continue;
                    }
                    catch (Throwable throwable) {
                        var11_15 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (dc != null) {
                            if (var11_15 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable) {
                                    var11_15.addSuppressed(throwable);
                                }
                            } else {
                                dc.close();
                            }
                        }
                    }
                }
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCountExceptsWithRubbishData() throws Exception {
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            queue.countExcerpts(6309354155219615744L, 5949066185029976064L);
        }
    }

    @Ignore(value="todo fix fails with enterprise queue")
    @Test
    public void testFromSizePrefixedBlobs() throws Exception {
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).build();){
            DocumentContext dc0;
            try (DocumentContext dc = queue.acquireAppender().writingDocument();){
                dc.wire().write((CharSequence)"some").text("data");
            }
            String s = null;
            try (DocumentContext dc = queue.createTailer().readingDocument();){
                s = Wires.fromSizePrefixedBlobs((DocumentContext)dc);
                Assert.assertTrue((boolean)s.contains("some: data"));
                dc0 = dc;
            }
            String out = Wires.fromSizePrefixedBlobs((DocumentContext)dc0);
            Assert.assertEquals((Object)s, (Object)out);
        }
    }

    @Test
    public void testCopyQueue() throws Exception {
        File source = Utils.tempDir("testCopyQueue-source");
        File target = Utils.tempDir("testCopyQueue-target");
        SingleChronicleQueue q = this.binary(source).build();
        ExcerptAppender excerptAppender = q.acquireAppender();
        excerptAppender.writeMessage(() -> "one", (Object)1);
        excerptAppender.writeMessage(() -> "two", (Object)2);
        excerptAppender.writeMessage(() -> "three", (Object)3);
        excerptAppender.writeMessage(() -> "four", (Object)4);
        SingleChronicleQueue s = this.binary(source).build();
        ExcerptTailer sourceTailer = s.createTailer();
        SingleChronicleQueue t = this.binary(target).build();
        ExcerptAppender appender = t.acquireAppender();
        while (true) {
            DocumentContext rdc = sourceTailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!rdc.isPresent()) break;
                DocumentContext wdc = appender.writingDocument(rdc.index());
                Throwable throwable2 = null;
                try {
                    Bytes bytes = rdc.wire().bytes();
                    System.out.println(bytes);
                    wdc.wire().bytes().write((BytesStore)bytes);
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (wdc == null) continue;
                    if (throwable2 != null) {
                        try {
                            wdc.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    wdc.close();
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (rdc == null) continue;
                if (throwable != null) {
                    try {
                        rdc.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                rdc.close();
                continue;
            }
            break;
        }
        System.out.println(s.dump());
    }

    @Test
    public void testIncorrectExcerptTailerReadsAfterSwitchingTailerDirection() throws Exception {
        SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        int value = 0;
        long cycle = 0L;
        long startIndex = 0L;
        for (int i = 0; i < 56; ++i) {
            try (DocumentContext dc = queue.acquireAppender().writingDocument();){
                if (cycle == 0L) {
                    cycle = queue.rollCycle().toCycle(dc.index());
                }
                long index = dc.index();
                long seq = queue.rollCycle().toSequenceNumber(index);
                if (seq == 52L) {
                    startIndex = dc.index();
                }
                if (seq >= 52L) {
                    int v = value++;
                    System.out.println("stored => sequence-number=" + seq + ", value=" + v);
                    dc.wire().write((CharSequence)"value").int64((long)v);
                    continue;
                }
                dc.wire().write((CharSequence)"value").int64(0L);
                continue;
            }
        }
        ExcerptTailer tailer = queue.createTailer();
        Assert.assertTrue((boolean)tailer.moveToIndex(startIndex));
        tailer = tailer.direction(TailerDirection.FORWARD);
        Assert.assertEquals((long)0L, (long)this.action(tailer, queue.rollCycle()));
        Assert.assertEquals((long)1L, (long)this.action(tailer, queue.rollCycle()));
        tailer = tailer.direction(TailerDirection.BACKWARD);
        Assert.assertEquals((long)2L, (long)this.action(tailer, queue.rollCycle()));
        Assert.assertEquals((long)1L, (long)this.action(tailer, queue.rollCycle()));
        tailer = tailer.direction(TailerDirection.FORWARD);
        Assert.assertEquals((long)0L, (long)this.action(tailer, queue.rollCycle()));
        Assert.assertEquals((long)1L, (long)this.action(tailer, queue.rollCycle()));
    }

    private long action(ExcerptTailer tailer1, RollCycle rollCycle) {
        long readvalue = 0L;
        long seqNumRead = 0L;
        try (DocumentContext dc = tailer1.readingDocument();){
            readvalue = dc.wire().read("value").int64();
            seqNumRead = dc.index();
        }
        long nextSeq = rollCycle.toSequenceNumber(tailer1.index());
        System.out.println("Return-value=" + readvalue + ", seq=" + rollCycle.toSequenceNumber(seqNumRead) + ", next-seq=" + nextSeq + "(" + Long.toHexString(nextSeq) + "x0),direction=" + tailer1.direction());
        return readvalue;
    }

    @Test
    public void checkReferenceCountingAndCheckFileDeletion() throws IOException, InterruptedException {
        MappedFile mappedFile;
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext documentContext1 = appender.writingDocument();){
                documentContext1.wire().write().text("some text");
            }
            var6_7 = null;
            try (DocumentContext documentContext = queue.createTailer().readingDocument();){
                mappedFile = this.toMappedFile(documentContext);
                Assert.assertEquals((Object)"some text", (Object)documentContext.wire().read().text());
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        assert (mappedFile.isClosed());
        Assert.assertTrue((boolean)mappedFile.file().delete());
    }

    @Test
    public void checkReferenceCountingWhenRollingAndCheckFileDeletion() throws IOException, InterruptedException {
        MappedFile mappedFile4;
        MappedFile mappedFile2;
        MappedFile mappedFile1;
        try (SingleChronicleQueue queue = this.binary(this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("some text");
                mappedFile1 = this.toMappedFile(dc);
            }
            Thread.sleep(1100L);
            dc = appender.writingDocument();
            var9_7 = null;
            try {
                dc.wire().write().text("some more text");
                mappedFile2 = this.toMappedFile(dc);
            }
            catch (Throwable throwable) {
                var9_7 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_7 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_7.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext documentContext = tailer.readingDocument();){
                MappedFile mappedFile3 = this.toMappedFile(documentContext);
                Assert.assertEquals((Object)"some text", (Object)documentContext.wire().read().text());
            }
            documentContext = tailer.readingDocument();
            var10_13 = null;
            try {
                mappedFile4 = this.toMappedFile(documentContext);
                Assert.assertEquals((Object)"some more text", (Object)documentContext.wire().read().text());
            }
            catch (Throwable throwable) {
                var10_13 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var10_13 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var10_13.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
        }
        Assert.assertTrue((boolean)mappedFile1.isClosed());
        Assert.assertTrue((boolean)mappedFile2.isClosed());
        Assert.assertTrue((mappedFile2 == mappedFile4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)mappedFile1.file().delete());
        Assert.assertTrue((boolean)mappedFile2.file().delete());
    }

    protected SingleChronicleQueueBuilder builder(File file, WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).testBlockSize();
    }

    protected SingleChronicleQueueBuilder binary(File file) {
        return SingleChronicleQueueBuilder.binary((File)file).testBlockSize();
    }

    private MappedFile toMappedFile(DocumentContext documentContext) {
        MappedBytes bytes = (MappedBytes)documentContext.wire().bytes();
        MappedFile mappedFile = bytes.mappedFile();
        return mappedFile;
    }

    private static /* synthetic */ ExcerptAppender lambda$testRandomConcurrentReadWrite$143(ChronicleQueue q) {
        ExcerptAppender appender = q.acquireAppender();
        appender.padToCacheAlign(MarshallableOut.Padding.ALWAYS);
        return appender;
    }

    private static /* synthetic */ void lambda$testAppendAndReadAtIndex$27(int n, RollingChronicleQueue queue, WireIn r) throws IORuntimeException {
        Assert.assertEquals((long)n, (long)queue.rollCycle().toSequenceNumber((long)r.read((WireKey)ChronicleQueueTestBase.TestKey.test).int32()));
    }

    private static /* synthetic */ void lambda$testReadAndAppend$9(ChronicleQueue queue, int[] results) {
        try {
            ExcerptTailer tailer = queue.createTailer();
            int i = 0;
            while (i < 2) {
                boolean read = tailer.readDocument(r -> {
                    int result;
                    results[result] = result = r.read((WireKey)ChronicleQueueTestBase.TestKey.test).int32();
                });
                if (read) {
                    ++i;
                    continue;
                }
                Jvm.pause((long)10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    private static /* synthetic */ void lambda$testWriteWithDocumentReadBytesDifferentThreads$3(ChronicleQueue queue, BlockingQueue result) {
        VanillaBytes b = Bytes.allocateDirect((long)128L);
        ExcerptTailer tailer = queue.createTailer();
        tailer.readBytes((Bytes)b);
        if (b.readRemaining() == 0L) {
            return;
        }
        b.readPosition(0L);
        result.add(b);
        throw new RejectedExecutionException();
    }

    private static /* synthetic */ void lambda$testWriteWithDocumentReadBytesDifferentThreads$2(ChronicleQueue queue) {
        ExcerptAppender appender = queue.acquireAppender();
        try (DocumentContext dc = appender.writingDocument();){
            dc.wire().writeEventName(() -> "key").text("some long message");
        }
    }

    static class MyMarshable
    extends AbstractMarshallable
    implements Demarshallable {
        @UsedViaReflection
        String name;

        @UsedViaReflection
        public MyMarshable(@NotNull WireIn wire) {
            this.readMarshallable(wire);
        }

        public MyMarshable() {
        }
    }

    private static class MapWrapper
    extends AbstractMarshallable {
        final Map<CharSequence, Double> map = new HashMap<CharSequence, Double>();

        private MapWrapper() {
        }
    }
}

