/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SingleCQFormatTest {
    private ThreadDump threadDump;

    private static void expected(@NotNull ExcerptTailer tailer, String expected) {
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertTrue((boolean)dc.isPresent());
            VanillaBytes bytes2 = Bytes.allocateDirect((long)128L);
            dc.wire().copyTo((WireOut)new TextWire((Bytes)bytes2));
            Assert.assertEquals((Object)expected, (Object)bytes2.toString());
        }
    }

    @Test
    public void testEmptyDirectory() {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)queue.firstCycle());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)queue.lastCycle());
        queue.close();
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    @Test
    public void testInvalidFile() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700102.cq4"), (long)262144L);
        bytes.write8bit("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>");
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();
        Assert.assertEquals((long)1L, (long)queue.firstCycle());
        Assert.assertEquals((long)1L, (long)queue.lastCycle());
        try {
            ExcerptTailer tailer = queue.createTailer();
            tailer.toEnd();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"java.io.StreamCorruptedException: Unexpected magic number 783f3c37", (Object)e.toString());
        }
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testNoHeader() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();
        this.testQueue(queue);
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TimeoutException.class)
    @Ignore(value="Long running")
    public void testDeadHeader() throws FileNotFoundException {
        File dir = Utils.tempDir("testDeadHeader");
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        bytes.writeInt(-1073741824);
        bytes.release();
        SingleChronicleQueue queue = null;
        try {
            queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().blockSize(262144).build();
            this.testQueue(queue);
        }
        catch (Throwable throwable) {
            Closeable.closeQuietly(queue);
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
            throw throwable;
        }
        Closeable.closeQuietly((Object)queue);
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    private void testQueue(@NotNull SingleChronicleQueue queue) {
        ExcerptTailer tailer = queue.createTailer();
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
    }

    @Test
    public void testCompleteHeader() throws FileNotFoundException {
        File dir = Utils.tempDir("testCompleteHeader");
        dir.mkdirs();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> {
                w.write(() -> "wireType").object((Object)WireType.BINARY);
                w.write(() -> "writePosition").int64forBinding(0L);
                w.write(() -> "roll").typedMarshallable((WriteMarshallable)new SCQRoll((RollCycle)RollCycles.DAILY, 0L));
                w.write(() -> "indexing").typedMarshallable((WriteMarshallable)new SCQIndexing(WireType.BINARY, 32768, 32));
                w.write(() -> "lastAcknowledgedIndexReplicated").int64forBinding(0L);
            });
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: !int 32768,\n    indexSpacing: 32,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: 0\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();
        this.testQueue(queue);
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCompleteHeader2() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101-02.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typedMarshallable((WriteMarshallable)new SingleChronicleQueueStore((RollCycle)RollCycles.HOURLY, WireType.BINARY, bytes, 3600000L, 4096, 4, (StoreRecovery)new TimedStoreRecovery(WireType.BINARY), -1));
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 3600000,\n    format: yyyyMMdd-HH,\n    epoch: !int 3600000\n  },\n  indexing: !SCQSIndexing {\n    indexCount: !short 4096,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: !byte -1\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).rollCycle((RollCycle)RollCycles.HOURLY).build();
        this.testQueue(queue);
        Assert.assertEquals((long)2L, (long)queue.firstCycle());
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncompleteHeader() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> w.write(() -> "wireType").object((Object)WireType.BINARY));
        }
        bytes.release();
        try {
            var5_7 = null;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();){
                this.testQueue(queue);
                Assert.fail();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.IORuntimeException: net.openhft.chronicle.core.io.IORuntimeException: field writePosition required", (Object)e.toString());
        }
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testTwoMessages() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        RollCycles cycle = RollCycles.DAILY;
        MappedBytes mappedBytes = MappedBytes.mappedBytes((File)new File(dir, "19700102.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)mappedBytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typedMarshallable((WriteMarshallable)new SingleChronicleQueueStore((RollCycle)cycle, WireType.BINARY, mappedBytes, 0L, cycle.defaultIndexCount(), cycle.defaultIndexSpacing(), (StoreRecovery)new TimedStoreRecovery(WireType.BINARY), -1));
        }
        dc = wire.writingDocument(false);
        var6_7 = null;
        try {
            dc.wire().writeEventName((CharSequence)"msg").text("Hello world");
        }
        catch (Throwable throwable) {
            var6_7 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var6_7 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var6_7.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
        dc = wire.writingDocument(false);
        var6_7 = null;
        try {
            dc.wire().writeEventName((CharSequence)"msg").text("Also hello world");
        }
        catch (Throwable throwable) {
            var6_7 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var6_7 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var6_7.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: !short 16384,\n    indexSpacing: 16,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: !byte -1\n}\n# position: 370, header: 0\n--- !!data #binary\nmsg: Hello world\n# position: 391, header: 1\n--- !!data #binary\nmsg: Also hello world\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)mappedBytes.readPosition(0L)));
        mappedBytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)cycle).blockSize(262144).build();
        ExcerptTailer tailer = queue.createTailer();
        this.readTwo(tailer);
        tailer.toStart();
        this.readTwo(tailer);
        tailer.direction(TailerDirection.NONE).toStart();
        long start = queue.firstIndex();
        Assert.assertEquals((long)start, (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Hello world\n");
        Assert.assertEquals((long)start, (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Hello world\n");
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    public void readTwo(@NotNull ExcerptTailer tailer) {
        long start = RollCycles.DAILY.toIndex(1, 0L);
        Assert.assertEquals((long)start, (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Hello world\n");
        Assert.assertEquals((long)(start + 1L), (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Also hello world\n");
        Assert.assertEquals((long)(start + 2L), (long)tailer.index());
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
        Assert.assertEquals((long)(start + 2L), (long)tailer.index());
    }
}

