/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class RollCycleTest {
    @Test
    public void newRollCycleIgnored() throws Exception {
        File path = Utils.tempDir("newRollCycleIgnored");
        TestTimeProvider timeProvider = new TestTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver(timeProvider, path.toPath());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            Thread thread = new Thread(observer);
            thread.start();
            observer.await();
            timeProvider.add(TimeUnit.DAYS.toMillis(2L));
            appender.writeText((CharSequence)"Day 3 data");
            Thread.sleep(2000L);
            thread.interrupt();
        }
        Assert.assertEquals((long)1L, (long)observer.documentsRead);
    }

    @Test
    public void newRollCycleIgnored2() throws Exception {
        File path = Utils.tempDir("newRollCycleIgnored2");
        TestTimeProvider timeProvider = new TestTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver(timeProvider, path.toPath());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"Day 1 data");
            Thread thread = new Thread(observer);
            thread.start();
            observer.await();
            timeProvider.add(TimeUnit.DAYS.toMillis(2L));
            appender.writeText((CharSequence)"Day 3 data");
            Thread.sleep(2000L);
            thread.interrupt();
        }
        Assert.assertEquals((long)2L, (long)observer.documentsRead);
    }

    @Test
    public void testWriteToCorruptedFile() throws Exception {
        File dir = Utils.tempDir("testWriteToCorruptedFile");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            long pos;
            Bytes bytes;
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("hello world");
            }
            try (DocumentContext dc = appender.writingDocument();){
                bytes = dc.wire().bytes();
                pos = bytes.writePosition() - 4L;
            }
            bytes.writeInt(pos, Integer.MIN_VALUE);
            dc = appender.writingDocument();
            var9_15 = null;
            try {
                dc.wire().write().text("hello world 2");
            }
            catch (Throwable throwable) {
                var9_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = appender.writingDocument();
            var9_15 = null;
            try {
                dc.wire().write().text("hello world 3");
            }
            catch (Throwable throwable) {
                var9_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    class ParallelQueueObserver
    implements Runnable,
    StoreFileListener {
        SingleChronicleQueue queue;
        CountDownLatch progressLatch;
        int documentsRead;

        public ParallelQueueObserver(TimeProvider timeProvider, Path path) {
            this.queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path.toFile()).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider(timeProvider).storeFileListener((StoreFileListener)this).build();
            this.documentsRead = 0;
            this.progressLatch = new CountDownLatch(1);
        }

        @Override
        public void run() {
            ExcerptTailer tailer = this.queue.createTailer();
            this.progressLatch.countDown();
            while (!Thread.currentThread().isInterrupted()) {
                String readText = tailer.readText();
                if (readText == null) continue;
                System.out.println("Read a document " + readText);
                ++this.documentsRead;
            }
        }

        public void await() throws Exception {
            this.progressLatch.await();
        }

        public int documentsRead() {
            return this.documentsRead;
        }

        public void onAcquired(int cycle, File file) {
            System.out.println("Acquiring " + file);
        }

        public void onReleased(int cycle, File file) {
            System.out.println("Releasing " + file);
        }
    }

    class TestTimeProvider
    implements TimeProvider {
        volatile long add = 0L;

        TestTimeProvider() {
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis() + this.add;
        }

        public void add(long addInMs) {
            this.add += addInMs;
        }
    }
}

