/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NotCompleteTest {
    private final boolean lazyIndexing;

    public NotCompleteTest(boolean lazyIndexing) {
        this.lazyIndexing = lazyIndexing;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testUsingANotCompleteQueue() throws TimeoutException, ExecutionException, InterruptedException {
        Throwable throwable;
        DocumentContext dc;
        BinaryLongReference.startCollecting();
        File tmpDir = Utils.tempDir("testUsingANotCompleteQueue");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            dc = appender.writingDocument();
            throwable = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Thread.sleep(100L);
            BinaryLongReference.forceAllToNotCompleteState();
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testUsingANotCompleteArrayQueue() throws TimeoutException, ExecutionException, InterruptedException {
        Throwable throwable;
        DocumentContext dc;
        BinaryLongArrayReference.startCollecting();
        File tmpDir = Utils.tempDir("testUsingANotCompleteArrayQueue");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            dc = appender.writingDocument();
            throwable = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Thread.sleep(100L);
            BinaryLongArrayReference.forceAllToNotCompleteState();
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testMessageLeftNotComplete() throws TimeoutException, ExecutionException, InterruptedException {
        Throwable throwable;
        DocumentContext dc;
        ExcerptAppender appender;
        File tmpDir = Utils.tempDir("testMessageLeftNotComplete");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            dc = appender.writingDocument();
            dc.wire().write((CharSequence)"some").text("data");
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 576, header: -1 or 0\n--- !!not-ready-data! #binary\n...\n# 654780 bytes remaining\n";
            String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1 or 0\n--- !!not-ready-data! #binary\n...\n# 654979 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
        }
        catch (Throwable tailer) {
            var3_3 = tailer;
            throw tailer;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable tailer) {
                        var3_3.addSuppressed(tailer);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).timeoutMS(500L).build();
        var3_3 = null;
        try {
            appender = queue.acquireAppender();
            dc = appender.writingDocument();
            throwable = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 576,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  576,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nsome: data\n...\n# 83885486 bytes remaining\n", (Object)queue.dump());
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }
}

