/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexTest
extends ChronicleQueueTestBase {
    private final WireType wireType;
    private ThreadDump threadDump;

    public IndexTest(@NotNull WireType wireType) {
        this.wireType = wireType;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{WireType.BINARY}});
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void test() throws IOException {
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).testBlockSize().wireType(this.wireType).build();
        ExcerptAppender appender = queue.acquireAppender();
        int i = 0;
        while (i < 5) {
            int n = i++;
            appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(n));
            int cycle = queue.lastCycle();
            long index0 = queue.rollCycle().toIndex(cycle, (long)n);
            long indexA = appender.lastIndexAppended();
            this.accessHexEquals(index0, indexA);
        }
    }

    public void accessHexEquals(long index0, long indexA) {
        Assert.assertEquals((String)(Long.toHexString(index0) + " != " + Long.toHexString(indexA)), (long)index0, (long)indexA);
    }
}

