/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollingChronicleQueueTest {
    private final boolean lazyIndexing;

    public RollingChronicleQueueTest(boolean lazyIndexing) {
        this.lazyIndexing = lazyIndexing;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testCountExcerptsWhenTheCycleIsRolled() throws Exception {
        AtomicLong time = new AtomicLong();
        File name = Utils.tempDir("testCountExcerptsWhenTheCycleIsRolled");
        SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)name).testBlockSize().timeProvider(time::get).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();
        ExcerptAppender appender = q.acquireAppender().lazyIndexing(this.lazyIndexing);
        time.set(0L);
        appender.writeText((CharSequence)"1. some  text");
        long start = appender.lastIndexAppended();
        appender.writeText((CharSequence)"2. some more text");
        appender.writeText((CharSequence)"3. some more text");
        time.set(TimeUnit.DAYS.toMillis(1L));
        appender.writeText((CharSequence)"4. some text - first cycle");
        time.set(TimeUnit.DAYS.toMillis(2L));
        time.set(TimeUnit.DAYS.toMillis(3L));
        time.set(TimeUnit.DAYS.toMillis(4L));
        appender.writeText((CharSequence)"5. some text - second cycle");
        appender.writeText((CharSequence)"some more text");
        long end = appender.lastIndexAppended();
        String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 742,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 4\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 2\n  704,\n  742,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: 0\n--- !!data\n1. some  text\n# position: 721, header: 1\n--- !!data\n2. some more text\n# position: 742, header: 2\n--- !!data\n3. some more text\n# position: 763, header: 2 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 326913 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 704,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  704,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: 0\n--- !!data\n4. some text - first cycle\n# position: 734, header: 0 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 326942 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 735,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  704,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: 0\n--- !!data\n5. some text - second cycle\n# position: 735, header: 1\n--- !!data\nsome more text\n...\n# 326923 bytes remaining\n";
        String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 741,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 394,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: 0\n--- !!data\n1. some  text\n# position: 394, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  560,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 560, header: 0\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 720, header: 1\n--- !!data\n2. some more text\n# position: 741, header: 2\n--- !!data\n3. some more text\n# position: 762, header: 2 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 326914 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 377,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: 0\n--- !!data\n4. some text - first cycle\n# position: 407, header: 0 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 327269 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 408,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 426,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: 0\n--- !!data\n5. some text - second cycle\n# position: 408, header: 1\n--- !!data\nsome more text\n# position: 426, header: 1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  592,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 592, header: 1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n...\n# 326924 bytes remaining\n";
        Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)q.dump());
        Assert.assertEquals((long)5L, (long)q.countExcerpts(start, end));
    }
}

