/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThreadedQueueTest {
    public static final int REQUIRED_COUNT = 10;
    private ThreadDump threadDump;

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test(timeout=10000L)
    public void testMultipleThreads() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        File path = Utils.tempDir("testMultipleThreads");
        AtomicInteger counter = new AtomicInteger();
        ExecutorService tailerES = Executors.newSingleThreadExecutor();
        Future<?> tf = tailerES.submit(() -> {
            try {
                SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.binary((File)path).testBlockSize().build();
                ExcerptTailer tailer = rqueue.createTailer();
                Bytes bytes = Bytes.elasticByteBuffer();
                while (counter.get() < 10 && !Thread.interrupted()) {
                    bytes.clear();
                    if (!tailer.readBytes(bytes)) continue;
                    counter.incrementAndGet();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        ExecutorService appenderES = Executors.newSingleThreadExecutor();
        Future<?> af = appenderES.submit(() -> {
            try {
                SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.binary((File)path).testBlockSize().build();
                ExcerptAppender appender = wqueue.acquireAppender();
                Bytes message = Bytes.elasticByteBuffer();
                for (int i = 0; i < 10; ++i) {
                    message.clear();
                    message.append((long)i);
                    appender.writeBytes(message);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        appenderES.shutdown();
        tailerES.shutdown();
        long end = System.currentTimeMillis() + 9000L;
        af.get(9000L, TimeUnit.MILLISECONDS);
        tf.get(end - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)10L, (long)counter.get());
    }

    @Test
    public void testTailerReadingEmptyQueue() throws IOException {
        File path = Utils.tempDir("testTailerReadingEmptyQueue");
        SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();
        ExcerptTailer tailer = rqueue.createTailer();
        SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();
        Bytes bytes = Bytes.elasticByteBuffer();
        Assert.assertFalse((boolean)tailer.readBytes(bytes));
        ExcerptAppender appender = wqueue.acquireAppender();
        appender.writeBytes(Bytes.wrapForRead((byte[])"Hello World".getBytes(StandardCharsets.ISO_8859_1)));
        bytes.clear();
        Assert.assertTrue((boolean)tailer.readBytes(bytes));
        Assert.assertEquals((Object)"Hello World", (Object)bytes.toString());
    }
}

