/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.MethodReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageReaderWriterTest {
    private ThreadDump threadDump;

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void testWriteWhileReading() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Message1.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Message2.class});
        File path1 = Utils.tempDir("testWriteWhileReading1");
        File path2 = Utils.tempDir("testWriteWhileReading2");
        try (SingleChronicleQueue queue1 = SingleChronicleQueueBuilder.binary((File)path1).testBlockSize().build();
             SingleChronicleQueue queue2 = SingleChronicleQueueBuilder.binary((File)path2).testBlockSize().build();){
            MethodReader reader2 = queue1.createTailer().methodReader(new Object[]{ObjectUtils.printAll(MessageListener.class, (Class[])new Class[0])});
            MessageListener writer2 = (MessageListener)queue2.acquireAppender().methodWriter(MessageListener.class, new Class[0]);
            MessageProcessor processor = new MessageProcessor(writer2);
            MethodReader reader1 = queue1.createTailer().methodReader(new Object[]{processor});
            MessageListener writer1 = (MessageListener)queue1.acquireAppender().methodWriter(MessageListener.class, new Class[0]);
            for (int i = 0; i < 3; ++i) {
                writer1.method1(new Message1("hello"));
                writer1.method2(new Message2(234L));
                Assert.assertTrue((boolean)reader1.readOne());
                Assert.assertTrue((boolean)reader1.readOne());
                Assert.assertFalse((boolean)reader1.readOne());
                Assert.assertTrue((boolean)reader2.readOne());
                Assert.assertTrue((boolean)reader2.readOne());
                Assert.assertFalse((boolean)reader2.readOne());
            }
        }
    }

    static class MessageProcessor
    implements MessageListener {
        private final MessageListener writer2;

        public MessageProcessor(MessageListener writer2) {
            this.writer2 = writer2;
        }

        @Override
        public void method1(Message1 message) {
            message.text = message.text + "-processed";
            this.writer2.method1(message);
        }

        @Override
        public void method2(Message2 message) {
            message.number += 1000L;
            this.writer2.method2(message);
        }
    }

    static class Message2
    extends AbstractMarshallable {
        long number;

        public Message2(long number) {
            this.number = number;
        }
    }

    static class Message1
    extends AbstractMarshallable {
        String text;

        public Message1(String text) {
            this.text = text;
        }
    }

    static interface MessageListener {
        public void method1(Message1 var1);

        public void method2(Message2 var1);
    }
}

