/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.wire.WireKey;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleQueueTestBase {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ChronicleQueueTestBase.class);
    private static final boolean TRACE_TEST_EXECUTION = Boolean.getBoolean("queue.traceTestExecution");
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder(new File(System.getProperty("java.io.tmpdir")));
    @Rule
    public final ErrorCollector errorCollector = new ErrorCollector();
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            if (TRACE_TEST_EXECUTION) {
                LOGGER.info("Starting test: {}.{}", (Object)description.getClassName(), (Object)description.getMethodName());
            }
        }
    };

    protected File getTmpDir() {
        return Utils.tempDir(this.testName.getMethodName());
    }

    public static enum TestKey implements WireKey
    {
        test,
        test2;

    }
}

