/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.micros;

import java.io.File;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.micros.MarketDataListener;
import net.openhft.chronicle.queue.micros.Order;
import net.openhft.chronicle.queue.micros.OrderIdea;
import net.openhft.chronicle.queue.micros.OrderIdeaListener;
import net.openhft.chronicle.queue.micros.OrderListener;
import net.openhft.chronicle.queue.micros.OrderManager;
import net.openhft.chronicle.queue.micros.Side;
import net.openhft.chronicle.queue.micros.SidedMarketDataCombiner;
import net.openhft.chronicle.queue.micros.SidedMarketDataListener;
import net.openhft.chronicle.queue.micros.SidedPrice;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodReader;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class OrderManagerTest {
    @Test
    public void testOnOrderIdea() {
        OrderListener listener = (OrderListener)EasyMock.createMock(OrderListener.class);
        listener.onOrder(new Order("EURUSD", Side.Buy, 1.1167, 1000000.0));
        EasyMock.replay((Object[])new Object[]{listener});
        OrderManager orderManager = new OrderManager(listener);
        SidedMarketDataCombiner combiner = new SidedMarketDataCombiner(orderManager);
        orderManager.onOrderIdea(new OrderIdea("EURUSD", Side.Buy, 1.118, 2000000.0));
        combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789000L, Side.Sell, 1.1172, 2000000.0));
        combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789100L, Side.Buy, 1.116, 2000000.0));
        combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789100L, Side.Buy, 1.1167, 2000000.0));
        orderManager.onOrderIdea(new OrderIdea("EURUSD", Side.Buy, 1.1165, 1000000.0));
        EasyMock.verify((Object[])new Object[]{listener});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithQueue() {
        File queuePath = new File(OS.TARGET, "testWithQueue-" + System.nanoTime());
        try {
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)queuePath).testBlockSize().build();){
                OrderIdeaListener orderManager = (OrderIdeaListener)queue.acquireAppender().methodWriter(OrderIdeaListener.class, new Class[]{MarketDataListener.class});
                SidedMarketDataCombiner combiner = new SidedMarketDataCombiner((MarketDataListener)((Object)orderManager));
                orderManager.onOrderIdea(new OrderIdea("EURUSD", Side.Buy, 1.118, 2000000.0));
                combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789000L, Side.Sell, 1.1172, 2000000.0));
                combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789100L, Side.Buy, 1.116, 2000000.0));
                combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789100L, Side.Buy, 1.1167, 2000000.0));
                orderManager.onOrderIdea(new OrderIdea("EURUSD", Side.Buy, 1.1165, 1000000.0));
            }
            OrderListener listener = (OrderListener)EasyMock.createMock(OrderListener.class);
            listener.onOrder(new Order("EURUSD", Side.Buy, 1.1167, 1000000.0));
            EasyMock.replay((Object[])new Object[]{listener});
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)queuePath).testBlockSize().build();){
                OrderManager orderManager = new OrderManager(listener);
                MethodReader reader = queue.createTailer().methodReader(new Object[]{orderManager});
                for (int i = 0; i < 5; ++i) {
                    Assert.assertTrue((boolean)reader.readOne());
                }
                Assert.assertFalse((boolean)reader.readOne());
            }
            EasyMock.verify((Object[])new Object[]{listener});
        }
        finally {
            try {
                IOTools.shallowDeleteDirWithFiles((File)queuePath);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithQueueHistory() {
        File queuePath = new File(OS.TARGET, "testWithQueueHistory-" + System.nanoTime());
        File queuePath2 = new File(OS.TARGET, "testWithQueueHistory-down-" + System.nanoTime());
        try {
            try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)queuePath).testBlockSize().build();){
                OrderIdeaListener orderManager = (OrderIdeaListener)out.acquireAppender().methodWriterBuilder(OrderIdeaListener.class).addInterface(MarketDataListener.class).recordHistory(true).get();
                SidedMarketDataCombiner combiner = new SidedMarketDataCombiner((MarketDataListener)((Object)orderManager));
                orderManager.onOrderIdea(new OrderIdea("EURUSD", Side.Buy, 1.118, 2000000.0));
                combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789000L, Side.Sell, 1.1172, 2000000.0));
                combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789100L, Side.Buy, 1.116, 2000000.0));
                combiner.onSidedPrice(new SidedPrice("EURUSD", 123456789100L, Side.Buy, 1.1167, 2000000.0));
                orderManager.onOrderIdea(new OrderIdea("EURUSD", Side.Buy, 1.1165, 1000000.0));
            }
            var4_5 = null;
            try (SingleChronicleQueue in = SingleChronicleQueueBuilder.binary((File)queuePath).testBlockSize().sourceId(1).build();
                 SingleChronicleQueue out2 = SingleChronicleQueueBuilder.binary((File)queuePath2).testBlockSize().build();){
                OrderListener listener = (OrderListener)out2.acquireAppender().methodWriterBuilder(OrderListener.class).recordHistory(true).get();
                OrderManager orderManager = new OrderManager(listener);
                MethodReader reader = in.createTailer().methodReader(new Object[]{orderManager});
                for (int i = 0; i < 5; ++i) {
                    Assert.assertTrue((boolean)reader.readOne());
                }
                Assert.assertFalse((boolean)reader.readOne());
            }
            catch (Throwable out2) {
                var4_5 = out2;
                throw out2;
            }
            in = SingleChronicleQueueBuilder.binary((File)queuePath2).testBlockSize().sourceId(2).build();
            var4_5 = null;
            try {
                MethodReader reader = in.createTailer().methodReader(new Object[]{order -> {
                    MessageHistory x = MessageHistory.get();
                    System.out.println(x);
                    Assert.assertEquals((long)1L, (long)x.sourceId(0));
                    Assert.assertEquals((long)2L, (long)x.sourceId(1));
                    Assert.assertEquals((long)4L, (long)x.timings());
                }});
                Assert.assertTrue((boolean)reader.readOne());
                Assert.assertFalse((boolean)reader.readOne());
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (var4_5 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        finally {
            try {
                IOTools.shallowDeleteDirWithFiles((File)queuePath);
                IOTools.shallowDeleteDirWithFiles((File)queuePath2);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartingAService() {
        File queuePath = new File(OS.TARGET, "testRestartingAService-" + System.nanoTime());
        File queuePath2 = new File(OS.TARGET, "testRestartingAService-down-" + System.nanoTime());
        try {
            try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)queuePath).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                SidedMarketDataListener combiner = (SidedMarketDataListener)out.acquireAppender().methodWriterBuilder(SidedMarketDataListener.class).recordHistory(true).get();
                combiner.onSidedPrice(new SidedPrice("EURUSD1", 123456789000L, Side.Sell, 1.1172, 2000000.0));
                combiner.onSidedPrice(new SidedPrice("EURUSD2", 123456789100L, Side.Buy, 1.116, 2000000.0));
                for (int i = 2; i < 10; i += 2) {
                    combiner.onSidedPrice(new SidedPrice("EURUSD3", 123456789100L, Side.Sell, 1.1173, 2500000.0));
                    combiner.onSidedPrice(new SidedPrice("EURUSD4", 123456789100L, Side.Buy, 1.1167, 1500000.0));
                }
            }
            for (int i = 0; i < 10; ++i) {
                try (SingleChronicleQueue in = SingleChronicleQueueBuilder.binary((File)queuePath).testBlockSize().sourceId(1).build();
                     SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)queuePath2).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                    ExcerptAppender excerptAppender = out.acquireAppender();
                    MarketDataListener mdListener = (MarketDataListener)excerptAppender.methodWriterBuilder(MarketDataListener.class).recordHistory(true).get();
                    SidedMarketDataCombiner combiner = new SidedMarketDataCombiner(mdListener);
                    ExcerptTailer tailer = in.createTailer().afterLastWritten((ChronicleQueue)out);
                    Assert.assertEquals((long)i, (long)in.rollCycle().toSequenceNumber(tailer.index()));
                    MethodReader reader = tailer.methodReader(new Object[]{combiner});
                    Assert.assertTrue((String)("i: " + i), (boolean)reader.readOne());
                    continue;
                }
            }
        }
        finally {
            try {
                IOTools.shallowDeleteDirWithFiles((File)queuePath);
                IOTools.shallowDeleteDirWithFiles((File)queuePath2);
            }
            catch (Exception exception) {}
        }
    }
}

