/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.queue.micros.Order;
import net.openhft.chronicle.queue.micros.Side;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SingleCQFormatTest {
    private int appendMode;
    private ThreadDump threadDump;

    private static void assertHexEquals(long a, long b) {
        if (a != b) {
            Assert.assertEquals((String)(Long.toHexString(a) + " != " + Long.toHexString(b)), (long)a, (long)b);
        }
    }

    private static void expected(@NotNull ExcerptTailer tailer, String expected) {
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertTrue((boolean)dc.isPresent());
            VanillaBytes bytes2 = Bytes.allocateDirect((long)128L);
            dc.wire().copyTo((WireOut)new TextWire((Bytes)bytes2));
            Assert.assertEquals((Object)expected, (Object)bytes2.toString());
        }
    }

    @Test
    public void testEmptyDirectory() {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)queue.firstCycle());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)queue.lastCycle());
        queue.close();
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    @Test
    public void testInvalidFile() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700102.cq4"), (long)262144L);
        bytes.write8bit("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>");
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();
        Assert.assertEquals((long)1L, (long)queue.firstCycle());
        Assert.assertEquals((long)1L, (long)queue.lastCycle());
        try {
            ExcerptTailer tailer = queue.createTailer();
            tailer.toEnd();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"java.io.StreamCorruptedException: Unexpected magic number 783f3c37", (Object)e.toString());
        }
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testNoHeader() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();
        this.testQueue(queue);
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TimeoutException.class)
    @Ignore(value="Long running")
    public void testDeadHeader() throws FileNotFoundException {
        File dir = Utils.tempDir("testDeadHeader");
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        bytes.writeInt(-1073741824);
        bytes.release();
        SingleChronicleQueue queue = null;
        try {
            queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().blockSize(262144).build();
            this.testQueue(queue);
        }
        catch (Throwable throwable) {
            Closeable.closeQuietly(queue);
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
            throw throwable;
        }
        Closeable.closeQuietly((Object)queue);
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    private void testQueue(@NotNull SingleChronicleQueue queue) {
        ExcerptTailer tailer = queue.createTailer();
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
    }

    @Test
    public void testCompleteHeader() throws FileNotFoundException {
        File dir = Utils.tempDir("testCompleteHeader");
        dir.mkdirs();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> {
                w.write(() -> "wireType").object((Object)WireType.BINARY);
                w.write(() -> "writePosition").int64forBinding(0L);
                w.write(() -> "roll").typedMarshallable((WriteMarshallable)new SCQRoll((RollCycle)RollCycles.DAILY, 0L));
                w.write(() -> "indexing").typedMarshallable((WriteMarshallable)new SCQIndexing(WireType.BINARY, 32768, 32));
                w.write(() -> "lastAcknowledgedIndexReplicated").int64forBinding(0L);
            });
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: !int 32768,\n    indexSpacing: 32,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: 0\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();
        this.testQueue(queue);
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCompleteHeader2() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101-02.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typedMarshallable((WriteMarshallable)new SingleChronicleQueueStore((RollCycle)RollCycles.HOURLY, WireType.BINARY, bytes, 3600000L, 4096, 4, (StoreRecovery)new TimedStoreRecovery(WireType.BINARY), -1));
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 3600000,\n    format: yyyyMMdd-HH,\n    epoch: !int 3600000\n  },\n  indexing: !SCQSIndexing {\n    indexCount: !short 4096,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: !byte -1\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).rollCycle((RollCycle)RollCycles.HOURLY).build();
        this.testQueue(queue);
        Assert.assertEquals((long)2L, (long)queue.firstCycle());
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncompleteHeader() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> w.write(() -> "wireType").object((Object)WireType.BINARY));
        }
        bytes.release();
        try {
            var5_7 = null;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).build();){
                this.testQueue(queue);
                Assert.fail();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.IORuntimeException: net.openhft.chronicle.core.io.IORuntimeException: field writePosition required", (Object)e.toString());
        }
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testMyData() {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{MyData.class});
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(262144).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                MyData name = new MyData("name", 12345L, 1.2, 111);
                System.out.println((Object)name);
                name.writeMarshallable((WireOut)dc.wire());
                MyData name2 = new MyData("name2", 12346L, 1.3, 112);
                System.out.println((Object)name2);
                name2.writeMarshallable((WireOut)dc.wire());
            }
            String dump = queue.dump();
            Assert.assertTrue((String)dump, (boolean)dump.contains("index: [\n  # length: 8, used: 1\n  576,\n  0, 0, 0, 0, 0, 0, 0\n]"));
        }
    }

    @Test
    public void testTwoMessages() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        RollCycles cycle = RollCycles.DAILY;
        MappedBytes mappedBytes = MappedBytes.mappedBytes((File)new File(dir, "19700102.cq4"), (long)262144L);
        BinaryWire wire = new BinaryWire((Bytes)mappedBytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typedMarshallable((WriteMarshallable)new SingleChronicleQueueStore((RollCycle)cycle, WireType.BINARY, mappedBytes, 0L, cycle.defaultIndexCount(), cycle.defaultIndexSpacing(), (StoreRecovery)new TimedStoreRecovery(WireType.BINARY), -1));
        }
        dc = wire.writingDocument(false);
        var6_7 = null;
        try {
            dc.wire().writeEventName((CharSequence)"msg").text("Hello world");
        }
        catch (Throwable throwable) {
            var6_7 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var6_7 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var6_7.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
        dc = wire.writingDocument(false);
        var6_7 = null;
        try {
            dc.wire().writeEventName((CharSequence)"msg").text("Also hello world");
        }
        catch (Throwable throwable) {
            var6_7 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var6_7 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var6_7.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: !short 16384,\n    indexSpacing: 16,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: !byte -1\n}\n# position: 370, header: 0\n--- !!data #binary\nmsg: Hello world\n# position: 391, header: 1\n--- !!data #binary\nmsg: Also hello world\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)mappedBytes.readPosition(0L)));
        mappedBytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)cycle).blockSize(262144).build();
        ExcerptTailer tailer = queue.createTailer();
        this.readTwo(tailer);
        tailer.toStart();
        this.readTwo(tailer);
        tailer.direction(TailerDirection.NONE).toStart();
        long start = queue.firstIndex();
        Assert.assertEquals((long)start, (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Hello world\n");
        Assert.assertEquals((long)start, (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Hello world\n");
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testWritingThreeMessages() throws FileNotFoundException {
        int m = 0;
        while (m <= 2) {
            this.appendMode = m++;
            File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
            dir.mkdir();
            SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).indexCount(8).indexSpacing(1).build();
            long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
            this.appendMessage(queue, start, "Hello World");
            String expected1 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 576,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  576,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 327080 bytes remaining\n";
            this.checkFileContents(dir.listFiles()[0], expected1);
            this.appendMessage(queue, start + 1L, "Another Hello World");
            String expected2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 596,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  596,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 596, header: 1\n--- !!data #binary\nmsg: Another Hello World\n...\n# 327052 bytes remaining\n";
            this.checkFileContents(dir.listFiles()[0], expected2);
            this.appendMessage(queue, start + 2L, "Bye for now");
            String expected = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 624,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 3\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  576,\n  596,\n  624,\n  0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 596, header: 1\n--- !!data #binary\nmsg: Another Hello World\n# position: 624, header: 2\n--- !!data #binary\nmsg: Bye for now\n...\n# 327032 bytes remaining\n";
            this.checkFileContents(dir.listFiles()[0], expected);
        }
    }

    public void checkFileContents(@NotNull File file, String expected) throws FileNotFoundException {
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)262144L);
        bytes.readLimit(bytes.realCapacity());
        Assert.assertEquals((Object)expected, (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes));
        bytes.release();
    }

    @Test
    public void testWritingTwentyMessagesTinyIndex() throws FileNotFoundException, TimeoutException {
        for (int spacing : new int[]{1, 2, 4}) {
            File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
            dir.mkdir();
            SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).indexCount(8).indexSpacing(spacing).build();
            long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertFalse((boolean)tailer.moveToIndex(start));
            this.appendMessage(queue, start, "Hello World");
            String expected00 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 576,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  576,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 327080 bytes remaining\n";
            this.checkFileContents(dir.listFiles()[0], expected00.replace("indexSpacing: 1", "indexSpacing: " + spacing).replace("lastIndex: 1", "lastIndex: " + spacing));
            Assert.assertTrue((boolean)tailer.moveToIndex(start));
            for (int i = 1; i < 19; ++i) {
                Assert.assertFalse((boolean)tailer.moveToIndex(start + (long)i));
                this.appendMessage(queue, start + (long)i, "Another Hello World " + (i + 1));
                Assert.assertTrue((boolean)tailer.moveToIndex(start + (long)i));
            }
            Assert.assertFalse((boolean)tailer.moveToIndex(start + 19L));
            this.appendMessage(queue, start + 19L, "Bye for now");
            Assert.assertTrue((boolean)tailer.moveToIndex(start + 19L));
            Assert.assertFalse((boolean)tailer.moveToIndex(start + 20L));
            String expected1 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 1344,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  480,\n  836,\n  1183,\n  0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  576,\n  596,\n  626,\n  656,\n  686,\n  716,\n  746,\n  776\n]\n# position: 576, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 596, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 626, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 656, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 686, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 716, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 746, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 776, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 806, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 836, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  806,\n  928,\n  960,\n  991,\n  1024,\n  1055,\n  1088,\n  1119\n]\n# position: 928, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 960, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 991, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 1024, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 1055, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 1088, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1119, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1152, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1183, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 4\n  1152,\n  1280,\n  1311,\n  1344,\n  0, 0, 0, 0\n]\n# position: 1280, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1311, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1344, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 326312 bytes remaining\n";
            String expected2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 1247,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 2\n  480,\n  1088,\n  0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  576,\n  626,\n  686,\n  746,\n  806,\n  867,\n  929,\n  991\n]\n# position: 576, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 596, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 626, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 656, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 686, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 716, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 746, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 776, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 806, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 836, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 867, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 898, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 929, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 960, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 991, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1024, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1055, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1088, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  1055,\n  1216,\n  0, 0, 0, 0, 0, 0\n]\n# position: 1184, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1216, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1247, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 326409 bytes remaining\n";
            String expected3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 1152,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 4,\n    index2Index: 377,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 5\n  576,\n  686,\n  806,\n  929,\n  1055,\n  0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 596, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 626, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 656, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 686, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 716, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 746, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 776, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 806, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 836, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 867, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 898, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 929, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 960, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 991, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1024, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1055, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1088, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1119, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1152, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 326504 bytes remaining\n";
            String expected = spacing == 1 ? expected1 : (spacing == 2 ? expected2 : expected3);
            this.checkFileContents(dir.listFiles()[0], expected);
        }
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void resetAppendMode() {
        this.appendMode = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void appendMessage(@NotNull SingleChronicleQueue queue, long expectedIndex, String msg) {
        appender = queue.acquireAppender();
        switch (this.appendMode) {
            case 1: {
                appender.writeDocument((WriteMarshallable)LambdaMetafactory.metafactory(null, null, null, (Lnet/openhft/chronicle/wire/WireOut;)V, lambda$appendMessage$13(java.lang.String net.openhft.chronicle.wire.WireOut ), (Lnet/openhft/chronicle/wire/WireOut;)V)((String)msg));
                break;
            }
            case 2: {
                bytes = Bytes.elasticByteBuffer();
                new BinaryWire(bytes).write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$14(), ()Ljava/lang/CharSequence;)()).text(msg);
                appender.writeBytes(bytes);
                break;
            }
            default: {
                dc = appender.writingDocument();
                var8_8 = null;
                wire = dc.wire();
                wire.write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$15(), ()Ljava/lang/CharSequence;)()).text(msg);
                if (dc == null) break;
                if (var8_8 == null) ** GOTO lbl27
                try {
                    dc.close();
                }
                catch (Throwable var9_10) {
                    var8_8.addSuppressed(var9_10);
                }
                break;
lbl27:
                // 1 sources

                dc.close();
                break;
                catch (Throwable var9_11) {
                    try {
                        var8_8 = var9_11;
                        throw var9_11;
                    }
                    catch (Throwable var10_12) {
                        if (dc != null) {
                            if (var8_8 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable var11_13) {
                                    var8_8.addSuppressed(var11_13);
                                }
                            } else {
                                dc.close();
                            }
                        }
                        throw var10_12;
                    }
                }
            }
        }
        index = appender.lastIndexAppended();
        SingleCQFormatTest.assertHexEquals(expectedIndex, index);
    }

    public void readTwo(@NotNull ExcerptTailer tailer) {
        long start = RollCycles.DAILY.toIndex(1, 0L);
        Assert.assertEquals((long)start, (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Hello world\n");
        Assert.assertEquals((long)(start + 1L), (long)tailer.index());
        SingleCQFormatTest.expected(tailer, "msg: Also hello world\n");
        Assert.assertEquals((long)(start + 2L), (long)tailer.index());
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
        Assert.assertEquals((long)(start + 2L), (long)tailer.index());
    }

    @Test
    public void writeMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("abc", "def");
        map.put("hello", "world");
        map.put("number", 1L);
        map.put("double", 1.28);
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(262144).rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeMap(map);
            map.put("abc", "aye-bee-see");
            appender.writeMap(map);
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 636,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  636,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nabc: def\ndouble: 1.28\nhello: world\nnumber: 1\n# position: 636, header: 1\n--- !!data #binary\nabc: aye-bee-see\ndouble: 1.28\nhello: world\nnumber: 1\n...\n# 326972 bytes remaining\n", (Object)queue.dump());
            ExcerptTailer tailer = queue.createTailer();
            Map map2 = tailer.readMap();
            Map map3 = tailer.readMap();
            Assert.assertEquals((Object)"{abc=def, double=1.28, hello=world, number=1}", (Object)map2.toString());
            Assert.assertEquals((Object)"{abc=aye-bee-see, double=1.28, hello=world, number=1}", (Object)map3.toString());
            Assert.assertNull((Object)tailer.readMap());
        }
    }

    @Test
    public void writeMarshallable() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Order.class});
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(262144).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((WriteMarshallable)new Order("Symbol", Side.Buy, 1.2345, 1000000.0));
            appender.writeDocument(w -> w.write((CharSequence)"newOrder").object((Object)new Order("Symbol2", Side.Sell, 2.999, 1.0E7)));
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 640,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  576,\n  640,\n  0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data #binary\nsymbol: Symbol\nside: Buy\nlimitPrice: 1.2345\nquantity: 1000000.0\n# position: 640, header: 1\n--- !!data #binary\nnewOrder: !Order {\n  symbol: Symbol2,\n  side: Sell,\n  limitPrice: 2.999,\n  quantity: 10000000.0\n}\n...\n# 326952 bytes remaining\n", (Object)queue.dump());
        }
    }

    @Test
    public void testWritingIndex() {
        String dir = OS.TARGET + "/testWritingIndex-" + System.nanoTime();
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single((String)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(262144).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"msg-1");
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 576,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  480,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  576,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 576, header: 0\n--- !!data\nmsg-1\n...\n# 327091 bytes remaining\n", (Object)queue.dump());
            for (int i = 1; i <= 16; ++i) {
                appender.writeText((CharSequence)("msg-" + i));
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 821,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 377,\n    lastIndex: 17\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  480,\n  657,\n  831,\n  0, 0, 0, 0, 0\n]\n# position: 480, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  576,\n  585,\n  594,\n  603,\n  612,\n  621,\n  630,\n  639\n]\n# position: 576, header: 0\n--- !!data\nmsg-1\n# position: 585, header: 1\n--- !!data\nmsg-1\n# position: 594, header: 2\n--- !!data\nmsg-2\n# position: 603, header: 3\n--- !!data\nmsg-3\n# position: 612, header: 4\n--- !!data\nmsg-4\n# position: 621, header: 5\n--- !!data\nmsg-5\n# position: 630, header: 6\n--- !!data\nmsg-6\n# position: 639, header: 7\n--- !!data\nmsg-7\n# position: 648, header: 8\n--- !!data\nmsg-8\n# position: 657, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  648,\n  752,\n  761,\n  771,\n  781,\n  791,\n  801,\n  811\n]\n# position: 752, header: 9\n--- !!data\nmsg-9\n# position: 761, header: 10\n--- !!data\nmsg-10\n# position: 771, header: 11\n--- !!data\nmsg-11\n# position: 781, header: 12\n--- !!data\nmsg-12\n# position: 791, header: 13\n--- !!data\nmsg-13\n# position: 801, header: 14\n--- !!data\nmsg-14\n# position: 811, header: 15\n--- !!data\nmsg-15\n# position: 821, header: 16\n--- !!data\nmsg-16\n# position: 831, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  821,\n  0, 0, 0, 0, 0, 0, 0\n]\n...\n# 326748 bytes remaining\n", (Object)queue.dump());
        }
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$15() {
        return "msg";
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$14() {
        return "msg";
    }

    private static /* synthetic */ void lambda$appendMessage$13(String msg, WireOut w) {
        w.write(() -> "msg").text(msg);
    }

    static {
        SingleChronicleQueueBuilder.init();
    }

    private static class MyData
    extends AbstractMarshallable {
        final String name;
        final long num;
        final double d;
        final int counter;

        MyData(String name, long num, double d, int counter) {
            this.name = name;
            this.num = num;
            this.d = d;
            this.counter = counter;
        }
    }
}

