/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.Utils;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wires;
import org.junit.Assert;
import org.junit.Test;

public class RollCycleMultiThreadTest {
    @Test
    public void testRead1() throws Exception {
        File path = Utils.tempDir(this.getClass().getSimpleName());
        TestTimeProvider timeProvider = new TestTimeProvider();
        SingleChronicleQueue queue0 = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();
        ParallelQueueObserver observer = new ParallelQueueObserver((ChronicleQueue)queue0);
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            Assert.assertEquals((long)0L, (long)scheduledExecutorService.submit(observer::call).get().intValue());
            timeProvider.add(TimeUnit.DAYS.toMillis(2L));
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("Day 3 data");
            }
            Assert.assertEquals((long)1L, (long)scheduledExecutorService.submit(observer::call).get().intValue());
            Assert.assertEquals((long)1L, (long)observer.documentsRead);
        }
    }

    @Test
    public void testRead2() throws Exception {
        File path = Utils.tempDir("testRead2");
        TestTimeProvider timeProvider = new TestTimeProvider();
        SingleChronicleQueue queue0 = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();
        ParallelQueueObserver observer = new ParallelQueueObserver((ChronicleQueue)queue0);
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("Day 1 data");
            }
            Assert.assertEquals((long)1L, (long)((Integer)scheduledExecutorService.submit(observer).get()).intValue());
            timeProvider.add(TimeUnit.DAYS.toMillis(2L));
            dc = appender.writingDocument();
            var10_12 = null;
            try {
                dc.wire().write().text("Day 3 data");
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Assert.assertEquals((long)2L, (long)((Integer)scheduledExecutorService.submit(observer).get()).intValue());
            System.out.println(queue.dump());
            Assert.assertEquals((long)2L, (long)observer.documentsRead);
        }
    }

    private class ParallelQueueObserver
    implements Callable,
    StoreFileListener {
        private final ExcerptTailer tailer;
        volatile int documentsRead = 0;

        ParallelQueueObserver(ChronicleQueue queue) {
            this.tailer = queue.createTailer();
        }

        public void onAcquired(int cycle, File file) {
            System.out.println("Acquiring " + file);
        }

        public void onReleased(int cycle, File file) {
            System.out.println("Releasing " + file);
        }

        public synchronized Integer call() throws Exception {
            try (DocumentContext dc = this.tailer.readingDocument();){
                System.out.println("index=" + Long.toHexString(dc.index()));
                if (!dc.isPresent()) {
                    Integer n = this.documentsRead;
                    return n;
                }
                StringBuilder sb = Wires.acquireStringBuilder();
                dc.wire().bytes().parse8bit((Appendable)sb, (StopCharTester)StopCharTesters.ALL);
                String readText = sb.toString();
                if (Objects.equals(sb, "")) {
                    Integer n = this.documentsRead;
                    return n;
                }
                System.out.println("Read a document " + readText);
                ++this.documentsRead;
            }
            return this.documentsRead;
        }
    }

    private class TestTimeProvider
    implements TimeProvider {
        private volatile long addInMs = 0L;

        private TestTimeProvider() {
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis() + this.addInMs;
        }

        void add(long addInMs) {
            this.addInMs = addInMs;
        }
    }
}

