/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherStateTest {
    @Test
    public void pretouch() throws Exception {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 65536, record, () -> false);
        ps.pretouch(null);
        ps.pretouch(null);
        Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 4096 as the underlying MappedBytes changed.\ntouchPage 4096\ntouchPage 8192\ntouchPage 12288\ntouchPage 16384\ntouchPage 20480\ntouchPage 24576\ntouchPage 28672\ntouchPage 32768\ntouchPage 36864\ntouchPage 40960\ntouchPage 45056\ntouchPage 49152\ntouchPage 53248\ntouchPage 57344\ntouchPage 61440\ntouchPage 65536\ntouchPage 69632\ndebug pretouch for only 0 of 17\ndebug none: Advanced 4 KB between pretouch() and 4 KB while mapping of 64 KB.\n", (Object)record.toString());
    }

    @Test
    public void pretouchLeap() throws Exception {
        long[] pos = new long[]{0x100000L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 16384, record, () -> true);
        ps.pretouch(null);
        for (int i = 0; i < 4; ++i) {
            ps.pretouch(null);
        }
        ps.pretouch(null);
        Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 1052672 as the underlying MappedBytes changed.\ntouchPage 1052672\ntouchPage 1056768\ntouchPage 1060864\ntouchPage 1064960\ntouchPage 1069056\ndebug none: Advanced 4 KB between pretouch() and 4 KB while mapping of 16 KB.\ntouchPage 1073152\ntouchPage 1077248\ndebug none: Advanced 8 KB between pretouch() and 4 KB while mapping of 16 KB.\ntouchPage 1081344\ntouchPage 1085440\ndebug none: Advanced 8 KB between pretouch() and 4 KB while mapping of 16 KB.\ntouchPage 1089536\ntouchPage 1093632\ndebug none: Advanced 8 KB between pretouch() and 4 KB while mapping of 16 KB.\ntouchPage 1097728\ntouchPage 1101824\ndebug none: Advanced 8 KB between pretouch() and 4 KB while mapping of 16 KB.\n", (Object)record.toString());
    }

    @Test
    public void pretouchLongBreak() throws Exception {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 1024L;
            return pos[0];
        }, 16384, record, () -> true);
        for (int i = 0; i <= 20; ++i) {
            record.append("pos: " + pos[0] + ", i:" + i + "\n");
            ps.pretouch(null);
        }
        Assert.assertEquals((Object)"pos: 0, i:0\ndebug none - Reset pretoucher to pos 1024 as the underlying MappedBytes changed.\npos: 1024, i:1\ntouchPage 0\ntouchPage 4096\ntouchPage 8192\ntouchPage 12288\ntouchPage 16384\ndebug none: Advanced 1 KB between pretouch() and 1 KB while mapping of 16 KB.\npos: 3072, i:2\npos: 4096, i:3\ntouchPage 20480\ndebug none: Advanced 3 KB between pretouch() and 1 KB while mapping of 16 KB.\npos: 6144, i:4\npos: 7168, i:5\npos: 8192, i:6\ntouchPage 24576\ndebug none: Advanced 4 KB between pretouch() and 1 KB while mapping of 16 KB.\npos: 10240, i:7\npos: 11264, i:8\npos: 12288, i:9\ntouchPage 28672\ndebug none: Advanced 4 KB between pretouch() and 1 KB while mapping of 16 KB.\npos: 14336, i:10\npos: 15360, i:11\npos: 16384, i:12\ntouchPage 32768\ndebug none: Advanced 4 KB between pretouch() and 1 KB while mapping of 16 KB.\npos: 18432, i:13\npos: 19456, i:14\npos: 20480, i:15\ntouchPage 36864\ndebug none: Advanced 4 KB between pretouch() and 1 KB while mapping of 16 KB.\npos: 22528, i:16\npos: 23552, i:17\npos: 24576, i:18\ntouchPage 40960\ndebug none: Advanced 4 KB between pretouch() and 1 KB while mapping of 16 KB.\npos: 26624, i:19\npos: 27648, i:20\n", (Object)record.toString());
    }

    class DummyPretoucherState
    extends PretoucherState {
        private final BooleanSupplier touched;
        StringBuilder record;

        DummyPretoucherState(LongSupplier posSupplier, int headRoom, StringBuilder record, BooleanSupplier touched) {
            super(posSupplier, headRoom);
            this.record = record;
            this.touched = touched;
        }

        protected void debug(String message) {
            this.record.append("debug ").append(message).append("\n");
        }

        protected boolean touchPage(MappedBytes bytes, long offset) {
            this.record.append("touchPage ").append(offset).append("\n");
            return this.touched.getAsBoolean();
        }
    }
}

