/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.Utils;
import org.junit.Assert;
import org.junit.Test;

public class RollingChronicleQueueTest {
    @Test
    public void testCountExcerptsWhenTheCycleIsRolled() throws Exception {
        AtomicLong time = new AtomicLong();
        File name = Utils.tempDir("testCountExcerptsWhenTheCycleIsRolled");
        SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)name).testBlockSize().timeProvider(time::get).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();
        ExcerptAppender appender = q.acquireAppender();
        time.set(0L);
        appender.writeText((CharSequence)"1. some  text");
        long start = appender.lastIndexAppended();
        appender.writeText((CharSequence)"2. some more text");
        appender.writeText((CharSequence)"3. some more text");
        time.set(TimeUnit.DAYS.toMillis(1L));
        appender.writeText((CharSequence)"4. some text - first cycle");
        time.set(TimeUnit.DAYS.toMillis(2L));
        time.set(TimeUnit.DAYS.toMillis(3L));
        time.set(TimeUnit.DAYS.toMillis(4L));
        appender.writeText((CharSequence)"5. some text - second cycle");
        appender.writeText((CharSequence)"some more text");
        long end = appender.lastIndexAppended();
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 742,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 4\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 2\n  704,\n  742,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: 0\n--- !!data\n1. some  text\n# position: 721, header: 1\n--- !!data\n2. some more text\n# position: 742, header: 2\n--- !!data\n3. some more text\n# position: 763, header: 2 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 326913 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 704,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  704,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: 0\n--- !!data\n4. some text - first cycle\n# position: 734, header: 0 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 326942 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: 735,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 377,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 377, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  704,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 704, header: 0\n--- !!data\n5. some text - second cycle\n# position: 735, header: 1\n--- !!data\nsome more text\n...\n# 326923 bytes remaining\n", (Object)q.dump());
        Assert.assertEquals((long)5L, (long)q.countExcerpts(start, end));
    }
}

