/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.JDBCResult;

class CountingJDBCResult
implements JDBCResult {
    private final AtomicLong queries;
    private final AtomicLong updates;

    public CountingJDBCResult(AtomicLong queries, AtomicLong updates) {
        this.queries = queries;
        this.updates = updates;
    }

    public void queryResult(List<String> columns, List<List<Object>> rows, String query, Object ... args) {
        System.out.println("query " + query + " returned " + columns);
        for (List<Object> row : rows) {
            System.out.println("\t" + row);
        }
        this.queries.incrementAndGet();
    }

    public void queryThrown(Throwable t, String query, Object ... args) {
        throw Jvm.rethrow((Throwable)t);
    }

    public void updateResult(long count, String update, Object ... args) {
        this.updates.incrementAndGet();
    }

    public void updateThrown(Throwable t, String update, Object ... args) {
        throw Jvm.rethrow((Throwable)t);
    }
}

