/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import org.junit.Assert;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class ChronicleQueueMicrobench {
    protected static final int DEFAULT_WARMUP_ITERATIONS = 10;
    protected static final int DEFAULT_MEASURE_ITERATIONS = 10;
    private static final String[] EMPTY_JVM_ARGS = new String[0];
    private static final String[] BASE_JVM_ARGS = new String[]{"-server", "-dsa", "-da", "-ea:net.openhft...", "-XX:+AggressiveOpts", "-XX:+UseBiasedLocking", "-XX:+UseFastAccessorMethods", "-XX:+OptimizeStringConcat", "-XX:+HeapDumpOnOutOfMemoryError"};

    private ChainedOptionsBuilder newOptionsBuilder() {
        String className = this.getClass().getSimpleName();
        ChainedOptionsBuilder runnerOptions = new OptionsBuilder().include(".*" + className + ".*").jvmArgs(BASE_JVM_ARGS).jvmArgsAppend(this.jvmArgs());
        if (this.getWarmupIterations() > 0) {
            runnerOptions.warmupIterations(this.getWarmupIterations());
        }
        if (this.getMeasureIterations() > 0) {
            runnerOptions.measurementIterations(this.getMeasureIterations());
        }
        if (null != this.getReportDir()) {
            String filePath = this.getReportDir() + className + ".json";
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            } else {
                file.getParentFile().mkdirs();
            }
            runnerOptions.resultFormat(ResultFormatType.JSON);
            runnerOptions.result(filePath);
        }
        return runnerOptions;
    }

    private String[] jvmArgs() {
        return EMPTY_JVM_ARGS;
    }

    private int getWarmupIterations() {
        return Integer.getInteger("warmupIterations", -1);
    }

    private int getMeasureIterations() {
        return Integer.getInteger("measureIterations", -1);
    }

    private String getReportDir() {
        return System.getProperty("perfReportDir");
    }

    public static void handleUnexpectedException(Throwable t) {
        Assert.assertNull((Object)t);
    }

    public static void main(String[] args) throws RunnerException {
        new Runner(new ChronicleQueueMicrobench().newOptionsBuilder().build()).run();
    }
}

