/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.MethodReader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleQueueMethodsWithoutParameters
extends ChronicleQueueTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ChronicleQueueMethodsWithoutParameters.class);

    @Test
    public void test() throws IOException, InterruptedException {
        File file = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            SomeListener someListener = (SomeListener)queue.acquireAppender().methodWriter(SomeListener.class, new Class[0]);
            SomeManager someManager = new SomeManager();
            MethodReader reader = queue.createTailer().methodReader(new Object[]{someManager});
            LOG.debug("Writing to queue");
            someListener.methodWithOneParam(1);
            someListener.methodWithoutParams();
            LOG.debug("Reading from queue");
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertFalse((boolean)reader.readOne());
            Assert.assertTrue((boolean)someManager.methodWithOneParamInvoked);
            Assert.assertTrue((boolean)someManager.methodWithoutParamsInvoked);
            LOG.warn(queue.dump());
        }
    }

    public static class SomeManager
    implements SomeListener {
        public boolean methodWithoutParamsInvoked = false;
        public boolean methodWithOneParamInvoked = false;

        @Override
        public void methodWithoutParams() {
            this.methodWithoutParamsInvoked = true;
        }

        @Override
        public void methodWithOneParam(int i) {
            this.methodWithOneParamInvoked = true;
        }
    }

    public static interface SomeListener {
        public void methodWithoutParams();

        public void methodWithOneParam(int var1);
    }
}

