/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Ignore;
import org.junit.Test;

public class ChronicleQueueLatencyDistribution
extends ChronicleQueueTestBase {
    @Ignore(value="long running")
    @Test
    public void test() throws IOException, InterruptedException {
        Histogram histogram = new Histogram();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)this.getTmpDir()).blockSize(0x8000000).build();
        ExcerptAppender appender = queue.acquireAppender();
        ExcerptTailer tailer = queue.createTailer();
        Thread tailerThread = new Thread(() -> {
            MyReadMarshallable myReadMarshallable = new MyReadMarshallable(histogram);
            AffinityLock lock = null;
            try {
                if (Boolean.getBoolean("enableTailerAffinity")) {
                    lock = Affinity.acquireLock();
                }
                try {
                    while (true) {
                        tailer.readDocument((ReadMarshallable)myReadMarshallable);
                    }
                }
                catch (Exception e) {
                    if (lock != null) {
                        lock.release();
                    }
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    lock.release();
                }
                throw throwable;
            }
        });
        Thread appenderThread = new Thread(() -> {
            AffinityLock lock = null;
            try {
                if (Boolean.getBoolean("enableAppenderAffinity")) {
                    lock = Affinity.acquireLock();
                }
                TestTrade bt = new TestTrade();
                MyWriteMarshallable myWriteMarshallable = new MyWriteMarshallable(bt);
                for (int i = 0; i < 1000000; ++i) {
                    Jvm.busyWaitMicros((long)20L);
                    bt.setTime(System.nanoTime());
                    appender.writeDocument((WriteMarshallable)myWriteMarshallable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        });
        tailerThread.start();
        appenderThread.start();
        appenderThread.join();
        Jvm.pause((long)500L);
        System.out.println(histogram.toMicrosFormat());
    }

    static class TestTrade
    implements Marshallable {
        private int price;
        private String id;
        private long time;

        TestTrade() {
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getPrice() {
            return this.price;
        }

        public void setPrice(int price) {
            this.price = price;
        }

        public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
            wire.read(() -> "price").int32((Object)this, (o, b) -> {
                o.price = b;
            }).read(() -> "id").text((Object)this, (o, b) -> {
                o.id = b;
            }).read(() -> "time").int64((Object)this, (o, b) -> {
                o.time = b;
            });
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "price").int32(this.price).write(() -> "id").text(this.id).write(() -> "time").int64(this.time);
        }

        public String toString() {
            return "TestTrade{price=" + this.price + ", id='" + this.id + '\'' + ", time=" + this.time + '}';
        }
    }

    static class MyReadMarshallable
    implements ReadMarshallable {
        final StringBuilder messageType = new StringBuilder();
        final AtomicInteger counter = new AtomicInteger(0);
        final TestTrade testTrade = new TestTrade();
        private final Histogram histogram;

        public MyReadMarshallable(Histogram histogram) {
            this.histogram = histogram;
        }

        public void readMarshallable(@NotNull WireIn wireIn) throws IORuntimeException {
            ValueIn vi = wireIn.readEventName(this.messageType);
            vi.marshallable((ReadMarshallable)this.testTrade);
            long time = this.testTrade.getTime();
            if (this.counter.get() > 100000) {
                this.histogram.sample((double)(System.nanoTime() - time));
            }
            if (this.counter.incrementAndGet() % 100000 == 0) {
                System.out.println(this.counter.get());
            }
        }
    }

    static class MyWriteMarshallable
    implements WriteMarshallable {
        private final TestTrade bt;

        public MyWriteMarshallable(TestTrade bt) {
            this.bt = bt;
        }

        public void writeMarshallable(@NotNull WireOut w) {
            w.write(() -> "TestTrade").marshallable((WriteMarshallable)this.bt);
        }
    }
}

