/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import net.openhft.chronicle.queue.JDBCResult;
import net.openhft.chronicle.queue.JDBCStatement;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class JDBCComponent
implements JDBCStatement {
    private final Connection connection;
    private final JDBCResult result;

    public JDBCComponent(ThrowingSupplier<Connection, SQLException> connectionSupplier, JDBCResult result) throws SQLException {
        this.connection = (Connection)connectionSupplier.get();
        this.result = result;
    }

    @Override
    public void executeUpdate(String query, Object ... args) {
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
            int count = ps.executeUpdate();
            this.result.updateResult(count, query, args);
        }
        catch (Throwable t) {
            this.result.updateThrown(t, query, args);
        }
    }

    @Override
    public void executeQuery(String query, Class<? extends Marshallable> resultType, Object ... args) {
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
            final ResultSet resultSet = ps.executeQuery();
            final ResultSetMetaData metaData = resultSet.getMetaData();
            final int columnCount = metaData.getColumnCount();
            this.result.queryResult(new Iterator<Marshallable>(){

                @Override
                public boolean hasNext() {
                    try {
                        return resultSet.next();
                    }
                    catch (SQLException e) {
                        throw Jvm.rethrow((Throwable)e);
                    }
                }

                @Override
                public Marshallable next() {
                    return new Marshallable(){

                        public void writeMarshallable(@NotNull WireOut wire) {
                            try {
                                for (int i = 1; i <= columnCount; ++i) {
                                    wire.writeEventName((CharSequence)metaData.getCatalogName(i)).object(resultSet.getObject(i));
                                }
                            }
                            catch (SQLException e) {
                                throw Jvm.rethrow((Throwable)e);
                            }
                        }
                    };
                }
            }, query, args);
        }
        catch (Throwable t) {
            this.result.queryThrown(t, query, args);
        }
    }
}

