/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.wire.Wires;

public class DumpQueueMain {
    public static void main(String[] args) {
        DumpQueueMain.dump(args[0]);
    }

    public static void dump(String dir) {
        File[] files = new File(dir).listFiles();
        if (files == null) {
            System.err.println("Directory not found " + dir);
        }
        for (File file : files) {
            if (!file.getName().endsWith(".cq4")) continue;
            try (MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)0x400000L);){
                System.out.println(Wires.fromSizePrefixedBlobs((Bytes)bytes));
            }
            catch (IOException ioe) {
                System.err.println("Failed to read " + file + " " + ioe);
            }
        }
    }
}

