/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestEmptyFile {
    Path tmpDir = DirectoryUtils.tempDir(TestEmptyFile.class.getSimpleName()).toPath();

    @Before
    public void setup() throws Exception {
        this.tmpDir.toFile().mkdirs();
        Path templatePath = Paths.get(OS.USER_DIR, "src/test/resources/tr2/directory-listing.cq4t");
        Path to = this.tmpDir.resolve(templatePath.getFileName());
        Files.copy(templatePath, to, StandardCopyOption.REPLACE_EXISTING);
        File file = this.tmpDir.resolve("20170320.cq4").toFile();
        new FileOutputStream(file).close();
    }

    @After
    public void cleanup() {
        DirectoryUtils.deleteDir(this.tmpDir.toFile());
    }

    @Test
    @Ignore(value="This test  crashes JVM, but even with obvious fixes it will not pass as the queue doesn't know how to progress past the empty/truncated file. Needs investigation if this is a supported situation - see issue #470")
    public void shouldHandleEmptyFile() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)this.tmpDir).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            try (DocumentContext dc = SingleChronicleQueueBuilder.binary((Path)this.tmpDir).testBlockSize().build().acquireAppender().writingDocument();){
                dc.wire().write((CharSequence)"hello").text("world");
            }
            dc = tailer.readingDocument();
            var5_7 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"world", (Object)dc.wire().read("hello").text());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var5_7 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }
}

