/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.service.HelloWorld;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class StoreTailerTest
extends ChronicleQueueTestBase {
    private final Collection<SingleChronicleQueue> createdQueues = new ArrayList<SingleChronicleQueue>();
    private final Path dataDirectory = DirectoryUtils.tempDir(StoreTailerTest.class.getSimpleName()).toPath();

    private static void closeQueues(SingleChronicleQueue ... queues) {
        for (SingleChronicleQueue queue : queues) {
            if (queue == null) continue;
            queue.close();
        }
    }

    @Test
    public void shouldHandleCycleRollWhenInReadOnlyMode() {
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        SingleChronicleQueue queue = this.build(this.createQueue(this.dataDirectory, RollCycles.MINUTELY, 0, "cycleRoll", false).timeProvider((TimeProvider)timeProvider));
        StringEvents events = (StringEvents)queue.acquireAppender().methodWriterBuilder(StringEvents.class).build();
        timeProvider.setTime(System.currentTimeMillis());
        events.onEvent("firstEvent");
        timeProvider.addTime(2L, TimeUnit.MINUTES);
        events.onEvent("secondEvent");
        SingleChronicleQueue readerQueue = this.build(this.createQueue(this.dataDirectory, RollCycles.MINUTELY, 0, "cycleRoll", true).timeProvider((TimeProvider)timeProvider));
        ExcerptTailer tailer = readerQueue.createTailer();
        tailer.toStart();
        try (DocumentContext context = tailer.readingDocument();){
            Assert.assertThat((Object)context.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        }
        tailer.toEnd();
        context = tailer.readingDocument();
        var7_7 = null;
        try {
            Assert.assertThat((Object)context.isPresent(), (Matcher)CoreMatchers.is((Object)false));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (context != null) {
                if (var7_7 != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    context.close();
                }
            }
        }
    }

    @Test
    public void shouldConsiderSourceIdWhenDeterminingLastWrittenIndex() {
        SingleChronicleQueue firstInputQueue = this.createQueue(this.dataDirectory, RollCycles.TEST_DAILY, 1, "firstInputQueue");
        SingleChronicleQueue secondInputQueue = this.createQueue(this.dataDirectory, RollCycles.TEST_SECONDLY, 2, "secondInputQueue");
        SingleChronicleQueue outputQueue = this.createQueue(this.dataDirectory, RollCycles.TEST_DAILY, 0, "outputQueue");
        StringEvents firstWriter = (StringEvents)firstInputQueue.acquireAppender().methodWriterBuilder(StringEvents.class).get();
        HelloWorld secondWriter = (HelloWorld)secondInputQueue.acquireAppender().methodWriterBuilder(HelloWorld.class).get();
        firstWriter.onEvent("one");
        firstWriter.onEvent("two");
        secondWriter.hello("thirteen");
        secondWriter.hello("thirtyOne");
        StringEvents eventSink = (StringEvents)outputQueue.acquireAppender().methodWriterBuilder(StringEvents.class).recordHistory(true).get();
        CapturingStringEvents outputWriter = new CapturingStringEvents(eventSink);
        MethodReader firstMethodReader = firstInputQueue.createTailer().methodReader(new Object[]{outputWriter});
        MethodReader secondMethodReader = secondInputQueue.createTailer().methodReader(new Object[]{outputWriter});
        Assert.assertThat((Object)firstMethodReader.readOne(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)firstMethodReader.readOne(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)secondMethodReader.readOne(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)secondMethodReader.readOne(), (Matcher)CoreMatchers.is((Object)true));
        secondInputQueue.createTailer().afterLastWritten((ChronicleQueue)outputQueue);
    }

    @Test
    public void shouldHandleCycleRoll() {
        File dir = this.getTmpDir();
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        timeProvider.setTime(System.currentTimeMillis());
        try (SingleChronicleQueue chronicle = this.minutely(dir, timeProvider).build();
             SingleChronicleQueue chronicle2 = this.minutely(dir, timeProvider).build();){
            ExcerptTailer tailer = chronicle.createTailer();
            timeProvider.addTime(10L, TimeUnit.MINUTES);
            ExcerptAppender append = chronicle2.acquireAppender();
            append.writeDocument(w -> w.write(() -> "test").text("text"));
            Assert.assertTrue((boolean)tailer.readDocument(w -> w.read(() -> "test").text((Object)"text", Assert::assertEquals)));
        }
    }

    private SingleChronicleQueueBuilder minutely(@NotNull File file, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)WireType.BINARY).rollCycle((RollCycle)RollCycles.MINUTELY).testBlockSize().timeProvider(timeProvider);
    }

    @After
    public void after() {
        StoreTailerTest.closeQueues(this.createdQueues.toArray(new SingleChronicleQueue[0]));
    }

    @NotNull
    private SingleChronicleQueue createQueue(Path dataDirectory, RollCycles rollCycle, int sourceId, String subdirectory) {
        return this.build(this.createQueue(dataDirectory, rollCycle, sourceId, subdirectory, false));
    }

    @NotNull
    private SingleChronicleQueueBuilder createQueue(Path dataDirectory, RollCycles rollCycle, int sourceId, String subdirectory, boolean readOnly) {
        return SingleChronicleQueueBuilder.binary((Path)dataDirectory.resolve(Paths.get(subdirectory, new String[0]))).sourceId(sourceId).testBlockSize().rollCycle((RollCycle)rollCycle).readOnly(readOnly);
    }

    private SingleChronicleQueue build(SingleChronicleQueueBuilder builder) {
        SingleChronicleQueue queue = builder.build();
        this.createdQueues.add(queue);
        return queue;
    }

    private static final class MutableTimeProvider
    implements TimeProvider {
        private long currentTimeMillis;

        private MutableTimeProvider() {
        }

        public long currentTimeMillis() {
            return this.currentTimeMillis;
        }

        void setTime(long millis) {
            this.currentTimeMillis = millis;
        }

        void addTime(long duration, TimeUnit unit) {
            this.currentTimeMillis += unit.toMillis(duration);
        }
    }

    private static final class CapturingStringEvents
    implements StringEvents {
        private final StringEvents delegate;

        CapturingStringEvents(StringEvents delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEvent(String event) {
            this.delegate.onEvent(event);
        }
    }

    @FunctionalInterface
    public static interface StringEvents {
        public void onEvent(String var1);
    }
}

